/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.route.jdbc.core.connection;

import cn.com.yusys.yusp.commons.route.jdbc.adapter.AbstractConnectionAdapter;
import cn.com.yusys.yusp.commons.route.jdbc.core.connection.DataRouteHandler;
import cn.com.yusys.yusp.commons.util.StringUtils;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Statement;
import java.util.Map;
import javax.sql.DataSource;

public final class YuspConnection
extends AbstractConnectionAdapter {
    private final Map<String, DataSource> dataSourceMap;
    private String defaultDataSourceName = null;

    public YuspConnection(Map<String, DataSource> dataSourceMap, String defaultDataSourceName) {
        this.dataSourceMap = dataSourceMap;
        this.defaultDataSourceName = defaultDataSourceName;
    }

    @Override
    protected Connection createConnection(String dataSourceName, DataSource dataSource) throws SQLException {
        if (null != dataSource) {
            return dataSource.getConnection();
        }
        return this.getConnections(dataSourceName, 1).get(0);
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        String dataSourceName = this.getDataSourceName();
        return this.getConnections(dataSourceName, 1).get(0).prepareStatement(sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        String dataSourceName = this.getDataSourceName();
        return this.getConnections(dataSourceName, 1).get(0).prepareStatement(sql, resultSetType, resultSetConcurrency);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        String dataSourceName = this.getDataSourceName();
        return this.getConnections(dataSourceName, 1).get(0).prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        String dataSourceName = this.getDataSourceName();
        return this.getConnections(dataSourceName, 1).get(0).prepareStatement(sql, autoGeneratedKeys);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        String dataSourceName = this.getDataSourceName();
        return this.getConnections(dataSourceName, 1).get(0).prepareStatement(sql, columnIndexes);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        String dataSourceName = this.getDataSourceName();
        return this.getConnections(dataSourceName, 1).get(0).prepareStatement(sql, columnNames);
    }

    @Override
    public Statement createStatement() throws SQLException {
        String dataSourceName = this.getDataSourceName();
        return this.getConnections(dataSourceName, 1).get(0).createStatement();
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        String dataSourceName = this.getDataSourceName();
        return this.getConnections(dataSourceName, 1).get(0).createStatement(resultSetType, resultSetConcurrency);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        String dataSourceName = this.getDataSourceName();
        return this.getConnections(dataSourceName, 1).get(0).createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public Map<String, DataSource> getDataSourceMap() {
        return this.dataSourceMap;
    }

    @Override
    protected Connection getMainConnection() throws SQLException {
        if (!StringUtils.equals((CharSequence)this.getDataSourceName(), (CharSequence)this.defaultDataSourceName)) {
            throw new SQLFeatureNotSupportedException("Not Main datasource unSupported Operation.");
        }
        return this.getConnections(this.defaultDataSourceName, 1).get(0);
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        return this.getConnections(this.defaultDataSourceName, 1).get(0).getMetaData();
    }

    @Override
    public final CallableStatement prepareCall(String sql) throws SQLException {
        String dataSourceName = this.getDataSourceName();
        return this.getConnections(dataSourceName, 1).get(0).prepareCall(sql);
    }

    @Override
    public final CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        String dataSourceName = this.getDataSourceName();
        return this.getConnections(dataSourceName, 1).get(0).prepareCall(sql, resultSetType, resultSetConcurrency);
    }

    @Override
    public final CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        String dataSourceName = this.getDataSourceName();
        return this.getConnections(dataSourceName, 1).get(0).prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    private String getDataSourceName() {
        String dataSourceName = DataRouteHandler.DataSourceName.get();
        if (null == dataSourceName) {
            dataSourceName = this.defaultDataSourceName;
        }
        return dataSourceName;
    }
}

