/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.crypt;

import cn.com.yusys.yusp.commons.crypt.DecryptPropertyService;
import cn.com.yusys.yusp.commons.util.StringUtils;
import com.ulisesbocchio.jasyptspringboot.EncryptablePropertyResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EncryptionPropertyResolver
implements EncryptablePropertyResolver {
    private static final Logger logger = LoggerFactory.getLogger(EncryptionPropertyResolver.class);
    public static final String PROPERTY_VALUE_PREFIX = "DECRYPT";
    public static final int ENCRYPT_INDEX_PREFIX_LENGTH = "DECRYPT".length() + 1;
    private DecryptPropertyService decryptService;

    public EncryptionPropertyResolver(DecryptPropertyService decryptService) {
        this.decryptService = decryptService;
    }

    public String resolvePropertyValue(String value) {
        if (StringUtils.isEmpty((CharSequence)value)) {
            return value;
        }
        if (value.startsWith(PROPERTY_VALUE_PREFIX)) {
            if (logger.isDebugEnabled()) {
                logger.debug("The current value to decrypt is: {}", (Object)value);
            }
            return this.decryptService.doDecrypt(value.substring(ENCRYPT_INDEX_PREFIX_LENGTH));
        }
        return value;
    }
}

