/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.context.util;

import brave.propagation.Propagation;
import cn.com.yusys.yusp.commons.context.ContextProcessor;
import cn.com.yusys.yusp.commons.context.brave.ContextHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContextHolderUtils {
    private static final Logger log = LoggerFactory.getLogger(ContextHolderUtils.class);

    private ContextHolderUtils() {
    }

    public static <C, K> void extraContext(ContextProcessor<K> contextProcessor, C carrier, Propagation.Getter<C, K> getter) {
        try {
            ContextHolder contextHolder = contextProcessor.extract(carrier, getter);
            if (ContextHolder.exists()) {
                contextHolder.getItems().forEach((key, value) -> ContextHolder.putContext(value));
            } else {
                log.info("Not Exists Trace Context. Will Not write response Context.");
            }
        }
        catch (Exception e) {
            log.info("Write Context into current failed. Exception message:{}", (Object)e.getMessage());
        }
    }
}

