/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.context.header.resolver;

import cn.com.yusys.yusp.commons.context.exception.ContextException;
import cn.com.yusys.yusp.commons.context.header.RequestBodyHolder;
import cn.com.yusys.yusp.commons.context.header.process.MessageProcessor;
import cn.com.yusys.yusp.commons.context.util.RequestHolderUtils;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.MethodParameter;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.validation.Errors;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;

public abstract class AbstractMessageAnnotationMethodArgumentResolver
implements HandlerMethodArgumentResolver {
    private final Logger log = LoggerFactory.getLogger(AbstractMessageAnnotationMethodArgumentResolver.class);
    private final MessageProcessor messageProcessor;
    private HandlerMethodArgumentResolver requestResponseBodyMethodProcessor;

    protected AbstractMessageAnnotationMethodArgumentResolver(MessageProcessor messageProcessor) {
        this.messageProcessor = messageProcessor;
    }

    public MessageProcessor getMessageProcessor() {
        return this.messageProcessor;
    }

    public void setRequestResponseBodyMethodProcessor(HandlerMethodArgumentResolver handlerMethodArgumentResolver) {
        this.requestResponseBodyMethodProcessor = handlerMethodArgumentResolver;
    }

    public Object resolveArgument(@NonNull MethodParameter parameter, ModelAndViewContainer mavContainer, @Nullable NativeWebRequest webRequest, WebDataBinderFactory binderFactory) throws Exception {
        RequestHolderUtils.putMethodAttrIfNotAbsent(parameter.getMethod());
        Object params = this.parseParams(mavContainer, webRequest, binderFactory);
        Object result = this.resolveBodyArgument(parameter, params);
        this.validateIfRequired(result, parameter);
        this.validateInternal(parameter, result, webRequest, binderFactory);
        return result;
    }

    protected Object parseParams(ModelAndViewContainer mavContainer, NativeWebRequest webRequest, WebDataBinderFactory binderFactory) throws Exception {
        Object params = RequestBodyHolder.getRequest();
        if (Objects.isNull(params)) {
            MethodParameter requestParameter = RequestBodyHolder.requestMethodParameter();
            try {
                params = this.requestResponseBodyMethodProcessor.resolveArgument(requestParameter, mavContainer, webRequest, binderFactory);
            }
            catch (Exception e) {
                this.log.warn("Parse RequestBody exception.", (Throwable)e);
                return null;
            }
            RequestBodyHolder.setRequest(params);
        }
        return params;
    }

    protected abstract Object resolveBodyArgument(MethodParameter var1, Object var2);

    private void validateIfRequired(Object result, MethodParameter parameter) {
        boolean required = this.isRequired(parameter);
        if (required && Objects.isNull(result)) {
            throw new ContextException("parameter[" + parameter.getParameterName() + "] is required,but is null");
        }
    }

    protected abstract boolean isRequired(MethodParameter var1);

    protected abstract void validateInternal(MethodParameter var1, Object var2, NativeWebRequest var3, WebDataBinderFactory var4);

    protected boolean isBindExceptionRequired(WebDataBinder binder, MethodParameter parameter) {
        int i = parameter.getParameterIndex();
        Class<?>[] paramTypes = parameter.getExecutable().getParameterTypes();
        boolean hasBindingResult = paramTypes.length > i + 1 && Errors.class.isAssignableFrom(paramTypes[i + 1]);
        return !hasBindingResult;
    }
}

