/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.context.util;

import brave.Span;
import brave.Tracer;
import brave.Tracing;
import brave.propagation.Propagation;
import brave.propagation.TraceContext;
import brave.propagation.TraceContextOrSamplingFlags;
import cn.com.yusys.yusp.commons.util.SpringContextUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.springframework.lang.Nullable;

public class SleuthTraceUtil {
    static final Propagation.Getter<Map<String, String>, String> GETTER = new Propagation.Getter<Map<String, String>, String>(){

        public String get(Map<String, String> carrier, String key) {
            return carrier.get(key);
        }

        public String toString() {
            return "custom::setHeader";
        }
    };

    private SleuthTraceUtil() {
    }

    public static Span generateSpan(Map<String, String> header, String spanName) {
        if (null == header) {
            header = new HashMap<String, String>();
        }
        if (null == spanName) {
            spanName = "customSpan";
        }
        Tracing tracing = (Tracing)SpringContextUtils.getBean(Tracing.class);
        TraceContext.Extractor extractor = tracing.propagation().extractor(GETTER);
        TraceContextOrSamplingFlags extracted = extractor.extract(header);
        Tracer tracer = tracing.tracer();
        Span consumerSpan = tracer.nextSpan(extracted).kind(Span.Kind.CONSUMER).name(spanName);
        tracer.withSpanInScope(consumerSpan);
        return consumerSpan;
    }

    public static void closeSpan(Span span) {
        if (null != span) {
            span.finish();
        }
    }

    public static void scope(String spanName, Map<String, String> header, Runnable runnable) {
        try (Tracer.SpanInScope scope = SleuthTraceUtil.newScope(spanName, header);){
            runnable.run();
        }
    }

    public static Tracer.SpanInScope newScope(String spanName, @Nullable Map<String, String> header) {
        if (Objects.isNull(header)) {
            header = new HashMap<String, String>();
        }
        if (Objects.isNull(spanName)) {
            spanName = "customSpan";
        }
        Tracing tracing = (Tracing)SpringContextUtils.getBean(Tracing.class);
        TraceContext.Extractor extractor = tracing.propagation().extractor(GETTER);
        TraceContextOrSamplingFlags extracted = extractor.extract(header);
        Tracer tracer = tracing.tracer();
        Span span = tracer.nextSpan(extracted).kind(Span.Kind.CONSUMER).name(spanName);
        return tracer.withSpanInScope(span);
    }

    public static void closeScope(Tracer.SpanInScope scope) {
        if (Objects.nonNull(scope)) {
            scope.close();
        }
    }
}

