/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.context.header.resolver;

import cn.com.yusys.yusp.commons.context.header.annonation.MessageHeader;
import cn.com.yusys.yusp.commons.context.header.process.MessageProcessor;
import cn.com.yusys.yusp.commons.context.header.resolver.AbstractMessageAnnotationMethodArgumentResolver;
import cn.com.yusys.yusp.commons.util.ObjectMapperUtils;
import cn.com.yusys.yusp.commons.util.StringUtils;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.MethodParameter;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;

public class MessageHeaderMethodProcessor
extends AbstractMessageAnnotationMethodArgumentResolver {
    private final Logger log = LoggerFactory.getLogger(MessageHeaderMethodProcessor.class);

    public MessageHeaderMethodProcessor(MessageProcessor messageHeaderHelper) {
        super(messageHeaderHelper);
    }

    @Override
    protected void validateInternal(MethodParameter parameter, Object result, NativeWebRequest webRequest, WebDataBinderFactory binderFactory) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("validateInternal exe");
        }
    }

    @Override
    protected boolean isRequired(MethodParameter parameter) {
        return ((MessageHeader)Objects.requireNonNull(parameter.getParameterAnnotation(MessageHeader.class))).required();
    }

    @Override
    protected Object resolveBodyArgument(MethodParameter parameter, Object params) {
        Object param;
        if (Objects.isNull(params)) {
            this.log.warn("Missing RequestBody,Can't resolve param:{} with annotation @MessageHeader.", (Object)parameter.getParameterName());
            return null;
        }
        if (!(params instanceof Map)) {
            this.log.warn("RequestBody not is Map,Can't Parse MessageHeader.");
            return null;
        }
        MessageHeader messageHeader = (MessageHeader)parameter.getParameterAnnotation(MessageHeader.class);
        String name = Optional.ofNullable(messageHeader).map(MessageHeader::value).orElse("");
        if (StringUtils.isEmpty((CharSequence)name)) {
            name = parameter.getParameterName();
        }
        if (Objects.isNull(param = ((Map)params).get(name))) {
            this.log.warn("RequestBody not exist key:{}", (Object)name);
            return null;
        }
        Type parameterType = parameter.getGenericParameterType();
        try {
            return ObjectMapperUtils.instance().convertValue(param, TypeFactory.defaultInstance().constructType(parameterType));
        }
        catch (Exception e) {
            this.log.warn(String.format("Convert body to [%s] failed.", parameterType.getTypeName()), (Throwable)e);
            return null;
        }
    }

    public boolean supportsParameter(MethodParameter parameter) {
        return parameter.hasParameterAnnotation(MessageHeader.class);
    }
}

