/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.context.header;

import cn.com.yusys.yusp.commons.context.header.process.MessageProcessor;
import cn.com.yusys.yusp.commons.context.util.RequestHolderUtils;
import java.lang.reflect.Type;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.MethodParameter;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.lang.NonNull;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.servlet.mvc.method.annotation.RequestBodyAdviceAdapter;

@ControllerAdvice
public class RequestContextInAdvice
extends RequestBodyAdviceAdapter {
    private final Logger log = LoggerFactory.getLogger(RequestContextInAdvice.class);
    private MessageProcessor messageProcessor;

    public RequestContextInAdvice(MessageProcessor messageProcessor) {
        this.messageProcessor = messageProcessor;
    }

    public boolean supports(MethodParameter methodParameter, Type targetType, Class<? extends HttpMessageConverter<?>> converterType) {
        return true;
    }

    public Object afterBodyRead(@NonNull Object body, HttpInputMessage inputMessage, MethodParameter parameter, Type targetType, Class<? extends HttpMessageConverter<?>> converterType) {
        this.log.debug("Before controller invoke, extract service context.");
        if (this.log.isDebugEnabled()) {
            ServletRequestAttributes requestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
            if (Objects.isNull(requestAttributes)) {
                this.log.debug("Cannot fetch request url from RequestContextHolder.");
            } else {
                HttpServletRequest request = requestAttributes.getRequest();
                this.log.debug("Request:{},RequestBody:{}", (Object)request.getRequestURI(), body);
            }
        }
        RequestHolderUtils.putMethodAttrIfNotAbsent(parameter.getMethod());
        this.messageProcessor.processIn(body);
        return body;
    }
}

