/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.context.feign;

import cn.com.yusys.yusp.commons.context.ContextProcessor;
import cn.com.yusys.yusp.commons.context.ContextProcessorFactory;
import cn.com.yusys.yusp.commons.context.brave.ContextHolder;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.MethodParameter;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.http.server.ServletServerHttpResponse;
import org.springframework.lang.NonNull;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice;

@ControllerAdvice
public class EnhanceContextResponseOutAdvice
implements ResponseBodyAdvice<Object> {
    private static final Logger logger = LoggerFactory.getLogger(EnhanceContextResponseOutAdvice.class);
    private final ContextProcessor<String> contextProcessor;

    public EnhanceContextResponseOutAdvice(ContextProcessorFactory contextProcessorFactory) {
        this.contextProcessor = contextProcessorFactory.create(name -> name);
    }

    public boolean supports(MethodParameter returnType, Class<? extends HttpMessageConverter<?>> converterType) {
        return true;
    }

    public Object beforeBodyWrite(Object body, @NonNull MethodParameter returnType, @NonNull MediaType selectedContentType, @NonNull Class<? extends HttpMessageConverter<?>> selectedConverterType, @NonNull ServerHttpRequest request, @NonNull ServerHttpResponse response) {
        try {
            ContextHolder.load().ifPresent(contextHolder -> {
                HttpServletResponse servletResponse = ((ServletServerHttpResponse)response).getServletResponse();
                this.contextProcessor.inject(servletResponse, HttpServletResponse::addHeader, (ContextHolder)contextHolder);
            });
        }
        catch (Exception e) {
            logger.warn("Inject ContextHolder into Response failure.", (Throwable)e);
        }
        return body;
    }
}

