/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.context.brave;

import brave.propagation.Propagation;
import cn.com.yusys.yusp.commons.context.ContextProcessor;
import cn.com.yusys.yusp.commons.context.brave.ContextHolder;
import cn.com.yusys.yusp.commons.context.exception.ContextException;
import cn.com.yusys.yusp.commons.util.ObjectMapperUtils;
import cn.com.yusys.yusp.commons.util.StringUtils;
import cn.com.yusys.yusp.commons.util.collection.CollectionUtils;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ClassUtils;

public class TraceContextProcessor<K>
implements ContextProcessor<K> {
    private static final Logger log = LoggerFactory.getLogger(TraceContextProcessor.class);
    private final Propagation.KeyFactory<K> keyFactory;

    public TraceContextProcessor(Propagation.KeyFactory<K> keyFactory) {
        this.keyFactory = keyFactory;
    }

    @Override
    public <C> void inject(C carrier, Propagation.Setter<C, K> setter, ContextHolder holder) {
        if (holder != null && !holder.items.isEmpty()) {
            try {
                String[] itemKeys = holder.items.keySet().toArray(new String[0]);
                ObjectMapper objectMapper = ObjectMapperUtils.instance();
                setter.put(carrier, this.keyFactory.create("context-prop"), URLEncoder.encode(objectMapper.writeValueAsString((Object)itemKeys), "utf-8"));
                for (Map.Entry<String, Object> entry : holder.items.entrySet()) {
                    setter.put(carrier, this.keyFactory.create(URLEncoder.encode("context-prop-" + entry.getKey(), "utf-8")), URLEncoder.encode(objectMapper.writeValueAsString(entry.getValue()), "utf-8"));
                }
            }
            catch (JsonProcessingException | UnsupportedEncodingException e) {
                throw new ContextException("Inject context in carrier failure", e);
            }
        }
    }

    @Override
    public <C> ContextHolder extract(C carrier, Propagation.Getter<C, K> getter) {
        ContextHolder contextHolder = new ContextHolder();
        try {
            String value = getter.get(carrier, this.keyFactory.create("context-prop"));
            if (StringUtils.nonEmpty((CharSequence)value)) {
                ObjectMapper objectMapper = ObjectMapperUtils.instance();
                Object[] itemKeys = (String[])objectMapper.readValue(URLDecoder.decode(value, "utf-8"), String[].class);
                Map<String, Object> items = contextHolder.items;
                if (CollectionUtils.nonEmpty((Object[])itemKeys)) {
                    Arrays.stream(itemKeys).filter(itemKey -> ClassUtils.isPresent((String)itemKey, null)).forEach(itemKey -> this.extractItem((String)itemKey, carrier, getter, objectMapper, items));
                }
            }
            return contextHolder;
        }
        catch (IOException e) {
            throw new ContextException("Extract ContextHolder failure", e);
        }
    }

    <C> void extractItem(String itemKey, C carrier, Propagation.Getter<C, K> getter, ObjectMapper objectMapper, Map<String, Object> items) {
        try {
            String item = getter.get(carrier, this.keyFactory.create(URLEncoder.encode("context-prop-" + itemKey, "utf-8")));
            items.put(itemKey, objectMapper.readValue(URLDecoder.decode(item, "utf-8"), Class.forName(itemKey)));
        }
        catch (IOException | ClassNotFoundException e) {
            log.warn(String.format("extract context item :%s failure.", itemKey), (Throwable)e);
        }
    }
}

