/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.config.apollo;

import cn.com.yusys.yusp.commons.config.apollo.Apollo;
import cn.com.yusys.yusp.commons.config.apollo.ApolloConfigTemplate;
import cn.com.yusys.yusp.commons.config.exception.ConfigException;
import com.ctrip.framework.apollo.openapi.client.ApolloOpenApiClient;
import com.ctrip.framework.apollo.openapi.dto.NamespaceReleaseDTO;
import com.ctrip.framework.apollo.openapi.dto.OpenItemDTO;
import java.util.Date;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.StringUtils;

public class OpenApiApolloConfigTemplate
extends ApolloConfigTemplate
implements InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(OpenApiApolloConfigTemplate.class);
    private ApolloOpenApiClient client;
    private final Apollo apollo;

    public OpenApiApolloConfigTemplate(Apollo apollo) {
        this.apollo = apollo;
    }

    public void afterPropertiesSet() {
        log.info("initialize apollo open-api client, portalUrl={}, token={}", (Object)this.apollo.getPortalUrl(), (Object)this.apollo.getToken());
        if (!StringUtils.isEmpty((Object)this.apollo.getPortalUrl()) && !StringUtils.isEmpty((Object)this.apollo.getToken())) {
            this.client = ApolloOpenApiClient.newBuilder().withPortalUrl(this.apollo.getPortalUrl()).withToken(this.apollo.getToken()).build();
            log.info("initialize apollo open-api client success");
        }
    }

    @Override
    public boolean publishProperty(String dataId, String key, String value) {
        try {
            boolean isProperties;
            String extension = this.parseExtension(dataId);
            if (StringUtils.isEmpty((Object)key)) {
                throw new ConfigException("key\u4e0d\u80fd\u4e3a\u7a7a");
            }
            boolean isRouteStrategy = StringUtils.endsWithIgnoreCase((String)"xml", (String)extension) && "yusp-route-strategy.xml".equals(key);
            boolean bl = isProperties = !StringUtils.endsWithIgnoreCase((String)"properties", (String)extension) && !StringUtils.endsWithIgnoreCase((String)"content", (String)key);
            if (!isRouteStrategy && isProperties) {
                throw new ConfigException("\u53ea\u6709properties\u7c7b\u578b\u6587\u4ef6\u652f\u6301\u914d\u7f6e\u9879\u66f4\u65b0");
            }
            String namespace = dataId;
            if ("properties".equals(extension)) {
                int index = dataId.lastIndexOf(".");
                namespace = dataId.substring(0, index);
            }
            OpenItemDTO item = new OpenItemDTO();
            item.setKey(key);
            item.setValue(value);
            item.setDataChangeCreatedBy(this.apollo.getModifiedBy());
            item.setDataChangeCreatedTime(new Date());
            this.client.createOrUpdateItem(this.apollo.getAppId(), this.apollo.getEnv(), null, namespace, item);
            log.info("update apollo config item success, appId:{}, env:{}, namespace:{}, key:{}", new Object[]{this.apollo.getAppId(), this.apollo.getEnv(), namespace, key});
            TimeUnit.MILLISECONDS.sleep(500L);
            NamespaceReleaseDTO releaseDTO = new NamespaceReleaseDTO();
            releaseDTO.setReleaseTitle("update by program");
            releaseDTO.setReleasedBy(this.apollo.getModifiedBy());
            releaseDTO.setEmergencyPublish(true);
            releaseDTO.setReleaseComment("");
            this.client.publishNamespace(this.apollo.getAppId(), this.apollo.getEnv(), null, namespace, releaseDTO);
            log.info("publish apollo config item success, appId:{}, env:{}, namespace:{}, key:{}", new Object[]{this.apollo.getAppId(), this.apollo.getEnv(), namespace, key});
            return true;
        }
        catch (Exception e) {
            String exceptionTips = String.format("\u66f4\u65b0\u914d\u7f6e\u9879\u5f02\u5e38, dataId:%s, key:%s, value:%s", dataId, key, value);
            throw new ConfigException(exceptionTips, (Throwable)e);
        }
    }

    @Override
    public boolean publishConfig(String dataId, String value) {
        String extension = this.parseExtension(dataId);
        if ("properties".equals(extension)) {
            throw new ConfigException("properties\u7c7b\u578b\u6587\u4ef6\u4e0d\u652f\u6301\u5168\u91cf\u66f4\u65b0");
        }
        return this.publishProperty(dataId, "content", value);
    }

    @Override
    public String getConfig(String dataId) {
        String extension = this.parseExtension(dataId);
        if ("properties".equals(extension)) {
            throw new ConfigException("properties\u7c7b\u578b\u6587\u4ef6\u4e0d\u652f\u6301\u5168\u91cf\u83b7\u53d6");
        }
        String key = StringUtils.endsWithIgnoreCase((String)dataId, (String)"yusp-route-strategy.xml") ? "yusp-route-strategy.xml" : "content";
        OpenItemDTO dto = this.client.getItem(this.apollo.getAppId(), this.apollo.getEnv(), null, dataId, key);
        return Optional.ofNullable(dto).map(OpenItemDTO::getValue).orElse("");
    }

    @Override
    public String getProperty(String dataId, String key, String defaultValue) {
        OpenItemDTO dto;
        String extension = this.parseExtension(dataId);
        if (StringUtils.isEmpty((Object)key)) {
            throw new ConfigException("key\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!"properties".equals(extension) && !StringUtils.endsWithIgnoreCase((String)"content", (String)key)) {
            throw new ConfigException("\u53ea\u6709properties\u7c7b\u578b\u6587\u4ef6\u652f\u6301\u914d\u7f6e\u9879\u83b7\u53d6");
        }
        String namespace = dataId;
        if ("properties".equals(extension)) {
            int index = dataId.lastIndexOf(".");
            namespace = dataId.substring(0, index);
        }
        return (dto = this.client.getItem(this.apollo.getAppId(), this.apollo.getEnv(), null, namespace, key)) == null || StringUtils.isEmpty((Object)dto.getValue()) ? defaultValue : dto.getValue();
    }

    public boolean removeConfig() {
        try {
            this.client.removeItem(this.apollo.getAppId(), this.apollo.getEnv(), null, "yusp-route-strategy.xml", "yusp-route-strategy.xml", this.apollo.getModifiedBy());
            TimeUnit.MILLISECONDS.sleep(500L);
            NamespaceReleaseDTO releaseDTO = new NamespaceReleaseDTO();
            releaseDTO.setReleaseTitle("remove xml config");
            releaseDTO.setReleasedBy(this.apollo.getModifiedBy());
            releaseDTO.setEmergencyPublish(true);
            releaseDTO.setReleaseComment("");
            this.client.publishNamespace(this.apollo.getAppId(), this.apollo.getEnv(), null, "yusp-route-strategy.xml", releaseDTO);
            return true;
        }
        catch (Exception e) {
            throw new ConfigException("apollo remove config failure!");
        }
    }
}

