/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.config.local;

import cn.com.yusys.yusp.commons.config.core.ChangeListener;
import cn.com.yusys.yusp.commons.config.core.ConfigTemplate;
import cn.com.yusys.yusp.commons.util.StringUtils;
import java.io.IOException;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.ResourcePropertySource;

public class LocalConfigTemplate
implements ConfigTemplate {
    private static final Logger logger = LoggerFactory.getLogger(LocalConfigTemplate.class);
    ConfigurableEnvironment environment;

    public LocalConfigTemplate(ConfigurableEnvironment environment) {
        this.environment = environment;
    }

    public void addListener(String dataId, Set<String> interestedKeys, ChangeListener listener) {
        logger.warn("Current operate unsupported!");
    }

    public void addListener(String dataId, ChangeListener listener) {
        logger.warn("Current operate unsupported!");
    }

    public boolean removeListener(String dataId, ChangeListener listener) {
        logger.warn("Current operate unsupported!");
        return false;
    }

    public boolean publishProperty(String dataId, String key, String value) {
        logger.warn("Current operate unsupported!");
        return false;
    }

    public boolean publishConfig(String dataId, String value) {
        logger.warn("Current operate unsupported!");
        return false;
    }

    public String getConfig(String dataId) {
        if (StringUtils.nonEmpty((CharSequence)dataId) && dataId.endsWith(".properties")) {
            PropertySource propertySource = this.environment.getPropertySources().stream().filter(ps -> ps.getName().startsWith("classpath") && ps.getName().endsWith(dataId)).findFirst().orElse(null);
            return propertySource != null ? propertySource.getSource().toString() : null;
        }
        return null;
    }

    public String getProperty(String dataId, String key, String defaultValue) {
        PropertySource propertySource = this.environment.getPropertySources().stream().filter(ps -> ps.getName().startsWith("classpath") && ps.getName().endsWith(dataId)).findFirst().orElse(null);
        if (propertySource != null) {
            return Optional.ofNullable(StringUtils.replaceObjNull((Object)propertySource.getProperty(key))).orElse(defaultValue);
        }
        try {
            ClassPathResource resource = new ClassPathResource("classpath:" + dataId);
            ResourcePropertySource ps2 = new ResourcePropertySource("classpath:" + dataId, (Resource)resource);
            this.environment.getPropertySources().addLast((PropertySource)ps2);
            return Optional.ofNullable(StringUtils.replaceObjNull((Object)ps2.getProperty(key))).orElse(defaultValue);
        }
        catch (IOException iOException) {
            return null;
        }
    }
}

