/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.config.apollo;

import cn.com.yusys.yusp.commons.config.apollo.CloudConfigChangeListener;
import cn.com.yusys.yusp.commons.config.apollo.ConfigurationPropertiesRefreshListener;
import cn.com.yusys.yusp.commons.util.ReflectionUtils;
import com.ctrip.framework.apollo.Config;
import com.ctrip.framework.apollo.ConfigChangeListener;
import com.ctrip.framework.apollo.ConfigService;
import com.ctrip.framework.apollo.build.ApolloInjector;
import com.ctrip.framework.apollo.internals.ConfigManager;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.core.PriorityOrdered;

public class ApolloConfigChangeListenerPostProcessor
implements BeanPostProcessor,
PriorityOrdered {
    private static final Logger log = LoggerFactory.getLogger(ApolloConfigChangeListenerPostProcessor.class);

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof CloudConfigChangeListener || bean instanceof ConfigurationPropertiesRefreshListener) {
            Set<String> namespaces = this.getAllNamespaces();
            for (String namespace : namespaces) {
                Config config = ConfigService.getConfig((String)namespace);
                config.addChangeListener((ConfigChangeListener)bean);
            }
        }
        return bean;
    }

    private Set<String> getAllNamespaces() {
        ConfigManager configManager = (ConfigManager)ApolloInjector.getInstance(ConfigManager.class);
        Map configMap = (Map)ReflectionUtils.getPropertyValue((Object)configManager, (String)"m_configs");
        return configMap.keySet();
    }

    public int getOrder() {
        return -2147483647;
    }
}

