/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.config.nacos;

import cn.com.yusys.yusp.commons.config.constant.ConfigConstants;
import cn.com.yusys.yusp.commons.config.core.AbstractConfigTemplate;
import cn.com.yusys.yusp.commons.config.core.ChangeEvent;
import cn.com.yusys.yusp.commons.config.core.ChangeItem;
import cn.com.yusys.yusp.commons.config.core.ChangeListener;
import cn.com.yusys.yusp.commons.config.exception.ConfigException;
import com.alibaba.cloud.nacos.NacosConfigManager;
import com.alibaba.cloud.nacos.NacosConfigProperties;
import com.alibaba.nacos.api.config.ConfigChangeEvent;
import com.alibaba.nacos.api.config.ConfigChangeItem;
import com.alibaba.nacos.api.config.ConfigService;
import com.alibaba.nacos.api.config.listener.Listener;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.client.config.impl.YmlChangeParser;
import com.alibaba.nacos.client.config.listener.impl.AbstractConfigChangeListener;
import java.io.StringReader;
import java.util.Collection;
import java.util.Collections;
import java.util.Properties;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class NacosConfigTemplate
extends AbstractConfigTemplate<ConfigChangeEvent, Listener> {
    private static final Logger log = LoggerFactory.getLogger(NacosConfigTemplate.class);
    private final ConfigService configService;
    private final String group;
    private final YmlChangeParser ymlChangeParser = new YmlChangeParser();

    public NacosConfigTemplate(NacosConfigManager nacosConfigManager) {
        NacosConfigProperties props = nacosConfigManager.getNacosConfigProperties();
        this.group = props.getGroup();
        this.configService = nacosConfigManager.getConfigService();
    }

    public void addListener(final String dataId, Set<String> interestedKeys, final ChangeListener changeListener) {
        if (interestedKeys == null) {
            interestedKeys = Collections.emptySet();
        }
        final Set<String> finalInterestedKeys = interestedKeys;
        AbstractConfigChangeListener listener = new AbstractConfigChangeListener(){

            public void receiveConfigChange(ConfigChangeEvent event) {
                ChangeEvent target = NacosConfigTemplate.this.transform(dataId, event, (Set<String>)finalInterestedKeys);
                if (!target.isEmpty()) {
                    try {
                        changeListener.onChange(target);
                    }
                    catch (RuntimeException e) {
                        log.error("onChange of {} invoke failure, dataId:{}", changeListener.getClass(), (Object)dataId);
                        throw e;
                    }
                }
            }
        };
        try {
            this.listenerMap.putIfAbsent(changeListener, listener);
            this.configService.addListener(dataId, this.group, (Listener)listener);
        }
        catch (NacosException e) {
            throw new ConfigException("add listener exception", (Throwable)e);
        }
    }

    public void addListener(final String dataId, final ChangeListener changeListener) {
        String extension = this.parseExtension(dataId);
        if ("properties".equals(extension)) {
            this.addListener(dataId, Collections.emptySet(), changeListener);
        } else {
            AbstractConfigChangeListener listener = new AbstractConfigChangeListener(){

                public void receiveConfigChange(ConfigChangeEvent event) {
                    ChangeEvent target = NacosConfigTemplate.this.transform(dataId, event, Collections.emptySet());
                    try {
                        changeListener.onChange(target);
                    }
                    catch (RuntimeException e) {
                        log.error("onChange of {} invoke failure, dataId:{}", changeListener.getClass(), (Object)dataId);
                        throw e;
                    }
                }
            };
            try {
                this.configService.addListener(dataId, this.group, (Listener)listener);
                this.listenerMap.putIfAbsent(changeListener, listener);
            }
            catch (NacosException e) {
                throw new ConfigException("add listener exception", (Throwable)e);
            }
        }
    }

    public boolean removeListener(String dataId, ChangeListener changeListener) {
        return this.doRemoveListener(dataId, changeListener, (data, listener) -> this.configService.removeListener(data, this.group, listener));
    }

    public boolean publishProperty(String dataId, String key, String value) {
        String extension = this.parseExtension(dataId);
        if (StringUtils.isEmpty((Object)key)) {
            throw new ConfigException("key\u4e0d\u80fd\u4e3a\u7a7a");
        }
        boolean retValue = false;
        if (!"properties".equals(extension)) {
            if (!"content".equals(key)) {
                throw new ConfigException("\u53ea\u6709properties\u7c7b\u578b\u6587\u4ef6\u652f\u6301\u914d\u7f6e\u9879\u66f4\u65b0");
            }
            retValue = this.publishConfig(dataId, value);
        } else {
            Properties properties = this.getProperties(dataId);
            properties.setProperty(key, value);
            StringBuilder builder = new StringBuilder();
            properties.stringPropertyNames().forEach(x -> builder.append((String)x).append("=").append(properties.get(x)).append("\r\n"));
            try {
                this.configService.publishConfig(dataId, this.group, builder.toString());
                retValue = true;
            }
            catch (NacosException e) {
                throw new ConfigException("publish config exception", (Throwable)e);
            }
        }
        return retValue;
    }

    public boolean publishConfig(String dataId, String value) {
        try {
            String extension = this.parseExtension(dataId);
            if ("properties".equals(extension)) {
                throw new ConfigException("properties\u7c7b\u578b\u6587\u4ef6\u4e0d\u652f\u6301\u5168\u91cf\u66f4\u65b0");
            }
            this.configService.publishConfig(dataId, this.group, value);
            return true;
        }
        catch (NacosException e) {
            throw new ConfigException("publish config exception", (Throwable)e);
        }
    }

    public String getConfig(String dataId) {
        try {
            String extension = this.parseExtension(dataId);
            if ("properties".equals(extension)) {
                throw new ConfigException("properties\u7c7b\u578b\u6587\u4ef6\u4e0d\u652f\u6301\u5168\u91cf\u83b7\u53d6");
            }
            return this.configService.getConfig(dataId, this.group, (long)ConfigConstants.READ_TIMEOUT.intValue());
        }
        catch (NacosException e) {
            throw new ConfigException("get config exception", (Throwable)e);
        }
    }

    public String getProperty(String dataId, String key, String defaultValue) {
        String extension = this.parseExtension(dataId);
        if (StringUtils.isEmpty((Object)key)) {
            throw new ConfigException("key\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!"properties".equals(extension)) {
            if (!"content".equals(key)) {
                throw new ConfigException("\u53ea\u6709properties\u7c7b\u578b\u6587\u4ef6\u652f\u6301\u914d\u7f6e\u9879\u83b7\u53d6");
            }
            return this.getConfig(dataId);
        }
        Properties properties = this.getProperties(dataId);
        return properties.getProperty(key, defaultValue);
    }

    private Properties getProperties(String dataId) {
        Properties values = new Properties();
        try {
            String content = this.configService.getConfig(dataId, this.group, (long)ConfigConstants.READ_TIMEOUT.intValue());
            if (!StringUtils.isEmpty((Object)content)) {
                values.load(new StringReader(content));
            }
        }
        catch (Exception e) {
            throw new ConfigException("load properties exception", (Throwable)e);
        }
        return values;
    }

    protected ChangeEvent transform(String dataId, ConfigChangeEvent source, Set<String> interestedKeys) {
        ChangeEvent target = new ChangeEvent();
        Collection items = source.getChangeItems();
        for (ConfigChangeItem item : items) {
            String key = item.getKey();
            if (!interestedKeys.isEmpty() && !interestedKeys.contains(key)) continue;
            ChangeItem targetChange = new ChangeItem().setDataId(dataId).setPropertyName(item.getKey()).setOldValue(item.getOldValue()).setNewValue(item.getNewValue()).setChangeType(item.getType().name());
            target.addChange(item.getKey(), targetChange);
        }
        return target;
    }
}

