/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.config.nacos;

import com.alibaba.cloud.nacos.client.NacosPropertySource;
import com.alibaba.cloud.nacos.client.NacosPropertySourceLocator;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.env.OriginTrackedMapPropertySource;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.core.Ordered;
import org.springframework.core.env.CompositePropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.StandardEnvironment;

public class NacosConfigApplicationListener
implements ApplicationListener<ContextRefreshedEvent>,
Ordered {
    private static final Logger log = LoggerFactory.getLogger(NacosConfigApplicationListener.class);

    public void onApplicationEvent(ContextRefreshedEvent event) {
        ApplicationContext applicationContext = event.getApplicationContext();
        if (applicationContext.getParent() == null) {
            try {
                NacosPropertySourceLocator locator = (NacosPropertySourceLocator)applicationContext.getBean(NacosPropertySourceLocator.class);
                CompositePropertySource compositeSource = (CompositePropertySource)locator.locate(applicationContext.getEnvironment());
                log.info("located property source: {}", (Object)compositeSource);
                if (compositeSource == null) {
                    return;
                }
                HashMap propertyMap = new HashMap();
                Collection propertySources = compositeSource.getPropertySources();
                for (PropertySource source : propertySources) {
                    NacosPropertySource nacosSource = (NacosPropertySource)source;
                    propertyMap.putAll((Map)nacosSource.getSource());
                }
                OriginTrackedMapPropertySource trackedSource = new OriginTrackedMapPropertySource("bootstrapProperties", propertyMap);
                StandardEnvironment environment = (StandardEnvironment)applicationContext.getEnvironment();
                environment.getPropertySources().addLast((PropertySource)trackedSource);
            }
            catch (Exception e) {
                log.error("Loading nacos configuration too early!", (Throwable)e);
            }
        }
    }

    public int getOrder() {
        return 0;
    }
}

