/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.config.apollo.namespace;

import cn.com.yusys.yusp.commons.config.apollo.ApolloConfigTemplate;
import cn.com.yusys.yusp.commons.config.apollo.namespace.NamespaceListenerRegister;
import cn.com.yusys.yusp.commons.config.core.ChangeEvent;
import cn.com.yusys.yusp.commons.config.core.ChangeItem;
import cn.com.yusys.yusp.commons.config.core.ChangeListener;
import cn.com.yusys.yusp.commons.config.util.JsonConfigUtils;
import cn.com.yusys.yusp.commons.util.StringUtils;
import com.ctrip.framework.apollo.ConfigChangeListener;
import com.ctrip.framework.apollo.model.ConfigChange;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonNamespaceListenerRegister
implements NamespaceListenerRegister {
    private static final Logger logger = LoggerFactory.getLogger(JsonNamespaceListenerRegister.class);

    public boolean isSupported(String s) {
        return s.endsWith(".json");
    }

    @Override
    public ConfigChangeListener getConfigChangeListener(ApolloConfigTemplate apolloConfigTemplate, String namespace, Set<String> interestedKeys, ChangeListener listener) {
        return event -> {
            ConfigChange configChange = event.getChange("content");
            try {
                ChangeEvent target = JsonConfigUtils.doParse(configChange.getOldValue(), configChange.getNewValue(), this::filterChangeData);
                target.getChanges().values().forEach(item -> item.setDataId(namespace));
                listener.onChange(target);
            }
            catch (RuntimeException e) {
                logger.error("onChange of {} invoke failure, dataId:{}", listener.getClass(), (Object)namespace);
                throw e;
            }
        };
    }

    @Override
    public Set<String> getInterestedKeys(Set<String> interestedKeys) {
        return null;
    }

    protected ChangeEvent filterChangeData(Map<Object, Object> oldMap, Map<Object, Object> newMap) {
        ChangeEvent event = new ChangeEvent();
        for (Map.Entry<Object, Object> entry : oldMap.entrySet()) {
            ChangeItem item;
            String propertyName;
            if (newMap.containsKey(entry.getKey())) {
                if (entry.getValue().equals(newMap.get(entry.getKey()))) continue;
                propertyName = StringUtils.replaceObjNull((Object)entry.getKey());
                item = new ChangeItem(null, propertyName, StringUtils.replaceObjNull((Object)entry.getValue()), StringUtils.replaceObjNull((Object)newMap.get(entry.getKey())));
                item.setChangeType("MODIFIED");
                event.addChange(propertyName, item);
            } else {
                propertyName = StringUtils.replaceObjNull((Object)entry.getKey());
                item = new ChangeItem(null, propertyName, StringUtils.replaceObjNull((Object)entry.getValue()), null);
                item.setChangeType("DELETE");
                event.addChange(propertyName, item);
            }
            event.addChange(item.getPropertyName(), item);
        }
        for (Map.Entry<Object, Object> entry : newMap.entrySet()) {
            if (oldMap.containsKey(entry.getKey())) continue;
            String propertyName = StringUtils.replaceObjNull((Object)entry.getKey());
            ChangeItem item = new ChangeItem(null, propertyName, null, StringUtils.replaceObjNull((Object)entry.getValue()));
            item.setChangeType("ADDED");
            event.addChange(propertyName, item);
        }
        return event;
    }
}

