/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.clean.scheduler;

import cn.com.yusys.yusp.commons.clean.config.DataClean;
import cn.com.yusys.yusp.commons.clean.task.DataCleanTask;
import cn.com.yusys.yusp.commons.clean.task.domain.DataCleanLog;
import cn.com.yusys.yusp.commons.clean.task.impl.DataCleanTaskDelete;
import cn.com.yusys.yusp.commons.clean.task.impl.DataCleanTaskMove;
import cn.com.yusys.yusp.commons.clean.task.service.DataCleanLogService;
import cn.com.yusys.yusp.commons.util.SpringContextUtils;
import cn.com.yusys.yusp.commons.util.collection.CollectionUtils;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.scheduling.Trigger;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.scheduling.support.CronTrigger;

public class SchedulerStarter
implements ApplicationRunner {
    private static final Logger log = LoggerFactory.getLogger(SchedulerStarter.class);
    ThreadPoolTaskScheduler scheduler;
    List<DataClean> dataCleans;
    DataCleanLogService dataCleanService;
    boolean useDbConfig;
    private static final String STRATEGY_CLEAN = "clean";
    private static final String FREQUENCY_WEEKLY = "weekly";
    private static final String FREQUENCY_MONTHLY = "monthly";

    public SchedulerStarter(boolean useDbConfig, ThreadPoolTaskScheduler scheduler, List<DataClean> dataCleans, DataCleanLogService dataCleanService) {
        this.useDbConfig = useDbConfig;
        this.scheduler = scheduler;
        this.dataCleans = dataCleans;
        this.dataCleanService = dataCleanService;
    }

    public void run(ApplicationArguments args) {
        List<Object> configs = new ArrayList();
        if (this.useDbConfig) {
            configs = this.dataCleanService.getConfig();
        }
        if (CollectionUtils.nonEmpty(this.dataCleans)) {
            configs.addAll(this.dataCleans);
        }
        for (DataClean dataClean : configs) {
            this.exeScheduleDisplay(dataClean);
        }
    }

    private void exeScheduleDisplay(DataClean p) {
        String beanName = p.getBeanName();
        if (null == beanName) {
            if (null == p.getCorn()) {
                this.setCorn(p);
            }
            if (STRATEGY_CLEAN.equals(p.getStrategy())) {
                DataCleanTaskDelete bean = (DataCleanTaskDelete)SpringContextUtils.getBean(DataCleanTaskDelete.class);
                this.exeSchedule(p, bean);
            } else {
                DataCleanTaskMove bean = (DataCleanTaskMove)SpringContextUtils.getBean(DataCleanTaskMove.class);
                this.exeSchedule(p, bean);
            }
        } else {
            DataCleanTask bean = (DataCleanTask)SpringContextUtils.getBean((String)beanName);
            this.exeSchedule(p, bean);
        }
    }

    private void exeSchedule(DataClean dataClean, DataCleanTask task) {
        this.scheduler.schedule(() -> {
            DataCleanLog dataLog = new DataCleanLog();
            dataLog.setSourceTable(dataClean.getSourceTable());
            dataLog.setHisTable(dataClean.getHisTable());
            dataLog.setExeCorn(dataClean.getCorn());
            try {
                log.debug("exe data clean starting,{}", (Object)dataClean);
                task.execute(dataClean);
                log.debug("exe data clean success,{}", (Object)dataClean);
                dataLog.setExeSts("S");
                this.dataCleanService.addLog(dataLog);
            }
            catch (Exception e) {
                log.error(String.format("exe data clean error, %s", dataClean), (Throwable)e);
                dataLog.setExeSts("F");
                String errorStr = e.getMessage();
                dataLog.setExceptionInfo(errorStr.substring(0, Math.min(errorStr.length(), 400)));
                this.dataCleanService.addLog(dataLog);
            }
        }, (Trigger)new CronTrigger(dataClean.getCorn()));
    }

    private void setCorn(DataClean p) {
        if (FREQUENCY_MONTHLY.equals(p.getFrequency())) {
            p.setCorn(this.getMonthlyCorn(p.getExeTime()));
        } else if (FREQUENCY_WEEKLY.equals(p.getFrequency())) {
            p.setCorn(this.getWeeklyCorn(p.getExeTime()));
        } else {
            p.setCorn(this.getDelayCorn(p.getExeTime()));
        }
    }

    private String getDelayCorn(int time) {
        return "0 0 " + time + " * * ?";
    }

    private String getWeeklyCorn(int time) {
        return "0 0 " + time + " ? * L";
    }

    private String getMonthlyCorn(int time) {
        return "0 0 " + time + " 1 * ? *";
    }
}

