/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.bsp.toolkit.logback;

import cn.com.yusys.yusp.bsp.toolkit.common.StringTools;
import org.slf4j.MDC;

public class LogbackUtil {
    public static final String KEY_BUNDLERID = "bundlerId";
    public static final String KEY_NAME = "name";
    public static final String KEY_SERIALNO = "serialno";
    public static final String KEY_BSN = "bsn";
    public static final String KEY_APPLOG = "applog";
    public static final String KEY_CODE = "code";
    public static final String KEY_LEVEL = "level";
    public static final String SIGN_SUBTRACTION = "-";
    public static final String KEY_CONTENTLOG = "contentlog";
    public static final String BSP_BLANK_8 = "        ";

    public static void putLogInfo(String bundlerId, String sessionId) {
        MDC.put((String)KEY_BUNDLERID, (String)bundlerId);
        if (StringTools.isEmpty(bundlerId)) {
            int index = bundlerId.lastIndexOf("/");
            if (index != -1) {
                MDC.put((String)KEY_NAME, (String)bundlerId.substring(0, index));
            }
        } else {
            MDC.put((String)KEY_NAME, (String)bundlerId);
        }
        MDC.put((String)"traceId", (String)sessionId);
    }

    public static void putLogInfo(String bundlerId, String moduleId, String moduleLog, String level, String sessionId, String bsn) {
        MDC.put((String)KEY_BUNDLERID, (String)bundlerId);
        if (StringTools.isEmpty(moduleId)) {
            int index = moduleLog.lastIndexOf("/");
            if (index != -1) {
                MDC.put((String)KEY_NAME, (String)moduleLog.substring(0, index));
            }
        } else {
            MDC.put((String)KEY_NAME, (String)moduleId);
        }
        MDC.put((String)"traceId", (String)sessionId);
        MDC.put((String)KEY_APPLOG, (String)moduleLog);
        MDC.put((String)KEY_LEVEL, (String)level);
        if (bsn != null && !bsn.equals(sessionId)) {
            MDC.put((String)KEY_BSN, (String)(bsn + SIGN_SUBTRACTION));
        }
    }

    public static void putSingleInfo(String key, String value) {
        if (value != null) {
            MDC.put((String)key, (String)value);
        }
    }

    public static String getSingleInfo(String key) {
        return MDC.get((String)key);
    }

    public static void removeSingleInfo(String key) {
        MDC.remove((String)key);
    }

    public static void removeLogInfo() {
        MDC.remove((String)KEY_BUNDLERID);
        MDC.remove((String)KEY_NAME);
        MDC.remove((String)KEY_SERIALNO);
        MDC.remove((String)KEY_APPLOG);
        MDC.remove((String)KEY_CODE);
        MDC.remove((String)KEY_LEVEL);
        MDC.remove((String)KEY_BSN);
        MDC.remove((String)KEY_CONTENTLOG);
    }

    public static void clearAllInfo() {
        MDC.clear();
    }

    public static boolean isPushLogInfo() {
        String serialno = MDC.get((String)KEY_SERIALNO);
        return serialno == null || serialno.equals(BSP_BLANK_8);
    }

    public static boolean isRemoveLogInfo() {
        String serialno = MDC.get((String)KEY_SERIALNO);
        return serialno == null;
    }
}

