/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.bsp.resources;

import cn.com.yusys.yusp.bsp.app.config.ModulePath;
import cn.com.yusys.yusp.bsp.resources.ExceptionInfo;
import cn.com.yusys.yusp.bsp.resources.ResourcePortal;
import cn.com.yusys.yusp.bsp.resources.Session;
import cn.com.yusys.yusp.bsp.resources.core.ResourceHolder;
import cn.com.yusys.yusp.bsp.resources.creator.impl.CacheMapping;
import cn.com.yusys.yusp.bsp.resources.creator.impl.CacheMappings;
import cn.com.yusys.yusp.bsp.resources.creator.impl.CacheMetas;
import cn.com.yusys.yusp.bsp.schema.mapping.Item;
import cn.com.yusys.yusp.bsp.schema.mapping.Items;
import cn.com.yusys.yusp.bsp.schema.mapping.Mapping;
import cn.com.yusys.yusp.bsp.schema.mapping.Property;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.oro.text.GlobCompiler;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.Perl5Matcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExceptionHandler {
    private static final String COMPONENT_NAME = "ExceptionHandler";
    private static final String TABLE_NAME = "exceptionHandler";
    private static final String EXCEPTION_CLASS_NAME = "exceptionClassName";
    private static final String EXCEPTION_DESCRIPTION = "exceptionDescription";
    private static final String EXCEPTION_CODE = "code";
    private static final String EXCEPTION_MSG = "msg";
    private static final String MAP_FILE = "exception.mpd";
    private static volatile ResourceHolder holder;
    private static final Logger logger;
    private static final Object MUTEX;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ExceptionInfo processException(Map<String, Object> context, Throwable exception, String exceptionCode, String exceptionMsg) {
        Item targetItem;
        String exMsg;
        String exceptionClassName;
        CacheMappings mappings;
        ExceptionInfo info = new ExceptionInfo(exceptionCode, exceptionMsg);
        String mapFile = ExceptionHandler.getMappingPath(context);
        ResourceHolder localHolder = holder;
        if (localHolder == null) {
            Object object = MUTEX;
            synchronized (object) {
                localHolder = holder;
                if (localHolder == null) {
                    holder = ResourcePortal.getInstance().getResourceHolder();
                }
            }
        }
        try {
            mappings = (CacheMappings)holder.getResource("mpd", mapFile);
        }
        catch (Exception e) {
            if (logger.isDebugEnabled()) {
                logger.warn("Load exception mapping configuration file [{}] failed.", (Object)MAP_FILE, (Object)e);
            } else if (logger.isWarnEnabled()) {
                logger.warn("Load exception mapping configuration file [{}] failed.", (Object)MAP_FILE);
            }
            return info;
        }
        logger.info("{} @ Load exception mapping configuration file: [{}]", (Object)COMPONENT_NAME, (Object)mapFile);
        CacheMapping mapping = (CacheMapping)mappings.getMap().get(TABLE_NAME);
        if (mapping == null) {
            logger.warn("Exception mapping configuration not contains table [{}].", (Object)TABLE_NAME);
            return info;
        }
        HashMap<String, String> queryMap = new HashMap<String, String>(16);
        CacheMetas metas = (CacheMetas)mapping.getMetas();
        List<String> keyList = metas.getMetasList();
        if (exception.getCause() == null) {
            exceptionClassName = exception.getClass().getName();
            exMsg = exception.getMessage();
        } else {
            exceptionClassName = exception.getCause().getClass().getName();
            exMsg = exception.getCause().getMessage();
        }
        queryMap.put(EXCEPTION_CLASS_NAME, exceptionClassName);
        queryMap.put(EXCEPTION_DESCRIPTION, exMsg);
        if (!keyList.contains(EXCEPTION_CODE)) {
            logger.warn("Outcome variable: {}, Does not match the mapping table: {}", (Object)EXCEPTION_CODE, keyList);
            return info;
        }
        if (!keyList.contains(EXCEPTION_MSG)) {
            logger.warn("Outcome variable: {}, Does not match the mapping table: {}", (Object)EXCEPTION_MSG, keyList);
            return info;
        }
        try {
            targetItem = ExceptionHandler.matchItem(mapping, queryMap);
        }
        catch (MalformedPatternException e) {
            if (logger.isDebugEnabled()) {
                logger.warn("Input parameter matching failed!", (Throwable)e);
            } else if (logger.isWarnEnabled()) {
                logger.warn("Input parameter matching failed!");
            }
            return info;
        }
        if (targetItem == null) {
            logger.warn("Exception mapping matching null!");
            return info;
        }
        ExceptionHandler.processResult(targetItem, info);
        return info;
    }

    private static Item matchItem(Mapping mapping, Map<String, String> queryMap) throws MalformedPatternException {
        Item[] itemArr;
        GlobCompiler compiler = new GlobCompiler();
        Perl5Matcher matcher = new Perl5Matcher();
        Item targetItem = null;
        Items items = mapping.getItems();
        for (Item item : itemArr = items.getItem()) {
            Property[] propertyArr = item.getProperty();
            int k = 0;
            boolean flag = false;
            for (Property property : propertyArr) {
                String proName = property.getName();
                String proValue = property.getValue();
                String qValue = queryMap.get(proName);
                if (qValue != null) {
                    if (proValue.equals(qValue)) {
                        ++k;
                    } else {
                        Pattern pattern = compiler.compile(proValue);
                        if (!matcher.matches(qValue, pattern)) break;
                        ++k;
                    }
                }
                if (k != queryMap.size()) continue;
                flag = true;
                break;
            }
            if (!flag) continue;
            targetItem = item;
            break;
        }
        return targetItem;
    }

    private static void processResult(Item item, ExceptionInfo info) {
        Enumeration<? extends Property> enPropertys = item.enumerateProperty();
        String className = null;
        while (enPropertys.hasMoreElements()) {
            Property property = enPropertys.nextElement();
            String proName = property.getName();
            String proValue = property.getValue();
            if (EXCEPTION_CLASS_NAME.equals(proName)) {
                className = proValue;
            }
            if (EXCEPTION_CODE.equals(proName)) {
                info.setCode(proValue);
            }
            if (!EXCEPTION_MSG.equals(proName)) continue;
            info.setMsg(proValue);
        }
        logger.debug("{} @ {}: {}", new Object[]{COMPONENT_NAME, className, info});
    }

    private static String getMappingPath(Map<String, Object> context) {
        Session session = (Session)context.get("T_SESSION");
        String modulePath = null;
        if (session != null) {
            String moduleName = session.getModuleName();
            modulePath = ModulePath.getModulePath(moduleName, false);
        }
        return modulePath + "/" + MAP_FILE;
    }

    static {
        logger = LoggerFactory.getLogger(ExceptionHandler.class);
        MUTEX = new Object();
    }
}

