/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.bsp.resources;

import cn.com.yusys.yusp.bsp.resources.ExceptionHandler;
import cn.com.yusys.yusp.bsp.resources.ExceptionInfo;
import cn.com.yusys.yusp.bsp.resources.Session;
import cn.com.yusys.yusp.bsp.toolkit.common.StringTools;
import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.util.Map;

public class ExceptionAnalyzer {
    public static void removeContextExceptionInfos(Session session) {
        ExceptionAnalyzer.removeContextExceptionInfos(session.getContext(), session);
    }

    private static void removeContextExceptionInfos(Map<String, Object> context, Session session) {
        context.remove("G_EXCEPTION_CODE");
        context.remove("G_EXCEPTION_TYPE");
        context.remove("G_EXCEPTION_MESSAGE");
        context.remove("G_EXCEPTION_DETAIL");
    }

    public static void setContextExceptionInfos(Session session, Throwable exception, String exceptionCode) {
        ExceptionAnalyzer.setContextExceptionInformations(session.getContext(), exception, exceptionCode, null);
    }

    public static void setContextExceptionInfos(Map<String, Object> context, Throwable exception, String exceptionCode, String exceptionMsg) {
        ExceptionInfo info = ExceptionHandler.processException(context, exception, exceptionCode, exceptionMsg);
        ExceptionAnalyzer.setContextExceptionInformations(context, exception, info.getCode(), info.getMsg());
    }

    private static void setContextExceptionInformations(Map<String, Object> context, Throwable exception, String exceptionCode, String exceptionMsg) {
        Object[] objs = ExceptionAnalyzer.parseException(exception);
        context.computeIfAbsent("G_EXCEPTION_CODE", k -> exceptionCode != null ? exceptionCode : "9999");
        context.put("G_EXCEPTION_TYPE", objs[0]);
        context.computeIfAbsent("G_EXCEPTION_MESSAGE", k -> exceptionMsg != null ? exceptionMsg : objs[1]);
        context.put("G_EXCEPTION_DETAIL", objs[2]);
    }

    public static Object[] parseException(Throwable exception) {
        Throwable exc;
        String eType = null;
        String eDetail = null;
        String eMsg = null;
        for (exc = exception; exc != null; exc = exc.getCause()) {
            if (exc.getClass().getName().endsWith("DelegationException")) {
                continue;
            }
            eType = ExceptionAnalyzer.getExceptionShortName(exc);
            eDetail = StringTools.printExceptionStackTrace(exc);
            eMsg = exc.getMessage();
            break;
        }
        return new Object[]{eType, eMsg, eDetail, exc};
    }

    public static String getExceptionShortName(Throwable exception) {
        String className = exception.getClass().getName();
        int index = className.lastIndexOf(46);
        if (index < 0) {
            return className;
        }
        return className.substring(index + 1);
    }

    public static String exceptionToString(Throwable t) {
        try {
            if (t == null) {
                return "null";
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            PrintWriter pw = new PrintWriter(baos, true);
            t.printStackTrace(pw);
            return baos.toString("UTF-8");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String exceptionToShortString(Throwable t) {
        if (t == null) {
            return "null";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(t.toString());
        if (t.getCause() != null) {
            sb.append("_@_");
            sb.append(t.getCause().toString());
        }
        return sb.toString();
    }
}

