/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.bsp.method.impl;

import cn.com.yusys.yusp.bsp.method.MethodException;
import cn.com.yusys.yusp.bsp.method.impl.IntMethodTool;
import cn.com.yusys.yusp.bsp.toolkit.common.ByteTools;
import cn.com.yusys.yusp.bsp.toolkit.common.StringTools;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataValidationMethodTools {
    private static final String TARGET_LEN = "targetLength";
    public static final String PARA_REGEX = "paraRegex";
    private static final String R_D_F = "RDateFormat";
    public static final String PARA_ENUM = "paraEnum";
    public static final String ENUM_SEP = "[|]";
    public static final String LEN_OPERATION = "lenOperation";
    private static final String LEN_EQU = "lenEqu";
    private static final String LEN_GT = "lenGt";
    private static final String LEN_LT = "lenLt";
    private static final String LEN_RANGE = "lenRange";
    private static final String LEN_START = "lenStart";
    private static final Logger logger = LoggerFactory.getLogger(DataValidationMethodTools.class);
    private static final String CHAR_D = "d";
    private static final String CHAR_M = "M";
    private static final char CHAR_TWO = '2';
    private static final String CHAR_Y = "y";
    private static final String CHAR_YY = "yy";
    private static final char CHAR_ZERO = '0';

    public static Object checkLen(Object srcDataObject, Map<String, Object> paras, Map<String, Object> context) throws Exception {
        String itemName = StringTools.getString(paras.get("ItemName"));
        String itemDesc = StringTools.getString(paras.get("ItemDesc"));
        try {
            String strLen = StringTools.getString(paras.get(TARGET_LEN));
            int targetLength = StringTools.isEmpty(strLen) ? 0 : Integer.parseInt(strLen);
            if (targetLength < 0) {
                targetLength = 0;
            }
            String option = StringTools.getString(paras.get(LEN_OPERATION));
            byte[] srcData = ByteTools.getBytes(srcDataObject);
            if (LEN_EQU.equals(option)) {
                if (srcData.length != targetLength) {
                    logger.warn("Validate data length @ illegal [{}] length, data length[{}], validated length is [{}]", new Object[]{StringTools.getString(srcDataObject), srcData.length, targetLength});
                    String message = "The source data length [" + srcData.length + "] is inconsistent with the validated length [" + targetLength + "]";
                    throw new MethodException(message);
                }
                logger.debug("Validate data length @ legal data");
            } else if (LEN_GT.equals(option)) {
                if (srcData.length <= targetLength) {
                    logger.warn("Validate data length @ illegal [{}] length, data length[{}], validated length is [{}]", new Object[]{StringTools.getString(srcDataObject), srcData.length, targetLength});
                    String message = "Source data length [" + srcData.length + "] is not greater than validated length [" + targetLength + "]";
                    throw new MethodException(message);
                }
                logger.debug("Validate data length @ legal data");
            } else if (LEN_LT.equals(option)) {
                if (srcData.length >= targetLength) {
                    logger.warn("Validate data length @ illegal [{}] length, data length[{}], validated length is [{}]", new Object[]{StringTools.getString(srcDataObject), srcData.length, targetLength});
                    String message = "Source data length [" + srcData.length + "] is not less than validated length [" + targetLength + "]";
                    throw new MethodException(message);
                }
                logger.debug("Validate data length @ legal data");
            } else if (LEN_RANGE.equals(option)) {
                String strStart = StringTools.getString(paras.get(LEN_START));
                int start = 0;
                if (!StringTools.isEmpty(strStart)) {
                    start = Integer.parseInt(strStart);
                }
                if (srcData.length > targetLength || srcData.length < start) {
                    logger.warn("Validate data length @ illegal [{}] length, data length[{}], validated length is [{}]", new Object[]{StringTools.getString(srcDataObject), srcData.length, targetLength});
                    String message = "Source data length [" + srcData.length + "] is not between validated length [" + start + "," + targetLength + "]";
                    throw new MethodException(message);
                }
                logger.debug("Validate data length @ legal data");
            }
        }
        catch (Exception e) {
            throw new MethodException(e.getMessage(), "Validate data length", StringTools.getString(srcDataObject), itemName, itemDesc);
        }
        return srcDataObject;
    }

    public static Object checkMust(Object srcData, Map<String, Object> paras, Map<String, Object> context) throws MethodException {
        String itemName = StringTools.getString(paras.get("ItemName"));
        String itemDesc = StringTools.getString(paras.get("ItemDesc"));
        try {
            if (srcData == null) {
                throw new Exception("The validation failed");
            }
            String ret = StringTools.getString(srcData);
            if (StringTools.isEmpty(ret)) {
                throw new Exception("The validation failed");
            }
        }
        catch (Exception e) {
            throw new MethodException(e.getMessage(), "Validation required", StringTools.getString(srcData), itemName, itemDesc);
        }
        return srcData;
    }

    public static String checkID(String srcData, Map<String, Object> paras, Map<String, Object> context) {
        return srcData;
    }

    public static Object checkDataByRegex(Object srcDataObject, Map<String, Object> paras, Map<String, Object> context) throws MethodException {
        String itemName = StringTools.getString(paras.get("ItemName"));
        String itemDesc = StringTools.getString(paras.get("ItemDesc"));
        try {
            String srcData = StringTools.getString(srcDataObject);
            String regex = StringTools.getString(paras.get(PARA_REGEX));
            if (StringTools.isEmpty(srcData)) {
                throw new MethodException("Field value is empty");
            }
            if (StringTools.isEmpty(regex)) {
                throw new MethodException("Regex is empty");
            }
            Pattern pattern = Pattern.compile(regex);
            Matcher matcher = pattern.matcher(srcData);
            if (!matcher.matches()) {
                String message = "Regular expression mismatch";
                throw new MethodException(message);
            }
            logger.debug("Regular expression validation @ data legal");
        }
        catch (Exception e) {
            throw new MethodException(e.getMessage(), "Regular expression validation", StringTools.getString(srcDataObject), itemName, itemDesc);
        }
        return srcDataObject;
    }

    public static Object checkDateFormat(Object srcData, Map<String, Object> paras, Map<String, Object> context) throws MethodException {
        String itemName = StringTools.getString(paras.get("ItemName"));
        String itemDesc = StringTools.getString(paras.get("ItemDesc"));
        try {
            String srcDataValue = StringTools.getString(srcData);
            byte[] data = ByteTools.getBytes(srcData);
            String ref = StringTools.getString(paras.get(R_D_F));
            if (StringTools.isEmpty(ref)) {
                throw new MethodException("Date format is empty");
            }
            if (data.length != ByteTools.getBytes(ref).length) {
                String message = "Inconsistent with expected data format [" + ref + "]";
                throw new MethodException(message);
            }
            SimpleDateFormat dateFormat = new SimpleDateFormat(ref);
            String ret = dateFormat.format(dateFormat.parse(srcDataValue));
            if (!ret.equals(srcDataValue)) {
                String message = "Inconsistent with expected data format [" + ret + "]";
                throw new MethodException(message);
            }
            logger.debug("Validate date format @ legal data");
        }
        catch (Exception e) {
            String message = e.getMessage();
            throw new MethodException(message, "Validate date format", StringTools.getString(srcData), itemName, itemDesc);
        }
        return srcData;
    }

    public static Object checkAMTFormat(Object srcDataObject, Map<String, Object> paras, Map<String, Object> context) throws MethodException {
        String itemName = StringTools.getString(paras.get("ItemName"));
        String itemDesc = StringTools.getString(paras.get("ItemDesc"));
        try {
            String ret = IntMethodTool.formatMoney(srcDataObject, paras, context);
            byte[] srcData = ByteTools.getBytes(srcDataObject);
            String str = new String(srcData);
            if (!str.equals(ret)) {
                String message = "Inconsistent with expected data format " + ret + "]";
                throw new MethodException(message);
            }
            logger.debug("Validate amount format @ legal data");
        }
        catch (Exception e) {
            throw new MethodException(e.getMessage(), "Validate amount format", StringTools.getString(srcDataObject), itemName, itemDesc);
        }
        return srcDataObject;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String formatDate(Object srcDataObject, Map<String, Object> paras, Map<String, Object> context) throws MethodException {
        byte[] srcData = ByteTools.getBytes(srcDataObject);
        String rdf = StringTools.getString(paras.get(R_D_F));
        if (StringTools.isEmpty(rdf)) {
            throw new MethodException("Date format is empty");
        }
        int bsy = rdf.indexOf(CHAR_Y);
        int bey = rdf.lastIndexOf(CHAR_Y);
        int bsm = rdf.indexOf(CHAR_M);
        int bem = rdf.lastIndexOf(CHAR_M);
        int bsd = rdf.indexOf(CHAR_D);
        int bed = rdf.lastIndexOf(CHAR_D);
        int bynum = bey - bsy + 1;
        int bmnum = bem - bsm + 1;
        int bdnum = bed - bsd + 1;
        String sdf = StringTools.getString(paras.get(R_D_F));
        if (StringTools.isEmpty(sdf)) {
            throw new MethodException("Illegal date");
        }
        byte[] bt = sdf.getBytes();
        int sy = sdf.indexOf(CHAR_Y);
        int ey = sdf.lastIndexOf(CHAR_Y);
        int sm = sdf.indexOf(CHAR_M);
        int em = sdf.lastIndexOf(CHAR_M);
        int sd = sdf.indexOf(CHAR_D);
        int ed = sdf.lastIndexOf(CHAR_D);
        int ynum = ey - sy + 1;
        int mnum = em - sm + 1;
        int dnum = ed - sd + 1;
        int base2Num = 2;
        int base4Num = 4;
        if (sy != -1 && bsy != -1) {
            if (ynum == bynum) {
                int i = sy;
                for (int j = bsy; i <= ey && j <= bey; ++i, ++j) {
                    bt[i] = srcData[j];
                }
                return DataValidationMethodTools.getString(srcData, bsm, bem, bsd, bed, bmnum, bdnum, bt, sm, em, sd, ed, mnum, dnum);
            } else if (ynum == bynum + base2Num) {
                bt[sy] = 50;
                bt[sy + 1] = 48;
                int i = sy + base2Num;
                for (int j = bsy; i <= ey && j <= bey; ++i, ++j) {
                    bt[i] = srcData[j];
                }
                return DataValidationMethodTools.getString(srcData, bsm, bem, bsd, bed, bmnum, bdnum, bt, sm, em, sd, ed, mnum, dnum);
            } else {
                if (ynum != bynum - base2Num) throw new MethodException("Illegal date");
                int i = sy;
                for (int j = bsy + base2Num; i <= ey && j <= bey; ++i, ++j) {
                    bt[i] = srcData[j];
                }
            }
            return DataValidationMethodTools.getString(srcData, bsm, bem, bsd, bed, bmnum, bdnum, bt, sm, em, sd, ed, mnum, dnum);
        } else {
            if (sy == -1 || bsy != -1) return DataValidationMethodTools.getString(srcData, bsm, bem, bsd, bed, bmnum, bdnum, bt, sm, em, sd, ed, mnum, dnum);
            SimpleDateFormat date = new SimpleDateFormat(CHAR_YY);
            byte[] ybt = date.format(new Date()).getBytes();
            if (ynum == base2Num) {
                bt[sy] = ybt[0];
                bt[sy + 1] = ybt[1];
                return DataValidationMethodTools.getString(srcData, bsm, bem, bsd, bed, bmnum, bdnum, bt, sm, em, sd, ed, mnum, dnum);
            } else {
                if (ynum != base4Num) throw new MethodException("Illegal date");
                bt[sy] = 50;
                bt[sy + 1] = 48;
                bt[sy + 2] = ybt[0];
                bt[sy + 3] = ybt[1];
            }
        }
        return DataValidationMethodTools.getString(srcData, bsm, bem, bsd, bed, bmnum, bdnum, bt, sm, em, sd, ed, mnum, dnum);
    }

    private static String getString(byte[] srcData, int bsm, int bem, int bsd, int bed, int bmnum, int bdnum, byte[] bt, int sm, int em, int sd, int ed, int mnum, int dnum) throws MethodException {
        int j;
        int i;
        if (sm != -1) {
            if (mnum == bmnum) {
                i = sm;
                for (j = bsm; i <= em && j <= bem; ++i, ++j) {
                    bt[i] = srcData[j];
                }
            } else if (mnum == bmnum + 1) {
                bt[sm] = 48;
                bt[sm + 1] = srcData[bem];
            } else if (mnum == bmnum - 1) {
                bt[sm] = srcData[bem];
            } else {
                throw new MethodException("Illegal date");
            }
        }
        if (sd != -1) {
            if (dnum == bdnum) {
                i = sd;
                for (j = bsd; i <= ed && j <= bed; ++i, ++j) {
                    bt[i] = srcData[j];
                }
            } else if (dnum == bdnum + 1) {
                bt[sd] = 48;
                bt[sd + 1] = srcData[bed];
            } else if (dnum == bdnum - 1) {
                bt[sd] = srcData[bed];
            } else {
                throw new MethodException("Illegal date");
            }
        }
        return new String(bt);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Object checkEnum(Object srcDataObject, Map<String, Object> paras, Map<String, Object> context) throws Exception {
        String itemName = StringTools.getString(paras.get("ItemName"));
        String itemDesc = StringTools.getString(paras.get("ItemDesc"));
        String enumStr = StringTools.getString(paras.get(PARA_ENUM));
        try {
            String srcStr = StringTools.getString(srcDataObject);
            if (StringTools.isEmpty(enumStr)) throw new MethodException("Source data is [" + enumStr + "]");
            String[] str = enumStr.split(ENUM_SEP);
            if (str.length <= 0) throw new MethodException("Enumeration value is [" + srcStr + "]");
            List<String> enumList = Arrays.asList(str);
            System.out.println("enumList=" + enumList + "|" + srcStr);
            if (!enumList.contains(srcStr)) {
                throw new MethodException("Enumeration value is " + enumList + " validation failed");
            }
            logger.debug("Enumeration validation @ legal data");
            return srcDataObject;
        }
        catch (Exception e) {
            throw new MethodException(e.getMessage(), "Enumeration validation", StringTools.getString(srcDataObject), itemName, itemDesc);
        }
    }
}

