/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.bsp.communication.impl.out.mq;

import cn.com.yusys.yusp.bsp.communication.DataRequest;
import cn.com.yusys.yusp.bsp.communication.IDataAdapter;
import cn.com.yusys.yusp.bsp.communication.IRequest;
import cn.com.yusys.yusp.bsp.communication.impl.mq.QueueingConsumer;
import cn.com.yusys.yusp.bsp.communication.out.AbstractOutAdapter;
import cn.com.yusys.yusp.bsp.resources.Session;
import cn.com.yusys.yusp.bsp.toolkit.common.StringTools;
import cn.com.yusys.yusp.bsp.toolkit.el.ognl.OgnlTools;
import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import com.rabbitmq.client.Consumer;

public class RabbitMQOutAdapter
extends AbstractOutAdapter
implements IDataAdapter {
    private static final String RABBIT_OUT_ADAPTER_NAME = "RabbitMQ outgoing adapter";
    private String host;
    private int port;
    private String userId;
    private String password;
    private String recQName;
    private String sendQName;
    private String correlationQId;
    private ConnectionFactory connectionFactory;
    private Connection connection;
    private Channel channel;
    private QueueingConsumer queueingConsumer;

    @Override
    public String getAdapterTypeName() {
        return RABBIT_OUT_ADAPTER_NAME;
    }

    @Override
    public void doStart() throws Exception {
        super.doStart();
        this.validateParams();
        this.rabbitfactoryInit();
    }

    @Override
    public IRequest makeRequest(Session session) throws Exception {
        try {
            if (this.connection == null) {
                this.connection = this.connectionFactory.newConnection();
                this.channel = this.connection.createChannel();
                this.queueingConsumer = new QueueingConsumer(this.channel);
                this.channel.basicConsume(this.recQName, true, (Consumer)this.queueingConsumer);
            }
        }
        catch (Exception e) {
            this.logger.error("{} @ Send message error", (Object)this.getAdapterTypeName(), (Object)e);
            throw new Exception(this.getAdapterName() + " @ Send message error", e);
        }
        DataRequest request = new DataRequest();
        request.setOutAdapter(this);
        request.setDatasourceWrapper(this.channel);
        return request;
    }

    @Override
    public void send(IRequest request) throws Exception {
        DataRequest req = (DataRequest)request;
        String sendNameQ = this.getSendQName();
        try {
            if (StringTools.isEmpty(sendNameQ)) {
                throw new Exception(this.getAdapterTypeName() + " @ The sending queue name is not configured!");
            }
            if (StringTools.isEmpty(this.getCorrelationQId())) {
                throw new Exception(this.getAdapterTypeName() + " @ The associated id is not configured!");
            }
            String correlationIdValue = StringTools.getString(OgnlTools.getValue(this.getCorrelationQId(), req.getContext()));
            if (StringTools.isEmpty(correlationIdValue)) {
                throw new Exception("Association ID cannot be empty");
            }
            AMQP.BasicProperties props = new AMQP.BasicProperties.Builder().correlationId(correlationIdValue).replyTo(this.recQName).build();
            ((Channel)request.getDatasourceWrapper()).basicPublish("", sendNameQ, props, req.getData());
        }
        catch (Exception e) {
            this.logger.error("{} @ Send message error", (Object)this.getAdapterTypeName(), (Object)e);
            try {
                try {
                    this.channel.close();
                    this.connection.close();
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
                this.queueingConsumer = null;
                this.channel = null;
                this.connection = null;
            }
            catch (Exception e1) {
                this.logger.error(this.getAdapterName() + " @ Close queue error:", (Throwable)e1);
            }
            throw new Exception(this.getAdapterName() + " @ Send message error", e);
        }
    }

    @Override
    public byte[] receive(IRequest request) throws Exception {
        byte[] msg;
        try {
            QueueingConsumer.Delivery delivery = this.queueingConsumer.nextDelivery(10000L);
            if (delivery == null) {
                throw new Exception("Receiving message timed out");
            }
            msg = delivery.getBody();
        }
        catch (Exception e) {
            this.logger.error("{} @ {}", new Object[]{this.getAdapterName(), e.getMessage()});
            try {
                this.channel.close();
                this.connection.close();
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
            this.queueingConsumer = null;
            this.channel = null;
            this.connection = null;
            throw new Exception(this.getAdapterName() + " @ Receive message error", e);
        }
        return msg;
    }

    @Override
    public void unmakeRequest(IRequest request) {
    }

    @Override
    public void doStop() throws Exception {
        try {
            if (this.channel != null && this.channel.isOpen()) {
                this.channel.close();
            }
            if (this.connection != null && this.connection.isOpen()) {
                this.connection.close();
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        this.queueingConsumer = null;
        this.channel = null;
        this.connection = null;
        super.doStop();
    }

    private void validateParams() throws Exception {
        if (StringTools.isEmpty(this.getHost())) {
            throw new Exception(this.getAdapterTypeName() + " @ The listening address is not configured!");
        }
        if (this.getPort() == 0) {
            throw new Exception(this.getAdapterTypeName() + " @ The listening port is not configured!");
        }
        if (StringTools.isEmpty(this.getRecQName())) {
            throw new Exception(this.getAdapterTypeName() + " @ The receiving queue name is not configured!");
        }
    }

    private void rabbitfactoryInit() {
        this.connectionFactory = new ConnectionFactory();
        this.connectionFactory.setHost(this.getHost());
        this.connectionFactory.setPort(this.getPort());
        this.connectionFactory.setUsername(this.getUserId());
        this.connectionFactory.setPassword(this.getPassword());
        this.connectionFactory.setVirtualHost("/");
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getRecQName() {
        return this.recQName;
    }

    public void setRecQName(String recQName) {
        this.recQName = recQName;
    }

    public String getSendQName() {
        return this.sendQName;
    }

    public void setSendQName(String sendQName) {
        this.sendQName = sendQName;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getCorrelationQId() {
        return this.correlationQId;
    }

    public void setCorrelationQId(String correlationQId) {
        this.correlationQId = correlationQId;
    }
}

