/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.bsp.communication.impl.in.tcp;

import cn.com.yusys.yusp.bsp.communication.IRequest;
import cn.com.yusys.yusp.bsp.communication.SocketWrapper;
import cn.com.yusys.yusp.bsp.communication.StreamRequest;
import cn.com.yusys.yusp.bsp.communication.impl.in.tcp.TCPInAdapter;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.net.Socket;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class ShortServerInAdapter
extends TCPInAdapter {
    private static final String IN_ADAPTER_NAME = "Short connection server access adapter";
    private ExecutorService listenerThreadPool;

    @Override
    public IRequest makeRequest() throws Exception {
        Socket socket = this.server.accept();
        if (this.getTimeout() > 0) {
            socket.setSoTimeout(this.timeout);
        }
        SocketWrapper wrapper = new SocketWrapper(socket);
        StreamRequest request = new StreamRequest();
        request.setInAdapter(this);
        request.setDatasourceWrapper(wrapper);
        return request;
    }

    @Override
    public void doStart() throws Exception {
        super.doStart();
        this.createServerSocket();
        this.listenerThreadPool = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(1024), new ThreadFactoryBuilder().setNameFormat(this.getSid() + "-" + this.getClass().getSimpleName() + ":" + this.getPort()).build(), new ThreadPoolExecutor.AbortPolicy());
        this.listenerThreadPool.execute(this);
    }

    @Override
    public void unmakeRequest(IRequest request) throws Exception {
        request.close();
    }

    @Override
    public void doStop() throws Exception {
        try {
            if (this.server != null) {
                this.server.close();
                this.server = null;
            }
            if (this.listenerThreadPool != null) {
                this.listenerThreadPool.shutdown();
                this.listenerThreadPool = null;
            }
        }
        catch (Exception e) {
            this.logger.error("{} @ Exception in closing application", (Object)this.getAdapterTypeName(), (Object)e);
        }
        super.doStop();
    }

    @Override
    public String getAdapterTypeName() {
        return IN_ADAPTER_NAME;
    }
}

