/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.bsp.communication.impl.in.schedule;

import cn.com.yusys.yusp.bsp.app.config.ModulePath;
import cn.com.yusys.yusp.bsp.communication.IRequest;
import cn.com.yusys.yusp.bsp.communication.MapRequest;
import cn.com.yusys.yusp.bsp.communication.impl.in.schedule.CronExpression;
import cn.com.yusys.yusp.bsp.communication.in.AbstractInAdapter;
import cn.com.yusys.yusp.bsp.resources.creator.impl.JobCreator;
import cn.com.yusys.yusp.bsp.schema.mapping.Item;
import cn.com.yusys.yusp.bsp.schema.mapping.Mapping;
import cn.com.yusys.yusp.bsp.schema.mapping.Mappings;
import cn.com.yusys.yusp.bsp.schema.mapping.Property;
import cn.com.yusys.yusp.bsp.toolkit.common.FileChecker;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.text.ParseException;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;

public class ScheduleInAdapter
extends AbstractInAdapter
implements Runnable {
    private static final String IN_ADAPTER_NAME = "Scheduled access adapter";
    private TreeSet<JobDescriptor> jobSet;
    private static final String JOB_CONFIG_FILE = "schdl.mps";
    private long interval = 60000L;
    private final Map<String, Mappings> resourceMap = new ConcurrentHashMap<String, Mappings>();
    private final ReentrantLock reenLock = new ReentrantLock();
    private boolean open;
    private ExecutorService scheduleThreadPool;
    ReentrantLock lk = new ReentrantLock();

    public boolean isOpen() {
        return this.open;
    }

    public void setOpen(boolean open) {
        this.open = open;
    }

    public static String getInAdapterName() {
        return IN_ADAPTER_NAME;
    }

    @Override
    public String getAdapterTypeName() {
        return IN_ADAPTER_NAME;
    }

    @Override
    public void doStart() throws Exception {
        super.doStart();
        if (!this.isOpen()) {
            this.logger.debug("{} @ The timer is off, not started", (Object)this.getAdapterTypeName());
            this.setAlive(false);
            return;
        }
        this.jobSet = new TreeSet<JobDescriptor>(Comparator.comparing(JobDescriptor::getNextExTime).thenComparing(JobDescriptor::getName));
        try {
            this.getJobs();
        }
        catch (Exception e) {
            this.logger.error(this.getAdapterTypeName() + " @ Abnormal loading timing schedule file:", (Throwable)e);
        }
        this.scheduleThreadPool = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(1024), new ThreadFactoryBuilder().setNameFormat(this.getClass().getSimpleName()).build(), new ThreadPoolExecutor.AbortPolicy());
        this.scheduleThreadPool.execute(this);
    }

    @Override
    public void doStop() throws Exception {
        super.doStop();
        if (this.scheduleThreadPool != null) {
            this.scheduleThreadPool.shutdown();
            this.scheduleThreadPool = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getJobs() throws Exception {
        String jobFilePath = this.getJobFilePath();
        boolean change = FileChecker.getInstance(this.getBundlerId()).isChanged(jobFilePath);
        Mappings mappings = this.resourceMap.get(jobFilePath);
        if (mappings == null || change) {
            this.reenLock.lock();
            try {
                mappings = this.resourceMap.get(jobFilePath);
                if (mappings == null || change) {
                    Item[] items;
                    this.jobSet.clear();
                    this.logger.debug("{} @ Load task configuration file\uff1a{}", new Object[]{this.getAdapterTypeName(), jobFilePath});
                    JobCreator creator = new JobCreator();
                    mappings = (Mappings)creator.createResource(jobFilePath);
                    this.resourceMap.put(jobFilePath, mappings);
                    Mapping[] maps = mappings.getMapping();
                    for (Item item : items = maps[0].getItems().getItem()) {
                        Property[] propertys = item.getProperty();
                        String isEffect = null;
                        String jobName = null;
                        String tranCode = null;
                        String cronExpression = null;
                        block18: for (Property property : propertys) {
                            switch (property.getName()) {
                                case "jobName": {
                                    jobName = property.getValue();
                                    continue block18;
                                }
                                case "tranCode": {
                                    tranCode = property.getValue();
                                    continue block18;
                                }
                                case "cronExpression": {
                                    cronExpression = property.getValue();
                                    continue block18;
                                }
                                case "isEffect": {
                                    isEffect = property.getValue();
                                    continue block18;
                                }
                            }
                        }
                        if (!"true".equals(isEffect)) continue;
                        JobDescriptor jobDes = new JobDescriptor();
                        jobDes.setCronExpression(cronExpression);
                        jobDes.setName(jobName);
                        jobDes.setTransCode(tranCode);
                        try {
                            jobDes.setNextExTime(this.computeNextExecTime(jobDes, true));
                            this.logger.debug("{} @ Load task\uff1a{}", new Object[]{this.getAdapterTypeName(), jobName});
                            this.jobSet.add(jobDes);
                        }
                        catch (ParseException e) {
                            this.logger.error(this.getAdapterTypeName() + " @ job:[" + jobDes.getName() + "],Incorrect time expression format:[" + jobDes.getCronExpression() + "]", (Throwable)e);
                        }
                    }
                }
            }
            finally {
                this.reenLock.unlock();
            }
        }
    }

    public String getJobFilePath() {
        return ModulePath.getModulePath(this.getBundlerId(), false) + "/" + JOB_CONFIG_FILE;
    }

    public Date computeNextExecTime(JobDescriptor job, boolean isFirstTime) throws ParseException {
        Date thisTime = isFirstTime ? new Date() : job.getNextExTime();
        return new CronExpression(job.getCronExpression()).getNextValidTimeAfter(thisTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IRequest makeRequest() throws Exception {
        MapRequest req = new MapRequest(new HashMap<String, Object>(16));
        req.setInAdapter(this);
        this.reenLock.lock();
        try {
            if (this.jobSet.size() > 0) {
                JobDescriptor job;
                this.lk.lock();
                try {
                    job = this.jobSet.pollFirst();
                }
                finally {
                    this.lk.unlock();
                }
                if (job == null) {
                    IRequest iRequest = null;
                    return iRequest;
                }
                Date now = new Date();
                if (now.after(job.getNextExTime()) || now.equals(job.getNextExTime())) {
                    block28: {
                        req.getContext().put("G_TRANSCODE", job.getTransCode());
                        try {
                            job.setNextExTime(this.computeNextExecTime(job, false));
                            this.lk.lock();
                            try {
                                this.jobSet.add(job);
                            }
                            finally {
                                this.lk.unlock();
                            }
                        }
                        catch (ParseException e) {
                            if (!this.logger.isDebugEnabled()) break block28;
                            this.logger.debug(this.getAdapterTypeName() + " @ job:" + job.getName() + ",Incorrect time expression format", (Throwable)e);
                        }
                    }
                    MapRequest e = req;
                    return e;
                }
                this.lk.lock();
                try {
                    this.jobSet.add(job);
                }
                finally {
                    this.lk.unlock();
                }
                Date curr = new Date();
                long timeDiff = job.getNextExTime().getTime() - curr.getTime();
                long toSleep = timeDiff >= this.interval ? this.interval : (timeDiff >= 0L ? timeDiff : 0L);
                this.getJobs();
                try {
                    Thread.sleep(toSleep);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                IRequest iRequest = null;
                return iRequest;
            }
            this.logger.debug("{} @ No scheduled tasks loaded", (Object)this.getAdapterTypeName());
            try {
                this.getJobs();
            }
            catch (Exception e) {
                this.logger.error(this.getAdapterTypeName() + " @ Abnormal loading timing schedule file:", (Throwable)e);
            }
            finally {
                Thread.sleep(this.interval);
            }
            IRequest iRequest = null;
            return iRequest;
        }
        finally {
            this.reenLock.unlock();
        }
    }

    @Override
    public void unmakeRequest(IRequest req) throws Exception {
        req.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean resetJobNextTimeNow(String jobName) {
        boolean ret = false;
        Date date = new Date();
        this.lk.lock();
        try {
            for (JobDescriptor jd : this.jobSet) {
                if (!jd.getName().equals(jobName)) continue;
                if (date.before(jd.getNextExTime())) {
                    this.jobSet.remove(jd);
                    jd.setNextExTime(new Date());
                    this.jobSet.add(jd);
                    ret = true;
                } else {
                    this.logger.debug("Ignore this Timer schedule\uff1a" + jd);
                }
                break;
            }
        }
        finally {
            this.lk.unlock();
        }
        return ret;
    }

    public long getInterval() {
        return this.interval;
    }

    public void setInterval(long interval) {
        this.interval = interval;
    }

    static class JobDescriptor {
        private Date nextExTime;
        private String name;
        private String cronExpression;
        private String transCode;

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            JobDescriptor other = (JobDescriptor)obj;
            if (this.name == null) {
                return other.name == null;
            }
            return this.name.equals(other.name);
        }

        public JobDescriptor() {
        }

        public JobDescriptor(String name, String cronExpression, String transCode) {
            this.name = name;
            this.cronExpression = cronExpression;
            this.transCode = transCode;
            this.nextExTime = new Date();
        }

        public void setTransCode(String transCode) {
            this.transCode = transCode;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getCronExpression() {
            return this.cronExpression;
        }

        public void setCronExpression(String cronExpression) {
            this.cronExpression = cronExpression;
        }

        public String getTransCode() {
            return this.transCode;
        }

        public Date getNextExTime() {
            return this.nextExTime;
        }

        public void setNextExTime(Date nextExTime) {
            this.nextExTime = nextExTime;
        }
    }
}

