/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.bsp.communication.impl.in.schedule;

import cn.com.yusys.yusp.bsp.communication.impl.in.schedule.ValueSet;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;

public class CronExpression
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 12423409423L;
    protected static final int SECOND = 0;
    protected static final int MINUTE = 1;
    protected static final int HOUR = 2;
    protected static final int DAY_OF_MONTH = 3;
    protected static final int MONTH = 4;
    protected static final int DAY_OF_WEEK = 5;
    protected static final int YEAR = 6;
    protected static final int ALL_SPEC_INT = 99;
    protected static final int NO_SPEC_INT = 98;
    protected static final Integer ALL_SPEC = new Integer(99);
    protected static final Integer NO_SPEC = new Integer(98);
    protected static final Map MONTH_MAP = new HashMap(20);
    protected static final Map DAY_MAP = new HashMap(60);
    private String cronExpression = null;
    private TimeZone timeZone = null;
    protected transient TreeSet seconds;
    protected transient TreeSet minutes;
    protected transient TreeSet hours;
    protected transient TreeSet daysOfMonth;
    protected transient TreeSet months;
    protected transient TreeSet daysOfWeek;
    protected transient TreeSet years;
    protected transient boolean lastdayOfWeek = false;
    protected transient int nthdayOfWeek = 0;
    protected transient boolean lastdayOfMonth = false;
    protected transient boolean nearestWeekday = false;
    protected transient boolean expressionParsed = false;

    public CronExpression(String cronExpression) throws ParseException {
        if (cronExpression == null) {
            throw new IllegalArgumentException("cronExpression cannot be null");
        }
        this.cronExpression = cronExpression.toUpperCase(Locale.US);
        this.buildExpression(this.cronExpression);
    }

    public boolean isSatisfiedBy(Date date) {
        Calendar testDateCal = Calendar.getInstance(this.getTimeZone());
        testDateCal.setTime(date);
        testDateCal.set(14, 0);
        Date originalDate = testDateCal.getTime();
        testDateCal.add(13, -1);
        Date timeAfter = this.getTimeAfter(testDateCal.getTime());
        return timeAfter != null && timeAfter.equals(originalDate);
    }

    public Date getNextValidTimeAfter(Date date) {
        return this.getTimeAfter(date);
    }

    public Date getNextInvalidTimeAfter(Date date) {
        long difference = 1000L;
        Calendar adjustCal = Calendar.getInstance(this.getTimeZone());
        adjustCal.setTime(date);
        adjustCal.set(14, 0);
        Date lastDate = adjustCal.getTime();
        Date newDate = null;
        long base1000Long = 1000L;
        while (difference == base1000Long) {
            newDate = this.getTimeAfter(lastDate);
            difference = newDate.getTime() - lastDate.getTime();
            if (difference != base1000Long) continue;
            lastDate = newDate;
        }
        return new Date(lastDate.getTime() + base1000Long);
    }

    public TimeZone getTimeZone() {
        if (this.timeZone == null) {
            this.timeZone = TimeZone.getDefault();
        }
        return this.timeZone;
    }

    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
    }

    public String toString() {
        return this.cronExpression;
    }

    public static boolean isValidExpression(String cronExpression) {
        try {
            new CronExpression(cronExpression);
        }
        catch (ParseException pe) {
            return false;
        }
        return true;
    }

    protected void buildExpression(String expression) throws ParseException {
        this.expressionParsed = true;
        try {
            boolean daysOfWeekSpec;
            int exprOn;
            if (this.seconds == null) {
                this.seconds = new TreeSet();
            }
            if (this.minutes == null) {
                this.minutes = new TreeSet();
            }
            if (this.hours == null) {
                this.hours = new TreeSet();
            }
            if (this.daysOfMonth == null) {
                this.daysOfMonth = new TreeSet();
            }
            if (this.months == null) {
                this.months = new TreeSet();
            }
            if (this.daysOfWeek == null) {
                this.daysOfWeek = new TreeSet();
            }
            if (this.years == null) {
                this.years = new TreeSet();
            }
            StringTokenizer exprsTok = new StringTokenizer(expression, " \t", false);
            for (exprOn = 0; exprsTok.hasMoreTokens() && exprOn <= 6; ++exprOn) {
                String expr = exprsTok.nextToken().trim();
                if (exprOn == 3 && expr.indexOf(76) != -1 && expr.length() > 1 && expr.indexOf(",") >= 0) {
                    throw new ParseException("Support for specifying 'L' and 'LW' with other days of the month is not implemented", -1);
                }
                if (exprOn == 5 && expr.indexOf(76) != -1 && expr.length() > 1 && expr.indexOf(",") >= 0) {
                    throw new ParseException("Support for specifying 'L' with other days of the week is not implemented", -1);
                }
                StringTokenizer vTok = new StringTokenizer(expr, ",");
                while (vTok.hasMoreTokens()) {
                    String v = vTok.nextToken();
                    this.storeExpressionVals(0, v, exprOn);
                }
            }
            if (exprOn <= 5) {
                throw new ParseException("Unexpected end of expression.", expression.length());
            }
            if (exprOn <= 6) {
                this.storeExpressionVals(0, "*", 6);
            }
            TreeSet dow = this.getSet(5);
            TreeSet dom = this.getSet(3);
            boolean daysOfMonthSpec = !dom.contains(NO_SPEC);
            boolean bl = daysOfWeekSpec = !dow.contains(NO_SPEC);
            if (!(daysOfMonthSpec && !daysOfWeekSpec || daysOfWeekSpec && !daysOfMonthSpec)) {
                throw new ParseException("Support for specifying both a day-of-week AND a day-of-month parameter is not implemented.", 0);
            }
        }
        catch (ParseException pe) {
            throw pe;
        }
        catch (Exception e) {
            throw new ParseException("Illegal cron expression format (" + e.toString() + ")", 0);
        }
    }

    protected int storeExpressionVals(int pos, String s, int type) throws ParseException {
        int val;
        int incr = 0;
        int i = this.skipWhiteSpace(pos, s);
        if (i >= s.length()) {
            return i;
        }
        char c = s.charAt(i);
        char baseCharA = 'A';
        char baseCharZ = 'Z';
        String baseStringL = "L";
        String baseStringLw = "LW";
        int base3Num = 3;
        char baseChar = '-';
        char base1Char = '#';
        char baseCharL = 'L';
        char base2Char = '?';
        char base3Char = '*';
        char base4Char = '/';
        if (c >= baseCharA && c <= baseCharZ && !s.equals(baseStringL) && !s.equals(baseStringLw)) {
            return this.scenes1(s, type, incr, i, base3Num, baseChar, base1Char, baseCharL);
        }
        if (c == base2Char) {
            return this.scenes2(s, type, i);
        }
        char base0Char = '0';
        char base9Char = '9';
        if (c == base3Char || c == base4Char) {
            return this.scenes3(s, type, incr, i, c, base3Char, base4Char);
        }
        if (c == baseCharL) {
            return this.scenes4(s, type, i);
        }
        if (c >= base0Char && c <= base9Char) {
            val = Integer.parseInt(String.valueOf(c));
            if (++i < s.length()) {
                c = s.charAt(i);
                if (c >= base0Char && c <= base9Char) {
                    ValueSet vs = this.getValue(val, s, i);
                    val = vs.value;
                    i = vs.pos;
                }
                i = this.checkNext(i, s, val, type);
                return i;
            }
        } else {
            throw new ParseException("Unexpected character: " + c, i);
        }
        this.addToSet(val, -1, -1, type);
        return i;
    }

    private int scenes4(String s, int type, int i) throws ParseException {
        char baseCharW;
        char c;
        ++i;
        if (type == 3) {
            this.lastdayOfMonth = true;
        }
        if (type == 5) {
            this.addToSet(7, 7, 0, type);
        }
        if (type == 3 && s.length() > i && (c = s.charAt(i)) == (baseCharW = 'W')) {
            this.nearestWeekday = true;
            ++i;
        }
        return i;
    }

    private int scenes3(String s, int type, int incr, int i, char c, char base3Char, char base4Char) throws ParseException {
        boolean existed;
        boolean bl = existed = c == base4Char && (i + 1 >= s.length() || s.charAt(i + 1) == ' ' || s.charAt(i + 1) == '\t');
        if (c == base3Char && i + 1 >= s.length()) {
            this.addToSet(99, -1, incr, type);
            return i + 1;
        }
        if (existed) {
            throw new ParseException("'/' must be followed by an integer.", i);
        }
        if (c == base3Char) {
            ++i;
        }
        if ((c = s.charAt(i)) == base4Char) {
            boolean checked;
            if (++i >= s.length()) {
                throw new ParseException("Unexpected end of string.", i);
            }
            incr = this.getNumericValue(s, i);
            ++i;
            int base10Num = 10;
            int base59Num = 59;
            int base23Num = 23;
            int base31Num = 31;
            int base7Num = 7;
            int base12Num = 12;
            if (incr > base10Num) {
                ++i;
            }
            boolean bl2 = checked = incr > base59Num && (type == 0 || type == 1);
            if (checked) {
                throw new ParseException("Increment > 60 : " + incr, i);
            }
            if (incr > base23Num && type == 2) {
                throw new ParseException("Increment > 24 : " + incr, i);
            }
            if (incr > base31Num && type == 3) {
                throw new ParseException("Increment > 31 : " + incr, i);
            }
            if (incr > base7Num && type == 5) {
                throw new ParseException("Increment > 7 : " + incr, i);
            }
            if (incr > base12Num && type == 4) {
                throw new ParseException("Increment > 12 : " + incr, i);
            }
        } else {
            incr = 1;
        }
        this.addToSet(99, -1, incr, type);
        return i;
    }

    private int scenes2(String s, int type, int i) throws ParseException {
        int val;
        boolean existed;
        boolean bl = existed = ++i + 1 < s.length() && s.charAt(i) != ' ' && s.charAt(i + 1) != '\t';
        if (existed) {
            throw new ParseException("Illegal character after '?': " + s.charAt(i), i);
        }
        if (type != 5 && type != 3) {
            throw new ParseException("'?' can only be specfied for Day-of-Month or Day-of-Week.", i);
        }
        if (type == 5 && !this.lastdayOfMonth && (val = ((Integer)this.daysOfMonth.last()).intValue()) == 98) {
            throw new ParseException("'?' can only be specfied for Day-of-Month -OR- Day-of-Week.", i);
        }
        this.addToSet(98, -1, 0, type);
        return i;
    }

    private int scenes1(String s, int type, int incr, int i, int base3Num, char baseChar, char base1Char, char baseCharL) throws ParseException {
        int eval;
        int sval;
        block17: {
            String sub = s.substring(i, i + 3);
            sval = -1;
            eval = -1;
            if (type == 4) {
                char c;
                sval = this.getMonthNumber(sub) + 1;
                if (sval <= 0) {
                    throw new ParseException("Invalid Month value: '" + sub + "'", i);
                }
                if (s.length() > i + base3Num && (c = s.charAt(i + base3Num)) == baseChar && (eval = this.getMonthNumber(sub = s.substring(i += 4, i + base3Num)) + 1) <= 0) {
                    throw new ParseException("Invalid Month value: '" + sub + "'", i);
                }
            } else if (type == 5) {
                sval = this.getDayOfWeekNumber(sub);
                if (sval < 0) {
                    throw new ParseException("Invalid Day-of-Week value: '" + sub + "'", i);
                }
                if (s.length() > i + base3Num) {
                    char c = s.charAt(i + base3Num);
                    if (c == baseChar) {
                        if ((eval = this.getDayOfWeekNumber(sub = s.substring(i += 4, i + base3Num))) < 0) {
                            throw new ParseException("Invalid Day-of-Week value: '" + sub + "'", i);
                        }
                    } else {
                        if (c == base1Char) {
                            try {
                                this.nthdayOfWeek = Integer.parseInt(s.substring(i += 4));
                                int base5Num = 5;
                                if (this.nthdayOfWeek < 1 || this.nthdayOfWeek > base5Num) {
                                    throw new Exception();
                                }
                                break block17;
                            }
                            catch (Exception e) {
                                throw new ParseException("A numeric value between 1 and 5 must follow the '#' option", i);
                            }
                        }
                        if (c == baseCharL) {
                            this.lastdayOfWeek = true;
                            ++i;
                        }
                    }
                }
            } else {
                throw new ParseException("Illegal characters for this position: '" + sub + "'", i);
            }
        }
        if (eval != -1) {
            incr = 1;
        }
        this.addToSet(sval, eval, incr, type);
        return i + 3;
    }

    protected int checkNext(int pos, String s, int val, int type) throws ParseException {
        int end = -1;
        int i = pos;
        if (i >= s.length()) {
            this.addToSet(val, end, -1, type);
            return i;
        }
        char c = s.charAt(pos);
        char baseCharL = 'L';
        char baseCharW = 'W';
        char base1Char = '#';
        char base2Char = '-';
        char base3Char = '/';
        char base0Char = '0';
        char base9Char = '9';
        int base7Num = 7;
        if (c == baseCharL) {
            return this.positionAtCharL(val, type, i, base7Num);
        }
        if (c == baseCharW) {
            return this.positionAtCharW(val, type, i);
        }
        if (c == base1Char) {
            return this.positionAt1Char(s, val, type, i);
        }
        return this.positionAtOther(s, val, type, end, i, c, base2Char, base3Char, base0Char, base9Char);
    }

    private int positionAtOther(String s, int val, int type, int end, int i, char c, char base2Char, char base3Char, char base0Char, char base9Char) throws ParseException {
        if (c == base2Char) {
            int v;
            c = s.charAt(++i);
            end = v = Integer.parseInt(String.valueOf(c));
            if (++i >= s.length()) {
                this.addToSet(val, end, 1, type);
                return i;
            }
            c = s.charAt(i);
            if (c >= base0Char && c <= base9Char) {
                int v1;
                ValueSet vs = this.getValue(v, s, i);
                end = v1 = vs.value;
                i = vs.pos;
            }
            if (i < s.length() && (c = s.charAt(i)) == base3Char) {
                c = s.charAt(++i);
                int v2 = Integer.parseInt(String.valueOf(c));
                if (++i >= s.length()) {
                    this.addToSet(val, end, v2, type);
                    return i;
                }
                c = s.charAt(i);
                if (c >= base0Char && c <= base9Char) {
                    ValueSet vs = this.getValue(v2, s, i);
                    int v3 = vs.value;
                    this.addToSet(val, end, v3, type);
                    i = vs.pos;
                    return i;
                }
                this.addToSet(val, end, v2, type);
                return i;
            }
            this.addToSet(val, end, 1, type);
            return i;
        }
        if (c == base3Char) {
            c = s.charAt(++i);
            int v2 = Integer.parseInt(String.valueOf(c));
            if (++i >= s.length()) {
                this.addToSet(val, end, v2, type);
                return i;
            }
            c = s.charAt(i);
            if (c >= base0Char && c <= base9Char) {
                ValueSet vs = this.getValue(v2, s, i);
                int v3 = vs.value;
                this.addToSet(val, end, v3, type);
                i = vs.pos;
                return i;
            }
            throw new ParseException("Unexpected character '" + c + "' after '/'", i);
        }
        this.addToSet(val, end, 0, type);
        return ++i;
    }

    private int positionAt1Char(String s, int val, int type, int i) throws ParseException {
        if (type != 5) {
            throw new ParseException("'#' option is not valid here. (pos=" + i + ")", i);
        }
        ++i;
        int base5Num = 5;
        try {
            this.nthdayOfWeek = Integer.parseInt(s.substring(i));
            if (this.nthdayOfWeek < 1 || this.nthdayOfWeek > base5Num) {
                throw new Exception();
            }
        }
        catch (Exception e) {
            throw new ParseException("A numeric value between 1 and 5 must follow the '#' option", i);
        }
        TreeSet set = this.getSet(type);
        set.add(new Integer(val));
        return ++i;
    }

    private int positionAtCharW(int val, int type, int i) throws ParseException {
        if (type != 3) {
            throw new ParseException("'W' option is not valid here. (pos=" + i + ")", i);
        }
        this.nearestWeekday = true;
        TreeSet set = this.getSet(type);
        set.add(new Integer(val));
        return ++i;
    }

    private int positionAtCharL(int val, int type, int i, int base7Num) throws ParseException {
        if (type == 5) {
            if (val < 1 || val > base7Num) {
                throw new ParseException("Day-of-Week values must be between 1 and 7", -1);
            }
        } else {
            throw new ParseException("'L' option is not valid here. (pos=" + i + ")", i);
        }
        this.lastdayOfWeek = true;
        TreeSet set = this.getSet(type);
        set.add(new Integer(val));
        return ++i;
    }

    public String getCronExpression() {
        return this.cronExpression;
    }

    public String getExpressionSummary() {
        StringBuffer buf = new StringBuffer();
        buf.append("seconds: ");
        buf.append(this.getExpressionSetSummary(this.seconds));
        buf.append("\n");
        buf.append("minutes: ");
        buf.append(this.getExpressionSetSummary(this.minutes));
        buf.append("\n");
        buf.append("hours: ");
        buf.append(this.getExpressionSetSummary(this.hours));
        buf.append("\n");
        buf.append("daysOfMonth: ");
        buf.append(this.getExpressionSetSummary(this.daysOfMonth));
        buf.append("\n");
        buf.append("months: ");
        buf.append(this.getExpressionSetSummary(this.months));
        buf.append("\n");
        buf.append("daysOfWeek: ");
        buf.append(this.getExpressionSetSummary(this.daysOfWeek));
        buf.append("\n");
        buf.append("lastdayOfWeek: ");
        buf.append(this.lastdayOfWeek);
        buf.append("\n");
        buf.append("nearestWeekday: ");
        buf.append(this.nearestWeekday);
        buf.append("\n");
        buf.append("NthDayOfWeek: ");
        buf.append(this.nthdayOfWeek);
        buf.append("\n");
        buf.append("lastdayOfMonth: ");
        buf.append(this.lastdayOfMonth);
        buf.append("\n");
        buf.append("years: ");
        buf.append(this.getExpressionSetSummary(this.years));
        buf.append("\n");
        return buf.toString();
    }

    protected String getExpressionSetSummary(Set set) {
        if (set.contains(NO_SPEC)) {
            return "?";
        }
        if (set.contains(ALL_SPEC)) {
            return "*";
        }
        StringBuffer buf = new StringBuffer();
        Iterator itr = set.iterator();
        boolean first = true;
        while (itr.hasNext()) {
            Integer iVal = (Integer)itr.next();
            String val = iVal.toString();
            if (!first) {
                buf.append(",");
            }
            buf.append(val);
            first = false;
        }
        return buf.toString();
    }

    protected String getExpressionSetSummary(ArrayList list) {
        if (list.contains(NO_SPEC)) {
            return "?";
        }
        if (list.contains(ALL_SPEC)) {
            return "*";
        }
        StringBuffer buf = new StringBuffer();
        Iterator itr = list.iterator();
        boolean first = true;
        while (itr.hasNext()) {
            Integer iVal = (Integer)itr.next();
            String val = iVal.toString();
            if (!first) {
                buf.append(",");
            }
            buf.append(val);
            first = false;
        }
        return buf.toString();
    }

    protected int skipWhiteSpace(int i, String s) {
        char base4Char = ' ';
        char base3Char = '\t';
        while (i < s.length() && (s.charAt(i) == base4Char || s.charAt(i) == base3Char)) {
            ++i;
        }
        return i;
    }

    protected int findNextWhiteSpace(int i, String s) {
        char base4Char = ' ';
        char base3Char = '\t';
        while (i < s.length() && (s.charAt(i) != base4Char || s.charAt(i) != base3Char)) {
            ++i;
        }
        return i;
    }

    protected void addToSet(int val, int end, int incr, int type) throws ParseException {
        boolean existed;
        TreeSet set = this.getSet(type);
        int base59Num = 59;
        int base23Num = 23;
        this.valid(val, end, type, base59Num, base23Num);
        boolean bl = existed = (incr == 0 || incr == -1) && val != 99;
        if (existed) {
            if (val != -1) {
                set.add(new Integer(val));
            } else {
                set.add(NO_SPEC);
            }
            return;
        }
        AtomicInteger startAt = new AtomicInteger(val);
        AtomicInteger stopAt = new AtomicInteger(end);
        if (val == 99 && incr <= 0) {
            incr = 1;
            set.add(ALL_SPEC);
        }
        this.setStartAtAndStopAt(type, startAt, stopAt);
        int max = this.getMax(type, startAt, stopAt);
        for (int i = startAt.get(); i <= stopAt.get(); i += incr) {
            boolean checked;
            if (max == -1) {
                set.add(new Integer(i));
                continue;
            }
            int i2 = i % max;
            boolean bl2 = checked = i2 == 0 && (type == 4 || type == 5 || type == 3);
            if (checked) {
                i2 = max;
            }
            set.add(new Integer(i2));
        }
    }

    private int getMax(int type, AtomicInteger startAt, AtomicInteger stopAt) {
        int max = -1;
        if (stopAt.get() < startAt.get()) {
            switch (type) {
                case 0: {
                    max = 60;
                    break;
                }
                case 1: {
                    max = 60;
                    break;
                }
                case 2: {
                    max = 24;
                    break;
                }
                case 4: {
                    max = 12;
                    break;
                }
                case 5: {
                    max = 7;
                    break;
                }
                case 3: {
                    max = 31;
                    break;
                }
                case 6: {
                    throw new IllegalArgumentException("Start year must be less than stop year");
                }
                default: {
                    throw new IllegalArgumentException("Unexpected type encountered");
                }
            }
            stopAt.addAndGet(max);
        }
        return max;
    }

    private void setStartAtAndStopAt(int type, AtomicInteger startAt, AtomicInteger stopAt) {
        if (type == 0 || type == 1) {
            if (stopAt.get() == -1) {
                stopAt.set(59);
            }
            if (startAt.get() == -1 || startAt.get() == 99) {
                startAt.set(0);
            }
        } else if (type == 2) {
            if (stopAt.get() == -1) {
                stopAt.set(23);
            }
            if (startAt.get() == -1 || startAt.get() == 99) {
                startAt.set(0);
            }
        } else if (type == 3) {
            if (stopAt.get() == -1) {
                stopAt.set(31);
            }
            if (startAt.get() == -1 || startAt.get() == 99) {
                startAt.set(1);
            }
        } else if (type == 4) {
            if (stopAt.get() == -1) {
                stopAt.set(12);
            }
            if (startAt.get() == -1 || startAt.get() == 99) {
                startAt.set(1);
            }
        } else if (type == 5) {
            if (stopAt.get() == -1) {
                stopAt.set(7);
            }
            if (startAt.get() == -1 || startAt.get() == 99) {
                startAt.set(1);
            }
        } else if (type == 6) {
            if (stopAt.get() == -1) {
                stopAt.set(2299);
            }
            if (startAt.get() == -1 || startAt.get() == 99) {
                startAt.set(1970);
            }
        }
    }

    private void valid(int val, int end, int type, int base59Num, int base23Num) throws ParseException {
        if (type == 0 || type == 1) {
            boolean checked;
            boolean bl = checked = (val < 0 || val > base59Num || end > base59Num) && val != 99;
            if (checked) {
                throw new ParseException("Minute and Second values must be between 0 and 59", -1);
            }
        } else if (type == 2) {
            boolean existed;
            boolean bl = existed = (val < 0 || val > base23Num || end > base23Num) && val != 99;
            if (existed) {
                throw new ParseException("Hour values must be between 0 and 23", -1);
            }
        } else if (type == 3) {
            boolean existed;
            int base31Num = 31;
            boolean bl = existed = (val < 1 || val > base31Num || end > base31Num) && val != 99 && val != 98;
            if (existed) {
                throw new ParseException("Day of month values must be between 1 and 31", -1);
            }
        } else if (type == 4) {
            boolean existed;
            int base12Num = 12;
            boolean bl = existed = (val < 1 || val > base12Num || end > base12Num) && val != 99;
            if (existed) {
                throw new ParseException("Month values must be between 1 and 12", -1);
            }
        } else if (type == 5) {
            boolean existed;
            int base7Num = 7;
            boolean bl = existed = (val == 0 || val > base7Num || end > base7Num) && val != 99 && val != 98;
            if (existed) {
                throw new ParseException("Day-of-Week values must be between 1 and 7", -1);
            }
        }
    }

    protected TreeSet getSet(int type) {
        switch (type) {
            case 0: {
                return this.seconds;
            }
            case 1: {
                return this.minutes;
            }
            case 2: {
                return this.hours;
            }
            case 3: {
                return this.daysOfMonth;
            }
            case 4: {
                return this.months;
            }
            case 5: {
                return this.daysOfWeek;
            }
            case 6: {
                return this.years;
            }
        }
        return null;
    }

    protected ValueSet getValue(int v, String s, int i) {
        char c = s.charAt(i);
        String s1 = String.valueOf(v);
        char base0Char = '0';
        char base9Char = '9';
        while (c >= base0Char && c <= base9Char) {
            s1 = s1 + c;
            if (++i >= s.length()) break;
            c = s.charAt(i);
        }
        ValueSet val = new ValueSet();
        val.pos = i < s.length() ? i : i + 1;
        val.value = Integer.parseInt(s1);
        return val;
    }

    protected int getNumericValue(String s, int i) {
        int endOfVal = this.findNextWhiteSpace(i, s);
        String val = s.substring(i, endOfVal);
        return Integer.parseInt(val);
    }

    protected int getMonthNumber(String s) {
        Integer integer = (Integer)MONTH_MAP.get(s);
        if (integer == null) {
            return -1;
        }
        return integer;
    }

    protected int getDayOfWeekNumber(String s) {
        Integer integer = (Integer)DAY_MAP.get(s);
        if (integer == null) {
            return -1;
        }
        return integer;
    }

    protected Date getTimeAfter(Date afterTime) {
        GregorianCalendar cl = new GregorianCalendar(this.getTimeZone());
        afterTime = new Date(afterTime.getTime() + 1000L);
        cl.setTime(afterTime);
        cl.set(14, 0);
        boolean gotOne = false;
        while (!gotOne) {
            if (cl.get(1) > 2999) {
                return null;
            }
            this.getSecond(cl);
            if (this.getMinute(cl) || this.getHour(cl) || this.getDay(cl, afterTime)) continue;
            int year = cl.get(1);
            if (year > 2299) {
                return null;
            }
            if (this.getMonth(cl)) continue;
            year = cl.get(1);
            SortedSet<Integer> st = this.years.tailSet(new Integer(year));
            if (st == null || st.isEmpty()) {
                return null;
            }
            if (this.getYear(cl, st)) continue;
            gotOne = true;
        }
        return cl.getTime();
    }

    private boolean getYear(Calendar cl, SortedSet st) {
        int t = cl.get(1);
        int year = (Integer)st.first();
        if (year != t) {
            this.setCalendar(cl, 0, 0, 0, 1, 0);
            cl.set(1, year);
            return true;
        }
        cl.set(1, year);
        return false;
    }

    private boolean getMonth(Calendar cl) {
        int mon = cl.get(2) + 1;
        int year = cl.get(1);
        int t = -1;
        SortedSet<Integer> st = this.months.tailSet(new Integer(mon));
        if (st != null && st.size() != 0) {
            t = mon;
            mon = st.first();
        } else {
            mon = (Integer)this.months.first();
            ++year;
        }
        if (mon != t) {
            this.setCalendar(cl, 0, 0, 0, 1, mon - 1);
            cl.set(1, year);
            return true;
        }
        cl.set(2, mon - 1);
        return false;
    }

    private boolean getDay(Calendar cl, Date afterTime) {
        boolean daysOfWeekSpec;
        AtomicInteger day = new AtomicInteger(cl.get(5));
        boolean daysOfMonthSpec = !this.daysOfMonth.contains(NO_SPEC);
        boolean bl = daysOfWeekSpec = !this.daysOfWeek.contains(NO_SPEC);
        if (daysOfMonthSpec && !daysOfWeekSpec) {
            if (this.getDayByDayOfMonthRule(cl, afterTime, day)) {
                return true;
            }
        } else if (daysOfWeekSpec && !daysOfMonthSpec) {
            if (this.getDatByDayOfWeekRule(cl, day)) {
                return true;
            }
        } else {
            throw new UnsupportedOperationException("Support for specifying both a day-of-week AND a day-of-month parameter is not implemented.");
        }
        cl.set(5, day.get());
        return false;
    }

    private boolean getDayByDayOfMonthRule(Calendar cl, Date afterTime, AtomicInteger day) {
        int mon;
        int sec = cl.get(13);
        int min = cl.get(12);
        int hr = cl.get(11);
        int t = -1;
        int tmon = mon = cl.get(2) + 1;
        SortedSet<Integer> st = this.daysOfMonth.tailSet(new Integer(day.get()));
        if (this.lastdayOfMonth) {
            Date nTime;
            t = day.get();
            day.set(this.getLastDayOfMonth(mon, cl.get(1)));
            if (this.nearestWeekday && (nTime = this.getTime(cl, day, sec, min, hr, mon)).before(afterTime)) {
                day.set(1);
                ++mon;
            }
        } else if (this.nearestWeekday) {
            t = day.get();
            day.set((Integer)this.daysOfMonth.first());
            Date nTime = this.getTime(cl, day, sec, min, hr, mon);
            if (nTime.before(afterTime)) {
                day.set((Integer)this.daysOfMonth.first());
                ++mon;
            }
        } else if (st != null && st.size() != 0) {
            t = day.get();
            day.set(st.first());
            int lastDay = this.getLastDayOfMonth(mon, cl.get(1));
            if (day.get() > lastDay) {
                day.set((Integer)this.daysOfMonth.first());
                ++mon;
            }
        } else {
            day.set((Integer)this.daysOfMonth.first());
            ++mon;
        }
        if (day.get() != t || mon != tmon) {
            this.setCalendar(cl, 0, 0, 0, day.get(), mon - 1);
            return true;
        }
        return false;
    }

    private Date getTime(Calendar cl, AtomicInteger day, int sec, int min, int hr, int mon) {
        Calendar tcal = Calendar.getInstance(this.getTimeZone());
        this.setCalendar(tcal, 0, 0, 0, day.get(), mon - 1);
        tcal.set(1, cl.get(1));
        int ldom = this.getLastDayOfMonth(mon, cl.get(1));
        int dow = tcal.get(7);
        if (dow == 7 && day.get() == 1) {
            day.addAndGet(2);
        } else if (dow == 7) {
            day.addAndGet(-1);
        } else if (dow == 1 && day.get() == ldom) {
            day.addAndGet(-2);
        } else if (dow == 1) {
            day.addAndGet(1);
        }
        this.setCalendar(tcal, sec, min, hr, day.get(), mon - 1);
        return tcal.getTime();
    }

    private boolean getDatByDayOfWeekRule(Calendar cl, AtomicInteger day) {
        int mon = cl.get(2) + 1;
        int num7 = 7;
        if (this.lastdayOfWeek) {
            int dow = (Integer)this.daysOfWeek.first();
            int cDow = cl.get(7);
            int daysToAdd = this.getDaysToAdd(cDow, dow);
            int lDay = this.getLastDayOfMonth(mon, cl.get(1));
            if (day.get() + daysToAdd > lDay) {
                this.setCalendar(cl, 0, 0, 0, 1, mon);
                return true;
            }
            int base7Num = 7;
            while (day.get() + daysToAdd + base7Num <= lDay) {
                daysToAdd += base7Num;
            }
            int andGetDay = day.addAndGet(daysToAdd);
            if (daysToAdd > 0) {
                this.setCalendar(cl, 0, 0, 0, andGetDay, mon - 1);
                return true;
            }
        } else if (this.nthdayOfWeek != 0) {
            int dow = (Integer)this.daysOfWeek.first();
            int cDow = cl.get(7);
            int daysToAdd = 0;
            if (cDow < dow) {
                daysToAdd = dow - cDow;
            } else if (cDow > dow) {
                daysToAdd = dow + (7 - cDow);
            }
            boolean dayShifted = false;
            if (daysToAdd > 0) {
                dayShifted = true;
            }
            int andGetDay = day.addAndGet(daysToAdd);
            int weekOfMonth = andGetDay / 7;
            if (andGetDay % 7 > 0) {
                ++weekOfMonth;
            }
            daysToAdd = (this.nthdayOfWeek - weekOfMonth) * 7;
            andGetDay = day.addAndGet(daysToAdd);
            if (daysToAdd < 0 || andGetDay > this.getLastDayOfMonth(mon, cl.get(1))) {
                this.setCalendar(cl, 0, 0, 0, 1, mon);
                return true;
            }
            if (daysToAdd > 0 || dayShifted) {
                this.setCalendar(cl, 0, 0, 0, day.get(), mon - 1);
                return true;
            }
        } else {
            int cDow = cl.get(7);
            int dow = (Integer)this.daysOfWeek.first();
            SortedSet<Integer> st = this.daysOfWeek.tailSet(new Integer(cDow));
            if (st != null && st.size() > 0) {
                dow = st.first();
            }
            int daysToAdd = this.getDaysToAdd(cDow, dow);
            int lDay = this.getLastDayOfMonth(mon, cl.get(1));
            if (day.get() + daysToAdd > lDay) {
                this.setCalendar(cl, 0, 0, 0, 1, mon);
                return true;
            }
            if (daysToAdd > 0) {
                this.setCalendar(cl, 0, 0, 0, day.get() + daysToAdd, mon - 1);
                return true;
            }
        }
        return false;
    }

    private int getDaysToAdd(int cDow, int dow) {
        int daysToAdd = 0;
        if (cDow < dow) {
            daysToAdd = dow - cDow;
        }
        if (cDow > dow) {
            daysToAdd = dow + (7 - cDow);
        }
        return daysToAdd;
    }

    private void setCalendar(Calendar cl, int second, int minute, int hourOfDay, int dayOfMonth, int month) {
        cl.set(13, second);
        cl.set(12, minute);
        cl.set(11, hourOfDay);
        cl.set(5, dayOfMonth);
        cl.set(2, month);
    }

    private boolean getHour(Calendar cl) {
        int hr = cl.get(11);
        int day = cl.get(5);
        int t = -1;
        SortedSet<Integer> st = this.hours.tailSet(new Integer(hr));
        if (st != null && st.size() != 0) {
            t = hr;
            hr = st.first();
        } else {
            hr = (Integer)this.hours.first();
            ++day;
        }
        if (hr != t) {
            cl.set(13, 0);
            cl.set(12, 0);
            cl.set(5, day);
            this.setCalendarHour(cl, hr);
            return true;
        }
        cl.set(11, hr);
        return false;
    }

    private boolean getMinute(Calendar cl) {
        int min = cl.get(12);
        int hr = cl.get(11);
        int t = -1;
        SortedSet<Integer> st = this.minutes.tailSet(new Integer(min));
        if (st != null && st.size() != 0) {
            t = min;
            min = st.first();
        } else {
            min = (Integer)this.minutes.first();
            ++hr;
        }
        if (min != t) {
            cl.set(13, 0);
            cl.set(12, min);
            this.setCalendarHour(cl, hr);
            return true;
        }
        cl.set(12, min);
        return false;
    }

    private void getSecond(Calendar cl) {
        int sec = cl.get(13);
        int min = cl.get(12);
        SortedSet<Integer> st = this.seconds.tailSet(new Integer(sec));
        if (st != null && st.size() != 0) {
            sec = st.first();
        } else {
            sec = (Integer)this.seconds.first();
            cl.set(12, ++min);
        }
        cl.set(13, sec);
    }

    protected void setCalendarHour(Calendar cal, int hour) {
        cal.set(11, hour);
        int base24Num = 24;
        if (cal.get(11) != hour && hour != base24Num) {
            cal.set(11, hour + 1);
        }
    }

    protected Date getTimeBefore(Date endTime) {
        return null;
    }

    public Date getFinalFireTime() {
        return null;
    }

    protected boolean isLeapYear(int year) {
        return year % 4 == 0 && year % 100 != 0 || year % 400 == 0;
    }

    protected int getLastDayOfMonth(int monthNum, int year) {
        switch (monthNum) {
            case 1: {
                return 31;
            }
            case 2: {
                return this.isLeapYear(year) ? 29 : 28;
            }
            case 3: {
                return 31;
            }
            case 4: {
                return 30;
            }
            case 5: {
                return 31;
            }
            case 6: {
                return 30;
            }
            case 7: {
                return 31;
            }
            case 8: {
                return 31;
            }
            case 9: {
                return 30;
            }
            case 10: {
                return 31;
            }
            case 11: {
                return 30;
            }
            case 12: {
                return 31;
            }
        }
        throw new IllegalArgumentException("Illegal month number: " + monthNum);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        try {
            this.buildExpression(this.cronExpression);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Object copy() {
        CronExpression copy = null;
        try {
            copy = new CronExpression(this.getCronExpression());
            if (this.getTimeZone() != null) {
                copy.setTimeZone((TimeZone)this.getTimeZone().clone());
            }
        }
        catch (ParseException ex) {
            throw new IncompatibleClassChangeError("Not Cloneable.");
        }
        return copy;
    }

    static {
        MONTH_MAP.put("JAN", new Integer(0));
        MONTH_MAP.put("FEB", new Integer(1));
        MONTH_MAP.put("MAR", new Integer(2));
        MONTH_MAP.put("APR", new Integer(3));
        MONTH_MAP.put("MAY", new Integer(4));
        MONTH_MAP.put("JUN", new Integer(5));
        MONTH_MAP.put("JUL", new Integer(6));
        MONTH_MAP.put("AUG", new Integer(7));
        MONTH_MAP.put("SEP", new Integer(8));
        MONTH_MAP.put("OCT", new Integer(9));
        MONTH_MAP.put("NOV", new Integer(10));
        MONTH_MAP.put("DEC", new Integer(11));
        DAY_MAP.put("SUN", new Integer(1));
        DAY_MAP.put("MON", new Integer(2));
        DAY_MAP.put("TUE", new Integer(3));
        DAY_MAP.put("WED", new Integer(4));
        DAY_MAP.put("THU", new Integer(5));
        DAY_MAP.put("FRI", new Integer(6));
        DAY_MAP.put("SAT", new Integer(7));
    }
}

