/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.bsp.workflow.comm.in.impl;

import cn.com.yusys.yusp.bsp.communication.AbstractRequest;
import cn.com.yusys.yusp.bsp.communication.StreamRequest;
import cn.com.yusys.yusp.bsp.component.exception.ComponentException;
import cn.com.yusys.yusp.bsp.toolkit.common.ByteTools;
import cn.com.yusys.yusp.bsp.toolkit.common.StringTools;
import cn.com.yusys.yusp.bsp.workflow.comm.in.AbstractCommIn;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class FixCommIn
extends AbstractCommIn {
    protected String unitName = "Fixed length communication access";
    protected static final String HEADER_DATA_INT = "Integer";
    protected static final String HEADER_DATA_SHORT = "Short";
    protected static final String HEADER_DATA_STR = "String";
    protected static final String HEADER_DATA_BYTE = "Byte";
    private String headerType;
    private String containSelf;
    private String headerLenStr;

    @Override
    public void processSend(Map<String, Object> context, byte[] bsend, AbstractRequest request) throws Exception {
        StreamRequest streamRequest = (StreamRequest)request;
        DataOutputStream dos = new DataOutputStream(streamRequest.getSocketWrapper().getBos());
        if (bsend == null || bsend.length == 0) {
            throw new Exception(this.getUnitName() + " @ The variable sent is empty");
        }
        boolean containSelf = false;
        if ("true".equals(this.containSelf)) {
            containSelf = true;
        }
        int tempLen = bsend.length;
        try {
            if (HEADER_DATA_SHORT.equals(this.headerType)) {
                if (containSelf) {
                    tempLen += 2;
                }
                dos.writeShort(tempLen);
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("{} @ Send packet header data[2]:\n{}", new Object[]{this.getUnitName(), StringTools.toHexTable(ByteTools.int2HexBcdByte(tempLen, true, 0, 4))});
                }
            } else if (HEADER_DATA_INT.equals(this.headerType)) {
                if (containSelf) {
                    tempLen += 4;
                }
                dos.writeInt(tempLen);
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("{} @ Send packet header data[4]:\n{}", new Object[]{this.getUnitName(), StringTools.toHexTable(ByteTools.int2HexBcdByte(tempLen, true, 0, 8))});
                }
            } else if (HEADER_DATA_BYTE.equals(this.headerType)) {
                if (containSelf) {
                    ++tempLen;
                }
                dos.writeByte(tempLen);
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("{} @ Send packet header data[1]:\n{}", new Object[]{this.getUnitName(), StringTools.toHexTable(ByteTools.int2HexBcdByte(tempLen, true, 0, 2))});
                }
            } else if (HEADER_DATA_STR.equals(this.headerType)) {
                int headerLen;
                String headerLenStr = FixCommIn.getInExpressStringValue(this.headerLenStr, context);
                if (StringUtils.isEmpty((CharSequence)headerLenStr)) {
                    throw new ComponentException("The packet header length is empty");
                }
                try {
                    headerLen = Integer.parseInt(headerLenStr);
                }
                catch (Exception e) {
                    throw new ComponentException("Packet header length: " + headerLenStr + " is not number");
                }
                if (headerLen <= 0) {
                    throw new ComponentException("Packet header length must be greater than 0");
                }
                if (containSelf) {
                    tempLen += headerLen;
                }
                String sLen = String.valueOf(tempLen);
                StringBuilder sHeaderLen = new StringBuilder();
                int fillLen = headerLen - sLen.length();
                for (int i = 0; i < fillLen; ++i) {
                    sHeaderLen.append('0');
                }
                sHeaderLen.append(sLen);
                dos.write(sHeaderLen.toString().getBytes());
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("{} @ Send packet header data[{}]:\n{}", new Object[]{this.getUnitName(), headerLen, StringTools.toHexTable(sHeaderLen.toString().getBytes())});
                }
            } else {
                throw new Exception(this.getUnitName() + " @ Send data, incorrect packet header data type [" + this.headerType + "]!");
            }
            dos.write(bsend);
            this.printSendData(bsend);
            dos.flush();
        }
        catch (Exception e) {
            throw new Exception(this.getUnitName() + " @ Send data exception", e);
        }
    }

    @Override
    public byte[] processRecv(Map<String, Object> context, AbstractRequest request) throws Exception {
        int nHeaderLen;
        StreamRequest streamRequest = (StreamRequest)request;
        DataInputStream dis = new DataInputStream(streamRequest.getSocketWrapper().getBis());
        boolean containSelf = false;
        if ("true".equals(this.containSelf)) {
            containSelf = true;
        }
        if (HEADER_DATA_SHORT.equals(this.headerType)) {
            nHeaderLen = dis.readShort();
            if (this.logger.isInfoEnabled()) {
                this.logger.info("{} @ Receive packet header data[2]:\n{}", new Object[]{this.getUnitName(), StringTools.toHexTable(ByteTools.int2HexBcdByte(nHeaderLen, true, 0, 4))});
            }
            if (containSelf) {
                nHeaderLen -= 2;
            }
        } else if (HEADER_DATA_INT.equals(this.headerType)) {
            nHeaderLen = dis.readInt();
            if (this.logger.isInfoEnabled()) {
                this.logger.info("{} @ Receive packet header data[4]:\n{}", new Object[]{this.getUnitName(), StringTools.toHexTable(ByteTools.int2HexBcdByte(nHeaderLen, true, 0, 8))});
            }
            if (containSelf) {
                nHeaderLen -= 4;
            }
        } else if (HEADER_DATA_BYTE.equals(this.headerType)) {
            nHeaderLen = dis.readByte();
            if (this.logger.isInfoEnabled()) {
                this.logger.info("{} @ Receive packet header data[1]:\n{}", new Object[]{this.getUnitName(), StringTools.toHexTable(ByteTools.int2HexBcdByte(nHeaderLen, true, 0, 2))});
            }
            if (containSelf) {
                --nHeaderLen;
            }
        } else if (HEADER_DATA_STR.equals(this.headerType)) {
            int headerLen;
            String headerLenStr = FixCommIn.getInExpressStringValue(this.headerLenStr, context);
            if (StringUtils.isEmpty((CharSequence)headerLenStr)) {
                throw new ComponentException("The packet header length is empty");
            }
            try {
                headerLen = Integer.parseInt(headerLenStr);
            }
            catch (Exception e) {
                throw new ComponentException("Packet header length: " + headerLenStr + " is not number");
            }
            if (headerLen <= 0) {
                throw new ComponentException("Packet header length must be greater than 0");
            }
            byte[] dataLen = new byte[headerLen];
            dis.readFully(dataLen);
            if (this.logger.isInfoEnabled()) {
                this.logger.info("{} @ Receive packet header data[{}]:\n{}", new Object[]{this.getUnitName(), headerLen, StringTools.toHexTable(dataLen)});
            }
            nHeaderLen = Integer.parseInt(new String(dataLen).trim());
            if (containSelf) {
                nHeaderLen -= headerLen;
            }
        } else {
            throw new ComponentException("Receive data, incorrect packet data type [" + this.headerType + "]!");
        }
        if ((long)nHeaderLen > 0xA00000L) {
            throw new ComponentException("Request buffer too large :" + nHeaderLen + " recv failed");
        }
        if (nHeaderLen < 0) {
            throw new ComponentException("Illegal packet header length :" + nHeaderLen);
        }
        byte[] recv = new byte[nHeaderLen];
        if (nHeaderLen > 0) {
            dis.readFully(recv);
            this.printRecvData(recv);
        }
        return recv;
    }

    @Override
    public String getUnitName() {
        return this.unitName;
    }

    public String getHeaderType() {
        return this.headerType;
    }

    public void setHeaderType(String headerType) {
        this.headerType = headerType;
    }

    public String getContainSelf() {
        return this.containSelf;
    }

    public void setContainSelf(String containSelf) {
        this.containSelf = containSelf;
    }

    public String getHeaderLenStr() {
        return this.headerLenStr;
    }

    public void setHeaderLenStr(String headerLenStr) {
        this.headerLenStr = headerLenStr;
    }
}

