/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.bsp.toolkit.reflect;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Map;
import org.springframework.core.ResolvableType;

public class BeanMapUtil {
    private final ObjectMapper objectMapper = new ObjectMapper();

    public BeanMapUtil() {
        this.objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        this.objectMapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        this.objectMapper.disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
        this.objectMapper.enable(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY);
        this.objectMapper.enable(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT);
        this.objectMapper.enable(new JsonParser.Feature[]{JsonParser.Feature.ALLOW_COMMENTS});
    }

    public String mapToJson(Map<String, Object> map) throws JsonProcessingException {
        return this.objectMapper.writeValueAsString(map);
    }

    public Map<String, Object> jsonToMap(String json) throws IOException {
        return (Map)this.objectMapper.readValue(json, Map.class);
    }

    public <T> Map<String, Object> beanToMap(T bean) throws IOException {
        if (!(bean instanceof Map)) {
            byte[] bs = this.beanToJson(bean);
            return (Map)this.objectMapper.readValue(bs, Map.class);
        }
        return (Map)bean;
    }

    public <T> byte[] beanToJson(T bean) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectWriter objectWriter = this.objectMapper.writer();
        JsonGenerator generator = this.objectMapper.getFactory().createGenerator((OutputStream)baos);
        objectWriter.writeValue(generator, bean);
        return baos.toByteArray();
    }

    public <T> T mapToBean(Map<String, Object> paramMap, Class<T> clazz, Type type) throws IOException {
        if (clazz != null && !clazz.isInstance(paramMap)) {
            byte[] bs = this.objectMapper.writeValueAsBytes(paramMap);
            return this.jsonToBean(bs, clazz, type);
        }
        return (T)paramMap;
    }

    public <T> T jsonToBean(byte[] src, Class<T> clazz, Type type) throws IOException {
        JavaType valueType = this.getJavaType(type, clazz);
        return (T)this.objectMapper.readValue(src, valueType);
    }

    protected JavaType getJavaType(Type type, Class<?> contextClass) {
        TypeFactory typeFactory = this.objectMapper.getTypeFactory();
        if (contextClass != null) {
            ResolvableType resolvedType = ResolvableType.forType((Type)type);
            if (type instanceof TypeVariable) {
                ResolvableType resolvedTypeVariable = this.resolveVariable((TypeVariable)type, ResolvableType.forClass(contextClass));
                if (resolvedTypeVariable != ResolvableType.NONE) {
                    return typeFactory.constructType((Type)resolvedTypeVariable.resolve());
                }
            } else if (type instanceof ParameterizedType && resolvedType.hasUnresolvableGenerics()) {
                ParameterizedType parameterizedType = (ParameterizedType)type;
                Class[] generics = new Class[parameterizedType.getActualTypeArguments().length];
                Type[] typeArguments = parameterizedType.getActualTypeArguments();
                for (int i = 0; i < typeArguments.length; ++i) {
                    Type typeArgument = typeArguments[i];
                    if (typeArgument instanceof TypeVariable) {
                        ResolvableType resolvedTypeArgument = this.resolveVariable((TypeVariable)typeArgument, ResolvableType.forClass(contextClass));
                        if (resolvedTypeArgument != ResolvableType.NONE) {
                            generics[i] = resolvedTypeArgument.resolve();
                            continue;
                        }
                        generics[i] = ResolvableType.forType((Type)typeArgument).resolve();
                        continue;
                    }
                    generics[i] = ResolvableType.forType((Type)typeArgument).resolve();
                }
                Class rawClass = resolvedType.getRawClass();
                if (rawClass == null) {
                    return null;
                }
                return typeFactory.constructType(ResolvableType.forClassWithGenerics((Class)rawClass, (Class[])generics).getType());
            }
        }
        return typeFactory.constructType(type);
    }

    private ResolvableType resolveVariable(TypeVariable<?> typeVariable, ResolvableType contextType) {
        ResolvableType resolvedType;
        if (contextType.hasGenerics() && (resolvedType = ResolvableType.forType(typeVariable, (ResolvableType)contextType)).resolve() != null) {
            return resolvedType;
        }
        ResolvableType superType = contextType.getSuperType();
        if (superType != ResolvableType.NONE && (resolvedType = this.resolveVariable(typeVariable, superType)).resolve() != null) {
            return resolvedType;
        }
        for (ResolvableType ifc : contextType.getInterfaces()) {
            resolvedType = this.resolveVariable(typeVariable, ifc);
            if (resolvedType.resolve() == null) continue;
            return resolvedType;
        }
        return ResolvableType.NONE;
    }
}

