/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.bsp.resources;

import cn.com.yusys.yusp.bsp.resources.ResourceException;
import cn.com.yusys.yusp.bsp.resources.creator.IResourceCreator;
import java.io.File;
import java.util.HashMap;
import java.util.Map;

public class ResourceCreator {
    private static final Map<String, IResourceCreator> _creatorRegistry = new HashMap<String, IResourceCreator>();

    public static void addCreator(IResourceCreator creator) {
        _creatorRegistry.put(creator.getResourceType(), creator);
    }

    public static Object createResource(String fileType, String resource) throws ResourceException {
        if (fileType == null) {
            throw new ResourceException("Illegal parameter, parameter name: fileType, parameter value is null");
        }
        if (resource == null) {
            throw new ResourceException("Illegal parameter, parameter name: resource, parameter value is null");
        }
        try {
            IResourceCreator creator = _creatorRegistry.get(fileType);
            if (creator == null) {
                throw new ResourceException("No suitable resource loader found:" + fileType);
            }
            if ("mpd".equals(fileType)) {
                return creator.createResource(resource);
            }
            if ("mfd".equals(fileType)) {
                return creator.createResource(resource);
            }
            if ("properties".equals(fileType)) {
                return creator.createResource(resource);
            }
            File resourceFile = new File(resource);
            if (!resourceFile.isFile()) {
                throw new ResourceException("Resource file does not exist:" + resource);
            }
            return creator.createResource(resourceFile);
        }
        catch (Exception e) {
            throw new ResourceException("New resource exception, resource type:" + fileType + ",resource:" + resource, e);
        }
    }
}

