/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.bsp.core;

import cn.com.yusys.yusp.bsp.communication.IRequest;
import cn.com.yusys.yusp.bsp.component.WorkflowInputFactory;
import cn.com.yusys.yusp.bsp.component.exception.BizException;
import cn.com.yusys.yusp.bsp.core.AsyncResponseCallback;
import cn.com.yusys.yusp.bsp.core.DefaultWorkflowHandler;
import cn.com.yusys.yusp.bsp.core.IAdapterDispatcher;
import cn.com.yusys.yusp.bsp.core.IWorkflowHandler;
import cn.com.yusys.yusp.bsp.resources.BspContextHolder;
import cn.com.yusys.yusp.bsp.resources.BspDataContext;
import cn.com.yusys.yusp.bsp.resources.Session;
import cn.com.yusys.yusp.bsp.resources.core.AbstractBean;
import cn.com.yusys.yusp.bsp.resources.log.BspSpan;
import cn.com.yusys.yusp.bsp.resources.log.Slf4jSpanLogger;
import cn.com.yusys.yusp.bsp.resources.pool.thread.ExecutorWrapper;
import cn.com.yusys.yusp.bsp.toolkit.logback.LogbackUtil;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultDispatcher
extends AbstractBean
implements IAdapterDispatcher {
    private boolean f5Check = false;
    private String f5Reqmsg;
    private String f5Respmsg;
    private ExecutorWrapper executorWrapper;
    private WorkflowInputFactory workflowFactory;
    private boolean printHex = false;
    protected final Logger logger = LoggerFactory.getLogger(DefaultDispatcher.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void triggerRequest(IRequest request) {
        Slf4jSpanLogger spanLogger = new Slf4jSpanLogger();
        try {
            Session session = this.initSession();
            spanLogger.logStartedSpan(session.getSpan(), session.getSpan());
            request.initContext(session.getContext());
            session.setInRequest(request);
            request.getInAdapter().putRequest(session.getSessionId(), request);
            IWorkflowHandler workflowHandler = this.createWorkflowHandler(session);
            this.executorWrapper.execute(workflowHandler);
        }
        catch (Throwable e) {
            this.logger.error("Exception processing access adapter request, which does not process: ", e);
            try {
                request.setCloseFlag(true);
                request.returnToInAdapter();
            }
            catch (Exception e1) {
                this.logger.error("Return connection exception", (Throwable)e1);
            }
        }
        finally {
            spanLogger.logStoppedSpan();
        }
    }

    private Session initSession() {
        Session session = new Session();
        BspSpan span = new BspSpan();
        session.setSpan(span);
        String sn = span.getStringTraceId();
        session.setSessionId(sn);
        session.setPrintHex(this.isPrintHex());
        if (this.isF5Check()) {
            session.setF5Check(this.isF5Check());
            session.setF5Reqmsg(this.getF5Reqmsg());
            session.setF5Respmsg(this.getF5Respmsg());
        }
        session.getContext().put("G_SN", sn);
        session.getContext().put("T_SESSION", session);
        return session;
    }

    private IWorkflowHandler createWorkflowHandler(Session session) {
        AsyncResponseCallback callback = new AsyncResponseCallback(context -> {
            block16: {
                BspDataContext replyBspContext = null;
                try {
                    if (context != null && session.getContext() != context) {
                        replyBspContext = BspContextHolder.getInstance().getBspDataContext();
                        this.mergeContext(session, (Map<String, Object>)context);
                    }
                    this.workflowFactory.buildCallbackFlow().execute(session.getContext());
                    if (replyBspContext == null) break block16;
                }
                catch (BizException e) {
                    block17: {
                        Map<String, Object> tmpContext = session.getContext();
                        BizException bizException = e;
                        tmpContext.put("G_RET_CODE", bizException.getExceptionCode());
                        tmpContext.put("G_RET_MSG", bizException.getExceptionMsg());
                        try {
                            this.logger.info("error execute");
                            this.workflowFactory.buildErrorFlow().execute(tmpContext);
                        }
                        catch (Exception e1) {
                            this.logger.error("error execute exception", (Throwable)e1);
                        }
                        if (replyBspContext != null) {
                            BspContextHolder.getInstance().putBspDataContext(replyBspContext);
                        }
                        session.destory();
                        if (this.getSid().equals(session.getModuleName())) break block17;
                        LogbackUtil.putSingleInfo("name", this.getSid());
                    }
                    long endtime = System.currentTimeMillis();
                    session.setTradeEndTime(endtime);
                    this.logger.info("Transaction finished, took [{}] ms", (Object)(endtime - session.getTradeStartTime()));
                }
                catch (Exception e2) {
                    block18: {
                        this.logger.error("execute error", (Throwable)e2);
                        try {
                            this.logger.info("error execute");
                            this.workflowFactory.buildErrorFlow().execute(session.getContext());
                        }
                        catch (Exception e1) {
                            this.logger.error("error execute exception", (Throwable)e1);
                        }
                        if (replyBspContext != null) {
                            BspContextHolder.getInstance().putBspDataContext(replyBspContext);
                        }
                        session.destory();
                        if (this.getSid().equals(session.getModuleName())) break block18;
                        {
                            catch (Throwable throwable) {
                                if (replyBspContext != null) {
                                    BspContextHolder.getInstance().putBspDataContext(replyBspContext);
                                }
                                session.destory();
                                if (!this.getSid().equals(session.getModuleName())) {
                                    LogbackUtil.putSingleInfo("name", this.getSid());
                                }
                                long endtime = System.currentTimeMillis();
                                session.setTradeEndTime(endtime);
                                this.logger.info("Transaction finished, took [{}] ms", (Object)(endtime - session.getTradeStartTime()));
                                throw throwable;
                            }
                        }
                        LogbackUtil.putSingleInfo("name", this.getSid());
                    }
                    long endtime = System.currentTimeMillis();
                    session.setTradeEndTime(endtime);
                    this.logger.info("Transaction finished, took [{}] ms", (Object)(endtime - session.getTradeStartTime()));
                }
                BspContextHolder.getInstance().putBspDataContext(replyBspContext);
            }
            session.destory();
            if (!this.getSid().equals(session.getModuleName())) {
                LogbackUtil.putSingleInfo("name", this.getSid());
            }
            long endtime = System.currentTimeMillis();
            session.setTradeEndTime(endtime);
            this.logger.info("Transaction finished, took [{}] ms", (Object)(endtime - session.getTradeStartTime()));
        }, context -> {
            try {
                if (context != null && session.getContext() != context) {
                    this.mergeContext(session, (Map<String, Object>)context);
                }
                this.logger.info("error execute");
                this.workflowFactory.buildErrorFlow().execute(session.getContext());
            }
            catch (Exception e) {
                this.logger.error("error execute exception", (Throwable)e);
            }
            finally {
                session.destory();
                long endtime = System.currentTimeMillis();
                session.setTradeEndTime(endtime);
                this.logger.info("Transaction finished, took [{}] ms", (Object)(endtime - session.getTradeStartTime()));
            }
        });
        session.setResponseCallback(callback);
        DefaultWorkflowHandler workflowHandler = new DefaultWorkflowHandler();
        workflowHandler.setSession(session);
        workflowHandler.setComponent(this.workflowFactory.buildFlow());
        return workflowHandler;
    }

    private void mergeContext(Session session, Map<String, Object> context) {
        Map<String, Object> sessionContext = session.getContext();
        Session replySession = (Session)context.get("T_SESSION");
        if (replySession != null) {
            replySession.setSessionId(session.getSessionId());
            session.setModuleName(replySession.getModuleName());
        }
        for (Map.Entry<String, Object> entry : context.entrySet()) {
            if (entry.getKey().startsWith("T_") || entry.getKey().startsWith("G_")) continue;
            sessionContext.put(entry.getKey(), entry.getValue());
        }
        BspContextHolder.getInstance().putBspDataContext(new BspDataContext(sessionContext));
    }

    @Override
    public ExecutorWrapper getExecutorWrapper() {
        return this.executorWrapper;
    }

    @Override
    public void setExecutorWrapper(ExecutorWrapper executorWrapper) {
        this.executorWrapper = executorWrapper;
    }

    public WorkflowInputFactory getWorkflowFactory() {
        return this.workflowFactory;
    }

    public void setWorkflowFactory(WorkflowInputFactory workflowFactory) {
        this.workflowFactory = workflowFactory;
    }

    public boolean isF5Check() {
        return this.f5Check;
    }

    public void setF5Check(boolean f5Check) {
        this.f5Check = f5Check;
    }

    public String getF5Reqmsg() {
        return this.f5Reqmsg;
    }

    public void setF5Reqmsg(String f5Reqmsg) {
        this.f5Reqmsg = f5Reqmsg;
    }

    public String getF5Respmsg() {
        return this.f5Respmsg;
    }

    public void setF5Respmsg(String f5Respmsg) {
        this.f5Respmsg = f5Respmsg;
    }

    public boolean isPrintHex() {
        return this.printHex;
    }

    public void setPrintHex(boolean printHex) {
        this.printHex = printHex;
    }

    @Override
    public void doStart() {
    }

    @Override
    public void doStop() {
    }
}

