/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.bsp.config.command;

import cn.com.yusys.yusp.bsp.config.command.CommandInfo;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.impl.DefaultHttpClientConnection;
import org.apache.http.message.BasicHttpEntityEnclosingRequest;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;

public class CommandClient {
    private static final String HTTP_HEADER_CONTENT_TYPE = "Content-Type";
    private static final String HTTP_HEADER_CONTENT_LENGTH = "Content-Length";
    private String host;
    private int port;
    private int timeout = 10000;
    private int connectTimeout = 5000;
    private String uri = "/";
    private String content_type = "text/xml; charset=UTF-8";

    public CommandClient(String host, int port) {
        this.host = host;
        this.port = port;
    }

    public CommandClient(String host, int port, String uri) {
        this.host = host;
        this.port = port;
        if (uri != null && uri.length() != 0) {
            this.uri = uri;
        }
    }

    public CommandInfo listModuleStatus(String moduleName) throws Exception {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("name", moduleName);
        headers.put("command", this.getCommandBeanName());
        headers.put("action", "list");
        return this.command(headers, null);
    }

    public CommandInfo listModulesStatus() throws Exception {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("name", "listall");
        headers.put("command", this.getCommandBeanName());
        headers.put("action", "listall");
        return this.command(headers, null);
    }

    public CommandInfo startModule(String moduleName) throws Exception {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("name", moduleName);
        headers.put("command", this.getCommandBeanName());
        headers.put("action", "start");
        return this.command(headers, null);
    }

    public CommandInfo stopModule(String moduleName) throws Exception {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("name", moduleName);
        headers.put("command", this.getCommandBeanName());
        headers.put("action", "stop");
        return this.command(headers, null);
    }

    public CommandInfo restartModule(String moduleName) throws Exception {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("name", moduleName);
        headers.put("command", this.getCommandBeanName());
        headers.put("action", "restart");
        return this.command(headers, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CommandInfo command(Map<String, String> headers, byte[] data) throws Exception {
        CommandInfo info;
        BasicHttpEntityEnclosingRequest request = new BasicHttpEntityEnclosingRequest("POST", this.uri);
        request.setHeader(HTTP_HEADER_CONTENT_TYPE, this.content_type);
        int dataLen = data == null ? 0 : data.length;
        request.setHeader(HTTP_HEADER_CONTENT_LENGTH, String.valueOf(dataLen));
        for (String key : headers.keySet()) {
            String value = headers.get(key);
            if (value == null) continue;
            value = URLEncoder.encode(value, "UTF-8");
            request.addHeader(key, value);
        }
        if (dataLen != 0) {
            InputStreamEntity entity = new InputStreamEntity((InputStream)new ByteArrayInputStream(data), (long)dataLen);
            request.setEntity((HttpEntity)entity);
        }
        try (DefaultHttpClientConnection client = new DefaultHttpClientConnection();){
            client.bind(this.newSocket(this.host, this.port), (HttpParams)this.getHttpParams());
            client.sendRequestHeader((HttpRequest)request);
            client.sendRequestEntity((HttpEntityEnclosingRequest)request);
            client.flush();
            HttpResponse response = client.receiveResponseHeader();
            Map<String, String> map = this.parserHeader(response.getAllHeaders());
            client.receiveResponseEntity(response);
            long rspDataLen = response.getEntity().getContentLength();
            byte[] rspData = null;
            if (rspDataLen > 0L) {
                rspData = new byte[(int)rspDataLen];
                new DataInputStream(response.getEntity().getContent()).readFully(rspData);
            }
            info = new CommandInfo(map, rspData);
        }
        return info;
    }

    private Map<String, String> parserHeader(Header[] headers) throws Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        for (Header h : headers) {
            map.put(h.getName(), URLDecoder.decode(h.getValue(), "utf-8"));
        }
        return map;
    }

    private Socket newSocket(String host, int port) throws IOException {
        Socket socket = new Socket();
        socket.connect(new InetSocketAddress(InetAddress.getByName(host), port), this.connectTimeout);
        socket.setSoTimeout(this.getTimeout());
        return socket;
    }

    private BasicHttpParams getHttpParams() {
        BasicHttpParams params = new BasicHttpParams();
        params.setIntParameter("http.socket.buffer-size", 8192);
        params.setBooleanParameter("http.connection.stalecheck", false);
        params.setBooleanParameter("http.tcp.nodelay", true);
        params.setParameter("http.origin-server", (Object)"HttpComponents/1.1");
        params.setIntParameter("http.socket.timeout", this.getTimeout());
        params.setIntParameter("http.connection.timeout", this.getConnectTimeout());
        return params;
    }

    protected String getCommandBeanName() {
        return "module";
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public String getContent_type() {
        return this.content_type;
    }

    public void setContent_type(String content_type) {
        this.content_type = content_type;
    }

    public static void main(String[] args) {
        CommandClient client = new CommandClient("127.0.0.1", 7680);
        try {
            String name = "commOut.test.test";
            CommandInfo info = client.stopModule(name);
            System.out.println(info.isSuccess() + ":" + info.getMessage());
            CommandInfo info2 = client.startModule(name);
            System.out.println(info2.isSuccess() + ":" + info2.getMessage());
            CommandInfo info3 = client.restartModule(name);
            System.out.println(info3.isSuccess() + ":" + info3.getMessage());
            CommandInfo info4 = client.listModuleStatus(name);
            System.out.println(info4.isSuccess() + ":" + info4.getMessage());
            CommandInfo info5 = client.listModulesStatus();
            System.out.println(info5.isSuccess() + ":" + info5.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

