/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.bsp.config;

import cn.com.yusys.yusp.bsp.app.config.AppStartAssist;
import cn.com.yusys.yusp.bsp.app.config.BspBoot;
import cn.com.yusys.yusp.bsp.resources.BspAppContext;
import cn.com.yusys.yusp.bsp.resources.ResourcePortal;
import cn.com.yusys.yusp.bsp.resources.bean.SpringContextRegistry;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;

public class ModuleHelper {
    private static final Logger logger = LoggerFactory.getLogger(ModuleHelper.class);
    private static final SpringContextRegistry _contextRegistry = ResourcePortal.getInstance().getSpringContextRegistry();

    public static void loadModule(String serviceName, String xml) {
        logger.info("msname:{}, bean:\n{}", (Object)serviceName, (Object)xml);
        BspAppContext xc = new BspAppContext(xml, BspBoot.applicationContext);
        try {
            Thread.currentThread().setName(serviceName);
            xc.refresh();
            _contextRegistry.addAppContext(serviceName, xc);
            AppStartAssist.addModule(serviceName);
        }
        catch (Exception e) {
            logger.error("module start fail:{}", (Object)serviceName, (Object)e);
            xc.close();
        }
    }

    public static void loadModule(String modulePath) {
        BspAppContext xc = new BspAppContext(new String[]{modulePath}, false, BspBoot.applicationContext);
        try {
            String serviceName = ModuleHelper.fetchService(modulePath);
            Thread.currentThread().setName(serviceName);
            logger.info("Load service name[{}] configuration", (Object)serviceName);
            xc.addBeanFactoryPostProcessor((BeanFactoryPostProcessor)BspBoot.applicationContext.getBean("customEditorConfigurer"));
            xc.refresh();
            _contextRegistry.addAppContext(serviceName, xc);
            AppStartAssist.addModule(serviceName);
        }
        catch (Exception e) {
            logger.error("module start fail:{}", (Object)modulePath, (Object)e);
            xc.close();
        }
    }

    public static String fetchService(String path) {
        int index = path.indexOf("config/comm");
        int startIndex = path.indexOf("/", index);
        int endIndex = path.indexOf("/module.mrd", startIndex);
        return path.substring(startIndex + 1, endIndex).replaceAll("/", ".");
    }

    public static void stopModule() {
        Collection<BspAppContext> contextSet = _contextRegistry.getContextMap().values();
        for (BspAppContext bspAppContext : contextSet) {
            bspAppContext.close();
        }
    }
}

