/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.bsp.communication.impl.in.tcp;

import cn.com.yusys.yusp.bsp.communication.IRequest;
import cn.com.yusys.yusp.bsp.communication.SocketWrapper;
import cn.com.yusys.yusp.bsp.communication.StreamRequest;
import cn.com.yusys.yusp.bsp.communication.impl.in.tcp.TCPInAdapter;
import cn.com.yusys.yusp.bsp.toolkit.common.IpFilter;
import cn.com.yusys.yusp.bsp.toolkit.common.StringTools;
import cn.com.yusys.yusp.bsp.toolkit.logback.LogbackUtil;
import java.io.IOException;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicInteger;

public class LongServerInAdapter
extends TCPInAdapter {
    private static final String IN_ADAPTER_NAME = "Long connection server access adapter";
    protected List<SocketWrapper> requestPool = Collections.synchronizedList(new ArrayList());
    protected int maxConnection;
    protected Thread socketListenerThread;
    protected Thread socketBorrowThread;
    protected AtomicInteger currentConnection = new AtomicInteger(0);
    protected Semaphore semaphore;
    private final Object mutex = new Object();
    private String ipAddress;
    private Set<String> ipList;

    @Override
    public void doStart() throws Exception {
        super.doStart();
        if (this.maxConnection <= 0) {
            throw new Exception(this.getAdapterTypeName() + " @ Illegal maximum connections[" + this.maxConnection + "]");
        }
        if (!StringTools.isEmpty(this.ipAddress)) {
            this.ipList = IpFilter.init(this.ipAddress);
        }
        this.semaphore = new Semaphore(this.maxConnection, true);
        this.semaphore.drainPermits();
        this.createServerSocket();
        this.socketListenerThread = new Thread((Runnable)new SocketListener(), this.getSid() + "-SocketListener:" + this.getPort());
        this.socketListenerThread.start();
        this.socketBorrowThread = new Thread((Runnable)this, this.getSid() + "-" + this.getClass().getSimpleName() + ":" + this.getPort());
        this.socketBorrowThread.start();
        this.logger.debug("{} @ Access adapter start", (Object)this.getAdapterTypeName());
    }

    @Override
    protected boolean checkSocketWrapper(SocketWrapper wrapper) {
        if (this.currentConnection.get() >= this.maxConnection) {
            this.logger.warn("{} @ The maximum number of connections {} has been reached, no new connections will be received [{}]", new Object[]{this.getAdapterTypeName(), this.maxConnection, wrapper.getSocket()});
            return false;
        }
        return true;
    }

    public Socket acceptSocket() throws Exception {
        Socket socket = this.server.accept();
        socket.setKeepAlive(true);
        socket.setSoTimeout(this.getTimeout());
        return socket;
    }

    @Override
    public IRequest makeRequest() throws Exception {
        this.semaphore.acquire();
        SocketWrapper wrapper = this.requestPool.remove(0);
        wrapper.setLastUsedTime(System.currentTimeMillis());
        StreamRequest borrowedRequest = new StreamRequest();
        borrowedRequest.setTimeStart(false);
        borrowedRequest.setDatasourceWrapper(wrapper);
        borrowedRequest.setInAdapter(this);
        return borrowedRequest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unmakeRequest(IRequest request) throws Exception {
        StreamRequest returnRequest = (StreamRequest)request;
        SocketWrapper returnWrapper = (SocketWrapper)returnRequest.getDatasourceWrapper();
        Socket returnSocket = returnWrapper.getSocket();
        if (this.isAvalible(returnRequest)) {
            this.logger.debug("{} @ Return connection [{}]", (Object)this.getAdapterTypeName(), (Object)returnSocket);
            this.requestPool.add(returnWrapper);
            this.semaphore.release();
        } else {
            Object object = this.mutex;
            synchronized (object) {
                try {
                    this.currentConnection.decrementAndGet();
                    returnRequest.close();
                    returnWrapper.setClose(true);
                    this.logger.debug("{} @ Clost connection[{}]", (Object)this.getAdapterTypeName(), (Object)returnSocket);
                }
                catch (IOException e) {
                    this.logger.debug(this.getAdapterTypeName() + " @ Exception in closing connetion" + returnSocket + ":", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doStop() throws Exception {
        super.doStop();
        this.currentConnection.set(0);
        this.semaphore.drainPermits();
        try {
            if (this.server != null) {
                this.server.close();
                this.server = null;
            }
            if (this.socketListenerThread != null) {
                this.socketListenerThread.interrupt();
                this.socketListenerThread = null;
            }
            if (this.socketBorrowThread != null) {
                this.socketBorrowThread.interrupt();
                this.socketBorrowThread = null;
            }
            Object object = this.mutex;
            synchronized (object) {
                for (SocketWrapper stopWrapper : this.requestPool) {
                    Socket stopSocket = stopWrapper.getSocket();
                    if (stopSocket == null || stopSocket.isClosed()) continue;
                    stopSocket.close();
                }
                this.requestPool.clear();
            }
        }
        catch (Exception e) {
            this.logger.error("{} @ Exception in stoping access adapter", (Object)this.getAdapterTypeName(), (Object)e);
            throw e;
        }
        this.logger.debug("{} @ Access adapter quit", (Object)this.getAdapterTypeName());
    }

    public int getMaxConnection() {
        return this.maxConnection;
    }

    public void setMaxConnection(int maxConnection) {
        this.maxConnection = maxConnection;
    }

    @Override
    public String getAdapterTypeName() {
        return IN_ADAPTER_NAME;
    }

    public int getRequestPoolSize() {
        return this.requestPool == null ? 0 : this.requestPool.size();
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    class SocketListener
    implements Runnable {
        SocketListener() {
        }

        @Override
        public void run() {
            String moduleLog = LongServerInAdapter.this.getSid().replaceAll("[.]", "/");
            LogbackUtil.putLogInfo(LongServerInAdapter.this.bundlerId, LongServerInAdapter.this.moduleId, moduleLog, "", "        ", null);
            LongServerInAdapter.this.logger.info("{} @ Start listening service:{}", new Object[]{LongServerInAdapter.this.getAdapterTypeName(), LongServerInAdapter.this.server});
            while (LongServerInAdapter.this.alive) {
                try {
                    String ip;
                    Socket socket = LongServerInAdapter.this.acceptSocket();
                    SocketWrapper wrapper = new SocketWrapper(socket);
                    if (!LongServerInAdapter.this.checkSocketWrapper(wrapper)) {
                        socket.close();
                        continue;
                    }
                    if (LongServerInAdapter.this.ipList != null && !IpFilter.checkIP(ip = socket.getInetAddress().getHostAddress(), LongServerInAdapter.this.ipList)) {
                        LongServerInAdapter.this.logger.debug("{} @  The requester IP [{}] is not allowed to receive the request.", new Object[]{LongServerInAdapter.this.getAdapterTypeName(), ip});
                        socket.close();
                        continue;
                    }
                    LongServerInAdapter.this.currentConnection.incrementAndGet();
                    LongServerInAdapter.this.requestPool.add(wrapper);
                    LongServerInAdapter.this.semaphore.release();
                }
                catch (NullPointerException e) {
                    LongServerInAdapter.this.logger.error("{} @ Null pointer exception", (Object)LongServerInAdapter.this.getAdapterTypeName(), (Object)e);
                    break;
                }
                catch (Throwable e) {
                    if (!LongServerInAdapter.this.isAlive()) continue;
                    LongServerInAdapter.this.logger.error("{} @ Listening service exception ", (Object)LongServerInAdapter.this.getAdapterTypeName(), (Object)e);
                }
            }
            LongServerInAdapter.this.logger.info("{} @ Monitoring service is off", new Object[]{LongServerInAdapter.this.getAdapterTypeName()});
            LogbackUtil.removeLogInfo();
        }
    }
}

