/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.bsp.app.config;

import cn.com.yusys.yusp.bsp.app.config.AppStartAssist;
import cn.com.yusys.yusp.bsp.app.config.BspBoot;
import cn.com.yusys.yusp.bsp.config.ModuleConfig;
import cn.com.yusys.yusp.bsp.config.impl.DefaultModuleConfig;
import cn.com.yusys.yusp.bsp.core.AsynManager;
import cn.com.yusys.yusp.bsp.resources.spring.CustomPropertyEditorRegistrar;
import java.util.Map;
import org.springframework.beans.PropertyEditorRegistrar;
import org.springframework.beans.factory.config.CustomEditorConfigurer;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.web.client.RestTemplate;

@ConditionalOnClass(value={BspBoot.class})
@ConditionalOnProperty(name={"common.bsp.enable"}, matchIfMissing=true)
@ComponentScan(value={"cn.com.yusys.yusp.bsp"})
public class BspAutoConfiguration {
    private static RestTemplate restTemplate;
    private static StringRedisTemplate stringRedisTemplate;
    private static CustomEditorConfigurer customEditorConfigurer;

    @Bean
    public AppStartAssist appStartAssist(ModuleConfig moduleConfig) {
        return new AppStartAssist(moduleConfig);
    }

    @Bean
    public BspBoot registryBspBoot(ApplicationContext applicationContext, AppStartAssist appStartAssist) {
        return new BspBoot(applicationContext, appStartAssist);
    }

    @Bean(value={"bspAsynManager"})
    public AsynManager asynManager() {
        return new AsynManager();
    }

    @Bean(value={"restTemplate"})
    public RestTemplate restTemplate() {
        restTemplate = new RestTemplate();
        return restTemplate;
    }

    @Bean(value={"defaultModuleConfig"})
    public DefaultModuleConfig defaultModuleConfig() {
        return new DefaultModuleConfig();
    }

    @Bean
    public ModuleConfig moduleConfig(ApplicationContext applicationContext) throws Exception {
        ModuleConfig moduleConfig = null;
        Map beansOfType = applicationContext.getBeansOfType(ModuleConfig.class);
        if (beansOfType.size() > 2) {
            StringBuilder builder = new StringBuilder("In cn.com.yusys.yusp.bsp.app.config.AppStartAssist required a single bean, but ");
            builder.append(beansOfType.size());
            builder.append(" were found:");
            for (String beanName : beansOfType.keySet()) {
                builder.append('\n');
                ModuleConfig config = (ModuleConfig)beansOfType.get(beanName);
                builder.append("\t- ").append(beanName).append(": ").append(config.getClass().toString());
            }
            throw new Exception(builder.toString());
        }
        if (beansOfType.size() == 1) {
            moduleConfig = (ModuleConfig)beansOfType.get("defaultModuleConfig");
        } else if (beansOfType.size() == 2) {
            for (String beanName : beansOfType.keySet()) {
                if ("defaultModuleConfig".equals(beanName)) continue;
                moduleConfig = (ModuleConfig)beansOfType.get(beanName);
            }
        } else {
            throw new Exception("In cn.com.yusys.yusp.bsp.app.config.AppStartAssist required a single bean, but 0 were found");
        }
        return moduleConfig;
    }

    public static RestTemplate getRestTemplateInstance() {
        return restTemplate;
    }

    @Bean(value={"stringRedisTemplate"})
    public StringRedisTemplate stringRedisTemplate(RedisConnectionFactory factory) {
        stringRedisTemplate = new StringRedisTemplate();
        stringRedisTemplate.setConnectionFactory(factory);
        return stringRedisTemplate;
    }

    public static StringRedisTemplate getStringRedisTemplate() {
        return stringRedisTemplate;
    }

    @Bean(value={"customEditorConfigurer"})
    public CustomEditorConfigurer customEditorConfigurer() {
        customEditorConfigurer = new CustomEditorConfigurer();
        customEditorConfigurer.setPropertyEditorRegistrars(new PropertyEditorRegistrar[]{new CustomPropertyEditorRegistrar()});
        return customEditorConfigurer;
    }

    public static CustomEditorConfigurer getCustomEditorConfigurer() {
        return customEditorConfigurer;
    }
}

