/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.bsp.app.config;

import cn.com.yusys.yusp.bsp.app.config.BspBoot;
import cn.com.yusys.yusp.bsp.app.config.ServiceEntityManager;
import cn.com.yusys.yusp.bsp.config.ModuleConfig;
import cn.com.yusys.yusp.bsp.resources.ServiceEntity;
import cn.com.yusys.yusp.bsp.workflow.BspController;
import cn.com.yusys.yusp.bsp.workflow.TradeMapping;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AppStartAssist {
    private static final Logger logger = LoggerFactory.getLogger(AppStartAssist.class);
    private static final Set<String> MODULE_CACHE = new CopyOnWriteArraySet<String>();
    private final ModuleConfig config;

    public AppStartAssist(ModuleConfig config) {
        this.config = config;
    }

    void startModule() throws Exception {
        try {
            String[] array;
            for (String s : array = BspBoot.applicationContext.getBeanNamesForAnnotation(BspController.class)) {
                Method[] methods;
                Object obean = BspBoot.applicationContext.getBean(s);
                BspController controller = obean.getClass().getAnnotation(BspController.class);
                String moduleName = controller.moduleName();
                if ("".equals(moduleName)) {
                    moduleName = controller.value();
                }
                for (Method method : methods = obean.getClass().getDeclaredMethods()) {
                    TradeMapping tradeMapping = method.getAnnotation(TradeMapping.class);
                    if (tradeMapping == null) continue;
                    String value = tradeMapping.value();
                    String code = tradeMapping.code();
                    if (code.isEmpty()) {
                        code = value;
                    }
                    Class<?> paraClazz = method.getParameterTypes()[0];
                    Class<?> retType = method.getReturnType();
                    ServiceEntity entity = new ServiceEntity();
                    entity.setCode(code);
                    entity.setValue(value);
                    entity.setParaType(paraClazz);
                    entity.setRetType(retType);
                    Type[] genericParameterTypes = method.getGenericParameterTypes();
                    if (genericParameterTypes.length > 0) {
                        entity.setParameterType(genericParameterTypes[0]);
                    }
                    entity.setReturnType(method.getGenericReturnType());
                    entity.setMethod(method);
                    entity.setBean(obean);
                    ServiceEntityManager.putServiceEntity(moduleName, value, entity);
                }
            }
            this.config.loadModuleConfig();
        }
        catch (Exception e) {
            logger.error("Failed to load communication configuration :", (Throwable)e);
            throw e;
        }
    }

    public static List<String> getStartModules() {
        return new ArrayList<String>(MODULE_CACHE);
    }

    public static void addModule(String moduleName) {
        MODULE_CACHE.add(moduleName);
    }

    public static void removeModule(String moduleName) {
        MODULE_CACHE.remove(moduleName);
    }
}

