/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.bsp.toolkit.common;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;

public class IpFilter {
    public static Pattern pattern = Pattern.compile("(1\\d{1,2}|2[0-4]\\d|25[0-5]|\\d{1,2})\\.(1\\d{1,2}|2[0-4]\\d|25[0-5]|\\d{1,2})\\.(1\\d{1,2}|2[0-4]\\d|25[0-5]|\\d{1,2})\\.(1\\d{1,2}|2[0-4]\\d|25[0-5]|\\d{1,2})");

    public static Set<String> init(String allowIp) {
        HashSet<String> ipList = new HashSet<String>();
        for (String allow : allowIp.split(",")) {
            if (allow.contains("*")) {
                String[] ips = allow.split("\\.");
                String[] from = new String[]{"0", "0", "0", "0"};
                String[] end = new String[]{"255", "255", "255", "255"};
                List<Object> tem = new ArrayList();
                for (int i = 0; i < ips.length; ++i) {
                    if (ips[i].contains("*")) {
                        tem = IpFilter.complete(ips[i]);
                        from[i] = null;
                        end[i] = null;
                        continue;
                    }
                    from[i] = ips[i];
                    end[i] = ips[i];
                }
                StringBuilder fromIP = new StringBuilder();
                StringBuilder endIP = new StringBuilder();
                for (int i = 0; i < 4; ++i) {
                    if (from[i] != null) {
                        fromIP.append(from[i]).append(".");
                        endIP.append(end[i]).append(".");
                        continue;
                    }
                    fromIP.append("[*].");
                    endIP.append("[*].");
                }
                fromIP.deleteCharAt(fromIP.length() - 1);
                endIP.deleteCharAt(endIP.length() - 1);
                for (String string : tem) {
                    String ip = fromIP.toString().replace("[*]", string.split(";")[0]) + "-" + endIP.toString().replace("[*]", string.split(";")[1]);
                    if (!IpFilter.validate(ip)) continue;
                    ipList.add(ip);
                }
                continue;
            }
            if (!IpFilter.validate(allow)) continue;
            ipList.add(allow);
        }
        return ipList;
    }

    public static List<String> complete(String arg) {
        ArrayList<String> com = new ArrayList<String>();
        if (arg.length() == 1) {
            com.add("0;255");
        } else if (arg.length() == 2) {
            String s2;
            String s1 = IpFilter.complete(arg, 1);
            if (s1 != null) {
                com.add(s1);
            }
            if ((s2 = IpFilter.complete(arg, 2)) != null) {
                com.add(s2);
            }
        } else {
            String s1 = IpFilter.complete(arg, 1);
            if (s1 != null) {
                com.add(s1);
            }
        }
        return com;
    }

    public static String complete(String arg, int length) {
        String end;
        String from;
        if (length == 1) {
            from = arg.replace("*", "0");
            end = arg.replace("*", "9");
        } else {
            from = arg.replace("*", "00");
            end = arg.replace("*", "99");
        }
        if (Integer.parseInt(from) > 255) {
            return null;
        }
        if (Integer.parseInt(end) > 255) {
            end = "255";
        }
        return from + ";" + end;
    }

    public static boolean validate(String ip) {
        for (String s : ip.split("-")) {
            if (pattern.matcher(s).matches()) continue;
            return false;
        }
        return true;
    }

    public static boolean checkIP(String ip, Set<String> ipList) {
        if (ipList.isEmpty() || ipList.contains(ip)) {
            return true;
        }
        for (String allow : ipList) {
            if (!allow.contains("-")) continue;
            String[] from = allow.split("-")[0].split("\\.");
            String[] end = allow.split("-")[1].split("\\.");
            String[] tag = ip.split("\\.");
            boolean check = true;
            for (int i = 0; i < 4; ++i) {
                int s = Integer.parseInt(from[i]);
                int t = Integer.parseInt(tag[i]);
                int e = Integer.parseInt(end[i]);
                if (s <= t && t <= e) continue;
                check = false;
                break;
            }
            if (!check) continue;
            return true;
        }
        return false;
    }
}

