/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.bsp.core;

import cn.com.yusys.yusp.bsp.component.exception.ComponentException;
import cn.com.yusys.yusp.bsp.core.IResponseCallback;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;

public class AsynManager
implements InitializingBean,
DisposableBean {
    private static final String DEFAULT_GROUP = "default";
    private static final Logger logger = LoggerFactory.getLogger(AsynManager.class);
    private int sessionTimeout = 60000;
    @Value(value="${bsp.asynMode:false}")
    private boolean asynMode;
    private boolean alive = true;
    private final Map<String, IResponseCallback<Map<String, Object>>> asynCallbacks = new ConcurrentHashMap<String, IResponseCallback<Map<String, Object>>>();
    private DelayQueue<DelayedTask> queue;
    private static AsynManager asynManager;

    public AsynManager() {
        asynManager = this;
    }

    public static AsynManager getInstance() {
        return asynManager;
    }

    public void addCallback(String asyncKey, IResponseCallback<Map<String, Object>> callback, int timeout) throws ComponentException {
        this.addCallback(asyncKey, callback, DEFAULT_GROUP, timeout);
    }

    public void addCallback(String asyncKey, IResponseCallback<Map<String, Object>> callback, String groupName, int timeout) throws ComponentException {
        String key = groupName + "@" + asyncKey;
        IResponseCallback<Map<String, Object>> oldCallback = this.asynCallbacks.putIfAbsent(key, callback);
        if (oldCallback != null) {
            throw new ComponentException("asyncKey:" + asyncKey + " exist");
        }
        if (timeout <= 0) {
            timeout = this.sessionTimeout;
        }
        if (this.queue == null) {
            throw new ComponentException("asynMode must set true");
        }
        this.queue.add(new DelayedTask(timeout, key));
    }

    public IResponseCallback<Map<String, Object>> removeCallback(String asyncKey, String groupName) {
        return this.asynCallbacks.remove(groupName + "@" + asyncKey);
    }

    public IResponseCallback<Map<String, Object>> removeCallback(String asyncKey) {
        return this.removeCallback(asyncKey, DEFAULT_GROUP);
    }

    public int getSessionTimeout() {
        return this.sessionTimeout;
    }

    public void setSessionTimeout(int sessionTimeout) {
        this.sessionTimeout = sessionTimeout;
    }

    public boolean isAlive() {
        return this.alive;
    }

    public void setAlive(boolean alive) {
        this.alive = alive;
    }

    public void afterPropertiesSet() {
        this.alive = true;
        if (this.asynMode) {
            this.queue = new DelayQueue();
            this.startAsynManagerThread();
        }
    }

    public void destroy() {
        this.alive = false;
    }

    public void startAsynManagerThread() {
        Thread thread = new Thread((Runnable)new AsynManagerThread(), "AsynManagerThread");
        thread.setDaemon(true);
        thread.start();
    }

    private static class DelayedTask
    implements Delayed {
        private final long delay;
        private final long expire;
        private final String msg;

        public DelayedTask(long delay, String msg) {
            this.delay = delay;
            this.msg = msg;
            this.expire = System.currentTimeMillis() + delay;
        }

        @Override
        public int compareTo(Delayed o) {
            return (int)(this.getDelay(TimeUnit.MILLISECONDS) - o.getDelay(TimeUnit.MILLISECONDS));
        }

        @Override
        public long getDelay(TimeUnit unit) {
            return unit.convert(this.expire - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
        }

        public String toString() {
            return "DelayedTask [delay=" + this.delay + ", expire=" + this.expire + ", msg=" + this.msg + "]";
        }

        public String getMsg() {
            return this.msg;
        }
    }

    private class AsynManagerThread
    implements Runnable {
        private AsynManagerThread() {
        }

        @Override
        public void run() {
            while (AsynManager.this.alive) {
                try {
                    IResponseCallback callback;
                    DelayedTask task = (DelayedTask)AsynManager.this.queue.poll(5L, TimeUnit.MICROSECONDS);
                    if (task == null || (callback = (IResponseCallback)AsynManager.this.asynCallbacks.remove(task.getMsg())) == null) continue;
                    logger.error("timeout:{}", (Object)task.getMsg());
                    callback.timeout();
                }
                catch (Exception e) {
                    logger.error("asyn manager thread quit", (Throwable)e);
                }
            }
        }
    }
}

