/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.bsp.config.command.impl;

import cn.com.yusys.yusp.bsp.app.config.AppStartAssist;
import cn.com.yusys.yusp.bsp.app.config.ModulePath;
import cn.com.yusys.yusp.bsp.config.command.CommandInfo;
import cn.com.yusys.yusp.bsp.config.command.ICommand;
import cn.com.yusys.yusp.bsp.resources.BspAppContext;
import cn.com.yusys.yusp.bsp.resources.ResourcePortal;
import cn.com.yusys.yusp.bsp.resources.bean.SpringContextRegistry;
import cn.com.yusys.yusp.bsp.toolkit.common.StringTools;
import cn.com.yusys.yusp.bsp.workflow.IComm;
import java.io.File;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.stereotype.Component;

@Component(value="module")
public class ModuleCommand
implements ICommand {
    private static final Logger logger = LoggerFactory.getLogger(ModuleCommand.class);
    private static final SpringContextRegistry _contextRegistry = ResourcePortal.getInstance().getSpringContextRegistry();
    @Value(value="${spring.application.name}")
    private String msname;

    @Override
    public CommandInfo execute(CommandInfo commandInfo) throws Exception {
        CommandInfo ret = new CommandInfo(commandInfo.getContext());
        String requestId = ret.getContext().get("_hostname");
        requestId = "client[" + requestId + "] ";
        String name = ret.getContext().get("name");
        if (StringTools.isEmpty(name)) {
            logger.error(requestId + "Module name is null");
            ret.getContext().put("success", "false");
            ret.getContext().put("message", "Module name is null");
            return ret;
        }
        String action = ret.getContext().get("action");
        if (StringTools.isEmpty(action)) {
            logger.error(requestId + "Module command is null");
            ret.getContext().put("success", "false");
            ret.getContext().put("message", "Module command is null");
            return ret;
        }
        switch (action) {
            case "list": {
                String status = this.getModuleStatus(name);
                ret.getContext().put("success", status);
                ret.getContext().put("message", "Query successfull");
                break;
            }
            case "listall": {
                String status = this.listAllModuleStatus();
                ret.getContext().put("success", "true");
                ret.getContext().put("message", status);
                break;
            }
            case "start": {
                this.startModule(name);
                ret.getContext().put("success", "true");
                ret.getContext().put("message", "Start successfull");
                break;
            }
            case "restart": {
                this.restartModule(name);
                ret.getContext().put("success", "true");
                ret.getContext().put("message", "Restart successfull");
                break;
            }
            case "stop": {
                this.stopModule(name);
                ret.getContext().put("success", "true");
                ret.getContext().put("message", "Stop successfull");
                break;
            }
            default: {
                logger.error(requestId + " module command is not right :" + action);
                ret.getContext().put("success", "false");
                ret.getContext().put("message", "Module command is not right :" + action);
                return ret;
            }
        }
        return ret;
    }

    public String getModuleStatus(String name) {
        BspAppContext context = _contextRegistry.getAppContext(name);
        return context == null ? "false" : "true";
    }

    public String listAllModuleStatus() {
        List<String> list = AppStartAssist.getStartModules();
        StringBuilder sb = new StringBuilder("{");
        for (int i = 0; i < list.size(); ++i) {
            BspAppContext context = _contextRegistry.getAppContext(list.get(i));
            if (i > 0) {
                sb.append(',');
            }
            sb.append("\"").append(list.get(i)).append("\":\"").append(context == null ? "false" : "true");
            sb.append("\"");
        }
        return sb.append("}").toString();
    }

    public void startModule(String name) throws Exception {
        BspAppContext context = _contextRegistry.getAppContext(name);
        String modulePath = ModulePath.getModulePath(name, true);
        if (context != null) {
            throw new Exception("Module [" + name + "] in microservice [" + this.msname + "] is started! The configuration at:" + modulePath);
        }
        if (ModulePath.isFileModel()) {
            File rootFile = new File(modulePath);
            if (!rootFile.isFile()) {
                AppStartAssist.removeModule(name);
                throw new Exception("Module [" + name + "] does not exist");
            }
            modulePath = rootFile.toURI().toString();
        } else {
            PathMatchingResourcePatternResolver pmrpr = new PathMatchingResourcePatternResolver();
            Resource[] reses = pmrpr.getResources(modulePath);
            if (reses.length == 0 || reses[0] == null || !reses[0].exists()) {
                AppStartAssist.removeModule(name);
                throw new Exception("Module [" + name + "] does not exist");
            }
            modulePath = reses[0].getURL().toString();
        }
        logger.info("Load communication configuration[{}]", (Object)modulePath);
        String threadName = Thread.currentThread().getName();
        AppStartAssist.loadModule(modulePath);
        Thread.currentThread().setName(threadName);
        logger.info("Start module[{}]", (Object)name);
    }

    public void stopModule(String name) throws Exception {
        BspAppContext context = _contextRegistry.getContextMap().remove(name);
        if (context == null) {
            throw new Exception("Module [" + name + "] in microservice [" + this.msname + "] is stopped!");
        }
        context.close();
        Map<String, IComm> outCommMap = ResourcePortal.getInstance().getOutCommMap();
        outCommMap.remove(name);
        logger.info("Stop module[{}]", (Object)name);
    }

    public void restartModule(String name) throws Exception {
        this.stopModule(name);
        this.startModule(name);
    }
}

