/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.bsp.communication;

import cn.com.yusys.yusp.bsp.communication.AbstractRequest;
import cn.com.yusys.yusp.bsp.communication.SocketWrapper;
import java.net.Socket;
import java.util.Map;

public class StreamRequest
extends AbstractRequest {
    private String key;
    private long lastUsedTime;
    private SocketWrapper socketWrapper;

    public SocketWrapper getSocketWrapper() {
        if (this.socketWrapper == null) {
            this.socketWrapper = (SocketWrapper)this.datasourceWrapper;
        }
        return this.socketWrapper;
    }

    @Override
    public int getRequestType() {
        return 1;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public long getLastUsedTime() {
        return this.lastUsedTime;
    }

    public void setLastUsedTime(long lastUsedTime) {
        this.lastUsedTime = lastUsedTime;
    }

    @Override
    public void close() throws Exception {
        if (this.datasourceWrapper instanceof SocketWrapper) {
            SocketWrapper socketWrapper = (SocketWrapper)this.datasourceWrapper;
            socketWrapper.close();
        } else if (this.datasourceWrapper instanceof Socket) {
            Socket socket = (Socket)this.datasourceWrapper;
            if (!socket.isClosed()) {
                socket.close();
            }
        } else {
            throw new Exception("StreamRequest type is not supported " + this.datasourceWrapper);
        }
    }

    @Override
    public void initContext(Map<String, Object> context) {
        Object o = this.getDatasourceWrapper();
        if (o instanceof SocketWrapper) {
            context.put("G_CLIENT_IP", ((SocketWrapper)o).getSocket().getInetAddress().getHostAddress());
            context.put("G_CLIENT_PORT", ((SocketWrapper)o).getSocket().getPort());
        } else if (o instanceof Socket) {
            context.put("G_CLIENT_IP", ((Socket)o).getInetAddress().getHostAddress());
            context.put("G_CLIENT_PORT", ((Socket)o).getPort());
        }
    }
}

