/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.bsp.communication;

import cn.com.yusys.yusp.bsp.component.IWorkflowFactory;
import cn.com.yusys.yusp.bsp.component.exception.ComponentException;
import cn.com.yusys.yusp.bsp.core.AsynManager;
import cn.com.yusys.yusp.bsp.core.IResponseCallback;
import cn.com.yusys.yusp.bsp.resources.BspAppContext;
import cn.com.yusys.yusp.bsp.resources.BspContextHolder;
import cn.com.yusys.yusp.bsp.resources.BspDataContext;
import cn.com.yusys.yusp.bsp.resources.ResourcePortal;
import cn.com.yusys.yusp.bsp.resources.Session;
import cn.com.yusys.yusp.bsp.resources.log.BspSpan;
import cn.com.yusys.yusp.bsp.toolkit.common.StringTools;
import cn.com.yusys.yusp.bsp.toolkit.el.ognl.OgnlTools;
import cn.com.yusys.yusp.bsp.workflow.component.ServiceNonExistException;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BspTemplate {
    private static final String WORKFLOW_OUTPUT_FACTORY = "workflowOutputFactory";
    private static final Logger logger = LoggerFactory.getLogger(BspTemplate.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Object> exchange(String serviceName, String tradeCode, Map<String, Object> context, IResponseCallback<Map<String, Object>> responseCallback) throws Exception {
        block18: {
            Session session = (Session)context.get("T_SESSION");
            if (!serviceName.startsWith("commOut.")) {
                serviceName = "commOut." + serviceName;
            }
            boolean close = false;
            if (session == null) {
                session = BspTemplate.getSession(context);
                session.setModuleName(serviceName);
                BspContextHolder.getInstance().putBspDataContext(new BspDataContext(context));
                session.setResponseCallback(responseCallback);
                close = true;
            } else if (responseCallback == null) {
                responseCallback = session.getResponseCallback();
            }
            try {
                if (StringTools.isEmpty(tradeCode)) {
                    context.put("G_TRANSCODE", "default");
                } else {
                    context.put("G_TRANSCODE", tradeCode);
                }
                BspAppContext bspAppContext = ResourcePortal.getInstance().getSpringContextRegistry().getAppContext(serviceName);
                if (bspAppContext == null) {
                    throw new ServiceNonExistException(serviceName);
                }
                IWorkflowFactory workflowOutputFactory = (IWorkflowFactory)bspAppContext.getBean(WORKFLOW_OUTPUT_FACTORY);
                if (workflowOutputFactory == null) {
                    throw new ComponentException("workflowOutputFactory not found");
                }
                if (!workflowOutputFactory.isAsyn()) {
                    workflowOutputFactory.buildFlow().execute(context);
                    break block18;
                }
                String _matchV = null;
                String _groupName = null;
                try {
                    _matchV = StringTools.getString(OgnlTools.getValue(workflowOutputFactory.getAsyncKey(), context));
                    if (_matchV == null) {
                        throw new ComponentException("asyncKey is empty");
                    }
                    _groupName = StringTools.getString(OgnlTools.getValue(workflowOutputFactory.getGroupName(), context));
                    logger.info("ModuleInvoke @ asyncKey:{},group:{}", (Object)_matchV, (Object)_groupName);
                    int _timeout = StringTools.getInt(OgnlTools.getValue(workflowOutputFactory.getTimeout(), context));
                    AsynManager.getInstance().addCallback(_matchV, responseCallback, _groupName, _timeout);
                    workflowOutputFactory.buildFlow().execute(context);
                    session.setAsyn(true);
                }
                catch (Exception e) {
                    if (_matchV != null) {
                        AsynManager.getInstance().removeCallback(_matchV, _groupName);
                    }
                    throw e;
                }
            }
            finally {
                if (close) {
                    if (responseCallback != null && !session.isAsyn()) {
                        responseCallback.response(context);
                    }
                    session.destory();
                }
            }
        }
        return context;
    }

    public static Map<String, Object> exchange(String serviceName, Map<String, Object> context, IResponseCallback<Map<String, Object>> responseCallback) throws Exception {
        return BspTemplate.exchange(serviceName, "default", context, responseCallback);
    }

    public static Map<String, Object> exchange(String serviceName, String tradeCode, Map<String, Object> context) throws Exception {
        IResponseCallback<Map<String, Object>> callback = null;
        return BspTemplate.exchange(serviceName, tradeCode, context, callback);
    }

    public static Map<String, Object> exchange(String serviceName, Map<String, Object> context) throws Exception {
        return BspTemplate.exchange(serviceName, "default", context);
    }

    private static Session getSession(Map<String, Object> context) {
        Session session = (Session)context.get("T_SESSION");
        if (session == null) {
            session = new Session();
            BspSpan span = new BspSpan();
            session.setSpan(span);
            String sn = span.getStringTraceId();
            session.setContext(context);
            session.setSessionId(sn);
            session.getContext().put("G_SN", sn);
            session.getContext().put("T_SESSION", session);
        }
        return session;
    }
}

