/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.bsp.app.config;

import cn.com.yusys.yusp.bsp.resources.ServiceEntity;
import cn.com.yusys.yusp.bsp.toolkit.common.StringTools;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ServiceEntityManager {
    private static final String COMM_IN_DEF_SERVICE = "defService";
    private static final Map<String, Map<String, ServiceEntity>> serviceEntityMap = new ConcurrentHashMap<String, Map<String, ServiceEntity>>();

    public static void putServiceEntity(String moduleName, String value, ServiceEntity entity) throws Exception {
        ServiceEntity se;
        Map<String, ServiceEntity> existEntity;
        Map<String, ServiceEntity> moduleEntity;
        if (StringTools.isEmpty(moduleName)) {
            moduleName = COMM_IN_DEF_SERVICE;
        }
        if ((moduleEntity = serviceEntityMap.get(moduleName)) == null && (existEntity = serviceEntityMap.putIfAbsent(moduleName, moduleEntity = new ConcurrentHashMap<String, ServiceEntity>())) != null) {
            moduleEntity = existEntity;
        }
        if ((se = moduleEntity.putIfAbsent(value, entity)) != null) {
            throw new Exception("[" + entity.getBean() + "]transaction definition is the same as[" + se.getBean() + "]");
        }
    }

    public static ServiceEntity getServiceEntity(String moduleName, String value) throws Exception {
        Map<String, ServiceEntity> moduleEntity = serviceEntityMap.get(moduleName);
        if (moduleEntity == null && (moduleEntity = serviceEntityMap.get(COMM_IN_DEF_SERVICE)) == null) {
            throw new Exception(moduleName + " service not exist");
        }
        ServiceEntity entity = moduleEntity.get(value);
        if (entity == null && (entity = moduleEntity.get("default")) == null) {
            throw new Exception("[" + moduleName + "] corresponding to transaction [" + value + "] does not exist");
        }
        return entity;
    }
}

