/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.bsp.app.config;

import cn.com.yusys.yusp.bsp.app.config.BspBoot;
import cn.com.yusys.yusp.bsp.core.AsynManager;
import cn.com.yusys.yusp.bsp.resources.spring.CustomPropertyEditorRegistrar;
import org.springframework.beans.PropertyEditorRegistrar;
import org.springframework.beans.factory.config.CustomEditorConfigurer;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.web.client.RestTemplate;

@ConditionalOnClass(value={BspBoot.class})
@ConditionalOnProperty(name={"common.bsp.enable"}, matchIfMissing=true)
@ComponentScan(value={"cn.com.yusys.yusp.bsp"})
public class BspAutoConfiguration {
    private static RestTemplate restTemplate;
    private static StringRedisTemplate stringRedisTemplate;
    private static CustomEditorConfigurer customEditorConfigurer;

    @Bean
    public BspBoot registryBspBoot(ApplicationContext applicationContext) {
        return new BspBoot(applicationContext);
    }

    @Bean(value={"bspAsynManager"})
    public AsynManager asynManager() {
        return new AsynManager();
    }

    @Bean(value={"restTemplate"})
    public RestTemplate restTemplate() {
        restTemplate = new RestTemplate();
        return restTemplate;
    }

    public static RestTemplate getRestTemplateInstance() {
        return restTemplate;
    }

    @Bean(value={"stringRedisTemplate"})
    public StringRedisTemplate stringRedisTemplate(RedisConnectionFactory factory) {
        stringRedisTemplate = new StringRedisTemplate();
        stringRedisTemplate.setConnectionFactory(factory);
        return stringRedisTemplate;
    }

    public static StringRedisTemplate getStringRedisTemplate() {
        return stringRedisTemplate;
    }

    @Bean(value={"customEditorConfigurer"})
    public CustomEditorConfigurer customEditorConfigurer() {
        customEditorConfigurer = new CustomEditorConfigurer();
        customEditorConfigurer.setPropertyEditorRegistrars(new PropertyEditorRegistrar[]{new CustomPropertyEditorRegistrar()});
        return customEditorConfigurer;
    }

    public static CustomEditorConfigurer getCustomEditorConfigurer() {
        return customEditorConfigurer;
    }
}

