/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.bsp.component.impl.comm;

import cn.com.yusys.yusp.bsp.component.impl.comm.AdapterHost;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractCommRouteConfig {
    private AdapterHost[] allAdapters;
    private AdapterHost[] validAdapters;
    private AdapterHost[] unValidAdapters;
    public static final int ITEM_POLICY_RANDOM = 0;
    public static final int ITEM_POLICY_SEQUENCE = 1;
    private final AtomicInteger currentHost = new AtomicInteger(0);
    private long nextCheckTime = Long.MAX_VALUE;
    private static final Long SUSPENGTIME = 600000L;
    private int policy;
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Object lockObj = new Object();

    public AbstractCommRouteConfig(String[] outAdapterNameArr, int policy) {
        this.policy = policy;
        ArrayList<AdapterHost> adapterHosts = new ArrayList<AdapterHost>();
        for (String adapter : outAdapterNameArr) {
            AdapterHost adapterHost = new AdapterHost();
            adapterHost.setAdapterName(adapter);
            adapterHost.setRouteConfig(this);
            adapterHosts.add(adapterHost);
        }
        this.allAdapters = adapterHosts.toArray(new AdapterHost[0]);
        this.validAdapters = this.allAdapters;
        this.unValidAdapters = new AdapterHost[0];
    }

    public AdapterHost[] getAllAdapters() {
        return this.allAdapters;
    }

    public void setAllAdapters(AdapterHost[] allAdapter) {
        this.allAdapters = allAdapter;
    }

    public AdapterHost[] getValidAdapters() {
        return this.validAdapters;
    }

    public void setValidAdapters(AdapterHost[] validAdapter) {
        this.validAdapters = validAdapter;
    }

    public AdapterHost[] getUnValidAdapters() {
        return this.unValidAdapters;
    }

    public void setUnValidAdapters(AdapterHost[] unValidAdapter) {
        this.unValidAdapters = unValidAdapter;
    }

    public long getNextCheckTime() {
        return this.nextCheckTime;
    }

    public void setNextCheckTime(long nextCheckTime) {
        this.nextCheckTime = nextCheckTime;
    }

    public int getPolicy() {
        return this.policy;
    }

    public void setPolicy(int policy) {
        this.policy = policy;
    }

    public AdapterHost getAdapterHostByAdapterName(String adapter) throws Exception {
        if (this.allAdapters != null) {
            for (AdapterHost ad : this.allAdapters) {
                if (!ad.getAdapterName().equals(adapter)) continue;
                return ad;
            }
        }
        throw new Exception("Adapter does not exist\uff1a" + adapter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerFaultRoute(String adapterName) throws Exception {
        AdapterHost host = this.getAdapterHostByAdapterName(adapterName);
        AbstractCommRouteConfig routeConfig = host.getRouteConfig();
        Object object = this.lockObj;
        synchronized (object) {
            if (!host.isStatus()) {
                return;
            }
            if (this.getAllAdapters().length == this.getUnValidAdapters().length + 1) {
                AdapterHost[] unValidHost;
                for (AdapterHost adapterHost : unValidHost = this.getUnValidAdapters()) {
                    adapterHost.setStatus(true);
                }
                this.refreshAdapterHost(routeConfig);
                routeConfig.setNextCheckTime(Long.MAX_VALUE);
                throw new Exception("All adapters are malfunctioning");
            }
            host.setStatus(false);
            host.setNextCheckTime(System.currentTimeMillis() + SUSPENGTIME);
            this.refreshAdapterHost(routeConfig);
            if (routeConfig.getNextCheckTime() == Long.MAX_VALUE) {
                routeConfig.setNextCheckTime(host.getNextCheckTime());
            }
        }
    }

    private void refreshAdapterHost(AbstractCommRouteConfig routeConfig) {
        AdapterHost[] adapterHosts = routeConfig.getAllAdapters();
        ArrayList<AdapterHost> validAdapterHostList = new ArrayList<AdapterHost>();
        ArrayList<AdapterHost> inValidAdapterHostList = new ArrayList<AdapterHost>();
        for (AdapterHost adapterHost : adapterHosts) {
            if (!adapterHost.isStatus()) {
                inValidAdapterHostList.add(adapterHost);
                continue;
            }
            validAdapterHostList.add(adapterHost);
        }
        routeConfig.setValidAdapters(validAdapterHostList.toArray(new AdapterHost[0]));
        routeConfig.setUnValidAdapters(inValidAdapterHostList.toArray(new AdapterHost[0]));
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Adapter routing, all adapter information after refresh is\uff1a{}", new Object[]{routeConfig.getAllAdapters()});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String selectAdapter() throws Exception {
        AdapterHost[] validHost;
        int len;
        long ct = System.currentTimeMillis();
        if (ct >= this.getNextCheckTime()) {
            AbstractCommRouteConfig abstractCommRouteConfig = this;
            synchronized (abstractCommRouteConfig) {
                if (ct >= this.getNextCheckTime()) {
                    this.restoreFaultHost(this);
                }
            }
        }
        if ((len = (validHost = this.getValidAdapters()).length) == 1) {
            return validHost[0].getAdapterName();
        }
        if (len > 1) {
            if (this.policy == 1) {
                return validHost[0].getAdapterName();
            }
            int current = this.currentHost.getAndIncrement() % validHost.length;
            return validHost[current].getAdapterName();
        }
        throw new Exception("A valid adapter does not exist");
    }

    private void restoreFaultHost(AbstractCommRouteConfig routeConfig) {
        AdapterHost[] unValidHost = routeConfig.getUnValidAdapters();
        long nextCheckTime = Long.MAX_VALUE;
        for (AdapterHost adapterHost : unValidHost) {
            if (adapterHost.getNextCheckTime() <= routeConfig.getNextCheckTime()) {
                adapterHost.setStatus(true);
                continue;
            }
            if (nextCheckTime != Long.MAX_VALUE && nextCheckTime <= adapterHost.getNextCheckTime()) continue;
            nextCheckTime = adapterHost.getNextCheckTime();
        }
        routeConfig.setNextCheckTime(nextCheckTime);
        this.refreshAdapterHost(routeConfig);
    }
}

