/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.bsp.dataformat.impl;

import cn.com.yusys.yusp.bsp.dataformat.exe.AbstractExecutor;
import cn.com.yusys.yusp.bsp.resources.mfd.CacheHead;
import cn.com.yusys.yusp.bsp.schema.dataformat.def.Group;
import cn.com.yusys.yusp.bsp.schema.dataformat.def.Head;
import cn.com.yusys.yusp.bsp.schema.dataformat.def.Item;
import cn.com.yusys.yusp.bsp.schema.dataformat.def.While;
import cn.com.yusys.yusp.bsp.toolkit.common.StringTools;
import cn.com.yusys.yusp.bsp.toolkit.el.ognl.OgnlTools;
import cn.com.yusys.yusp.bsp.toolkit.xml.Attribute;
import cn.com.yusys.yusp.bsp.toolkit.xml.Namespace;
import cn.com.yusys.yusp.bsp.toolkit.xml.SuperXmlNode;
import cn.com.yusys.yusp.bsp.toolkit.xml.SuperXmlTools;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class SuperXmlExecutor
extends AbstractExecutor<byte[]> {
    protected static final String DATA_FORMAT_NAME = "XML";
    protected static final String DATA_FORMAT_PACK_XML = "packXml";
    protected static final String DATA_FORMAT_PACK_SIMPLE = "packSimple";
    protected static final String DATA_FORMAT_VALUEVARIABLE = "valueVariable";
    protected static final String DATA_FORMAT_CDATAVARIABLE = "cdataVariable";
    protected static final String DATA_FORMAT_LOOPNODES = "loopNodes";
    protected static final String DATA_FORMAT_SIGN = "sign";
    protected static final String DATA_FORMAT_USEVALUE = "useValue";
    protected static final String ITEM_ATRRIBUTE_TYPE = "type";
    protected static final String ITEM_ATRRIBUTE_PATH = "path";
    protected static final String ITEM_ATRRIBUTE_PREFIX = "prefix";
    protected static final String ITEM_ATRRIBUTE_VARNAME = "varName";
    protected static final String ITEM_ATRRIBUTE_EMPTYWHILE = "emptyWhile";
    protected static final String ITEM_TYPE_VALUE = "value";
    protected static final String ITEM_TYPE_NAMESPACES = "namespace";
    protected static final String ITEM_TYPE_DEFAULT_NAMESPACES = "defNamespace";
    protected static final String ITEM_TYPE_PROPERTY = "property";
    protected static final String ITEM_TYPE_CDATA = "cdata";
    protected static final String ITEM_TYPE_XML = "xml";
    protected static final String SOAP_DEFAULT_SIGN = "_";
    protected static final String DEF_NAME_ESPACE = "xmlns";
    protected String valueVariable = "value";
    protected String cdataVariable = "cdata";
    protected List<List<String>> loopNodes;
    protected List<String> signList;
    protected boolean useValue = false;
    protected SuperXmlTools xmlTools;
    protected int state = -2;
    protected SuperXmlNode xmlNode;
    protected boolean packNode;
    protected String nodePrefix;
    protected String nodeName;
    protected boolean packSimple;
    protected static final String V_SIZE = ".size()";
    protected LinkedList<String> nodeList = new LinkedList();

    @Override
    public String getExecutorName() {
        return DATA_FORMAT_NAME;
    }

    @Override
    protected boolean supportItemMust() {
        return true;
    }

    @Override
    public void init(Map<String, String> property) throws Exception {
        Object[] temp;
        String str = property.get(DATA_FORMAT_SIGN);
        if (StringTools.isEmpty(str)) {
            this.signList = null;
        } else {
            this.signList = new ArrayList<String>();
            for (char c : temp = str.toCharArray()) {
                this.signList.add(String.valueOf(c));
            }
        }
        this.xmlTools = new SuperXmlTools(this.getEncoding());
        if (this.getPackType() == DATAFORMAT_UNPACK) {
            str = property.get(DATA_FORMAT_VALUEVARIABLE);
            if (!StringTools.isEmpty(str)) {
                this.valueVariable = str;
            }
            if (!StringTools.isEmpty(str = property.get(DATA_FORMAT_CDATAVARIABLE))) {
                this.cdataVariable = str;
            }
            if (StringTools.isEmpty(str = property.get(DATA_FORMAT_LOOPNODES))) {
                this.loopNodes = null;
            } else {
                this.loopNodes = new ArrayList<List<String>>();
                for (char string : temp = (Object[])str.split("[,]")) {
                    this.loopNodes.add(this.convertPathToList((String)string));
                }
            }
            if ("true".equals(property.get(DATA_FORMAT_USEVALUE))) {
                this.useValue = true;
            }
        } else {
            str = property.get(DATA_FORMAT_PACK_XML);
            boolean packXml = true;
            if ("false".equals(str)) {
                packXml = false;
            }
            if ("true".equals(str = property.get(DATA_FORMAT_PACK_SIMPLE))) {
                this.packSimple = true;
            }
            this.xmlTools.setPackSimple(this.packSimple);
            this.xmlTools.writeStartDocument(packXml);
        }
    }

    @Override
    public void inputData(byte[] inputData) throws Exception {
        super.inputData(inputData);
        try {
            this.xmlNode = this.xmlTools.readerXml(inputData);
        }
        catch (Exception e) {
            throw new Exception("[" + this.getExecutorName() + "] Exception in unpacking", e);
        }
    }

    @Override
    public byte[] outputInner() throws Exception {
        byte[] data;
        try {
            data = this.xmlTools.writeEndDocument();
        }
        catch (Exception e) {
            throw new Exception("[" + this.getExecutorName() + "] Packaging exception", e);
        }
        return data;
    }

    @Override
    public void packItem(Item item, byte[] data, Map<String, String> paras) throws Exception {
        if (this.state < 0) {
            throw new Exception("[" + this.getExecutorName() + "] field [" + item.getName() + "] must be in category or loop");
        }
        if (this.packNode) {
            this.xmlTools.writeStartElement(this.nodePrefix, this.nodeName);
            this.packNode = false;
            ++this.state;
        }
        String type = paras.get(ITEM_ATRRIBUTE_TYPE);
        String path = paras.get(ITEM_ATRRIBUTE_PATH);
        if (StringTools.isEmpty(path)) {
            path = item.getName();
        }
        if (ITEM_TYPE_VALUE.equals(type)) {
            if (this.packSimple && data.length == 0) {
                return;
            }
            this.xmlTools.writeCharacters(data);
        } else if (ITEM_TYPE_PROPERTY.equals(type)) {
            String prefix = paras.get(ITEM_ATRRIBUTE_PREFIX);
            this.xmlTools.writeAttribute(prefix, path, data);
        } else if (ITEM_TYPE_NAMESPACES.equals(type)) {
            this.xmlTools.writeNamespace(path, data);
        } else if (ITEM_TYPE_DEFAULT_NAMESPACES.equals(type)) {
            this.xmlTools.writeDefaultNamespace(data);
        } else if (ITEM_TYPE_CDATA.equals(type)) {
            this.xmlTools.writeCharacterData(data);
        } else if (ITEM_TYPE_XML.equals(type)) {
            this.xmlTools.writeXml(data);
        } else {
            throw new Exception("The type [" + type + "] of [" + this.getExecutorName() + "] field [" + item.getName() + "] cannot be parsed.");
        }
    }

    @Override
    public void packGroup(Group group) throws Exception {
        Head head;
        if (this.state == -1) {
            throw new Exception("[" + this.getExecutorName() + "]classify[" + group.getName() + "] must be in category or loop");
        }
        if (this.packNode) {
            this.xmlTools.writeStartElement(this.nodePrefix, this.nodeName);
            this.packNode = false;
            ++this.state;
        }
        if (!((head = group.getHead()) instanceof CacheHead)) {
            throw new Exception("Illegal group header");
        }
        CacheHead cacheHead = (CacheHead)head;
        String prefix = cacheHead.getParas().get(ITEM_ATRRIBUTE_PREFIX);
        String name = cacheHead.getParas().get(ITEM_ATRRIBUTE_VARNAME);
        if (StringTools.isEmpty(name)) {
            name = group.getName();
        }
        int oldState = this.state;
        int base2Num = -2;
        if (this.state == base2Num) {
            this.xmlTools.writeStartElement(prefix, name);
            this.packNode = false;
            this.state = 1;
            oldState = 0;
        } else {
            this.packNode = true;
            this.nodePrefix = prefix;
            this.nodeName = name;
        }
        this.packBody(group.getBody());
        if (this.packNode) {
            this.packNode = false;
        } else {
            this.xmlTools.writeEndElement(prefix, name, ++oldState < this.state);
        }
        if (this.state > oldState) {
            this.state = oldState == 1 ? -1 : oldState;
        }
    }

    @Override
    public void packWhile(While whileObject) throws Exception {
        String name;
        String prefix;
        if (this.state < 0) {
            throw new Exception("[" + this.getExecutorName() + "]loop[" + whileObject.getName() + "] must be in category or loop");
        }
        Head head = whileObject.getHead();
        boolean emptyWhile = false;
        if (head instanceof CacheHead) {
            CacheHead cacheHead = (CacheHead)head;
            prefix = cacheHead.getParas().get(ITEM_ATRRIBUTE_PREFIX);
            name = cacheHead.getParas().get(ITEM_ATRRIBUTE_VARNAME);
            String empty = cacheHead.getParas().get(ITEM_ATRRIBUTE_EMPTYWHILE);
            if (empty != null) {
                emptyWhile = Boolean.parseBoolean(empty);
            }
        } else {
            throw new Exception("Illegal loop header");
        }
        boolean nodeExpr = false;
        if (StringTools.isEmpty(name)) {
            name = whileObject.getName();
        } else {
            int nameFindChar = 34;
            if (name.indexOf(nameFindChar) != -1) {
                nodeExpr = true;
            }
        }
        if (this.packNode) {
            this.xmlTools.writeStartElement(this.nodePrefix, this.nodeName);
            this.packNode = false;
            ++this.state;
        }
        String varname = whileObject.getVar();
        int nCount = this.parseLoopCount(whileObject);
        int oldState = this.state;
        for (int i = 0; i < nCount; ++i) {
            if (!emptyWhile) {
                this.packNode = true;
            }
            this.nodePrefix = prefix;
            this.rootContext.put(varname, i);
            this.nodeName = nodeExpr ? StringTools.getString(OgnlTools.getValue(name, this.getRootContext())) : name;
            String tmpNodeName = this.nodeName;
            this.packBody(whileObject.getBody());
            if (this.packNode) {
                this.packNode = false;
            } else if (!emptyWhile) {
                this.xmlTools.writeEndElement(prefix, tmpNodeName, ++oldState < this.state);
            }
            if (this.state <= oldState) continue;
            this.state = oldState == 1 ? -1 : oldState;
        }
        this.rootContext.remove(varname);
    }

    @Override
    public Map<String, Object> autoUnpack() throws Exception {
        HashMap<String, Object> soapMap = new HashMap<String, Object>(16);
        this.xmlNode2Map(this.xmlNode, soapMap, this.useValue);
        return soapMap;
    }

    @Override
    public byte[] unPackItem(Item item, Map<String, String> paras) throws Exception {
        List<String> list;
        String path = paras.get(ITEM_ATRRIBUTE_PATH);
        boolean isPath = false;
        if (StringTools.isEmpty(path)) {
            path = this.getRealItemPath(item);
            isPath = true;
        }
        if (!(list = this.convertPathToList(path)).get(0).equals(this.xmlNode.getName())) {
            return null;
        }
        String type = paras.get(ITEM_ATRRIBUTE_TYPE);
        if (ITEM_TYPE_VALUE.equals(type)) {
            return this.unpackValueItem(isPath, list);
        }
        if (ITEM_TYPE_PROPERTY.equals(type)) {
            return this.unpackAttributeItem(list);
        }
        if (ITEM_TYPE_NAMESPACES.equals(type)) {
            return this.unpackNamespaceItem(list);
        }
        if (ITEM_TYPE_DEFAULT_NAMESPACES.equals(type)) {
            return this.unpackDefaultNamespaceItem(isPath, list);
        }
        if (ITEM_TYPE_CDATA.equals(type)) {
            return this.unpackCharacterDataItem(isPath, list);
        }
        if (ITEM_TYPE_XML.equals(type)) {
            return this.unpackXmlNodeItem(isPath, list);
        }
        throw new Exception("The type [" + type + "] of [" + this.getExecutorName() + "] field [" + item.getName() + "] cannot be parsed.");
    }

    private byte[] unpackXmlNodeItem(boolean isPath, List<String> list) throws Exception {
        SuperXmlNode node;
        if (isPath) {
            list.remove(list.size() - 1);
        }
        if ((node = this.getXmlNode(list)) == null) {
            return null;
        }
        return this.xmlTools.getXmlNodeByte(node);
    }

    private byte[] unpackCharacterDataItem(boolean isPath, List<String> list) throws Exception {
        SuperXmlNode node;
        if (isPath) {
            list.remove(list.size() - 1);
        }
        if ((node = this.getXmlNode(list)) == null) {
            return null;
        }
        return node.getCharacterData(this.getEncoding());
    }

    private byte[] unpackDefaultNamespaceItem(boolean isPath, List<String> list) throws Exception {
        SuperXmlNode node;
        if (isPath) {
            list.remove(list.size() - 1);
        }
        if ((node = this.getXmlNode(list)) == null) {
            return null;
        }
        return node.getNamespaceValue("", this.getEncoding());
    }

    private byte[] unpackNamespaceItem(List<String> list) throws Exception {
        String name = list.remove(list.size() - 1);
        SuperXmlNode node = this.getXmlNode(list);
        if (node == null) {
            return null;
        }
        return node.getNamespaceValue(name, this.getEncoding());
    }

    private byte[] unpackAttributeItem(List<String> list) throws Exception {
        String proName = list.remove(list.size() - 1);
        SuperXmlNode node = this.getXmlNode(list);
        if (node == null) {
            return null;
        }
        return node.getAttributeValue(proName, this.getEncoding());
    }

    private byte[] unpackValueItem(boolean isPath, List<String> list) throws Exception {
        SuperXmlNode node;
        if (isPath) {
            list.remove(list.size() - 1);
        }
        if ((node = this.getXmlNode(list)) == null) {
            return null;
        }
        String value = node.getValue();
        return value.getBytes(this.getEncoding());
    }

    @Override
    protected void unPackWhile(While whileObject) throws Exception {
        String count = whileObject.getMaxNum();
        String name = whileObject.getName();
        String varname = whileObject.getVar();
        String sCount = null;
        int nCount = -1;
        if (StringTools.isEmpty(count)) {
            count = this.getRealWhilePath(whileObject);
            List<String> list = this.convertLoopCountExprToList(count);
            nCount = this.getLoopSize(list);
            if (nCount == -1) {
                this.logger.warn("{} @ Structure corresponding to loop [{}] does not exist, loop ignored", new Object[]{this.getExecutorName(), count});
                return;
            }
        } else {
            try {
                sCount = StringTools.getString(OgnlTools.getValue(count, this.rootContext));
            }
            catch (Exception e1) {
                if (count.endsWith(V_SIZE)) {
                    List<String> list = this.convertLoopCountExprToList(count);
                    list.remove(list.size() - 1);
                    nCount = this.getLoopSize(list);
                    if (nCount == -1) {
                        throw new Exception(this.getExecutorName() + " @ The value corresponding to the number of loop times [" + count + "] of loop [" + this.getRealWhilePath(whileObject) + "] does not exist");
                    }
                }
                throw new Exception(this.getExecutorName() + " @ The value corresponding to the number of loop times [" + count + "] of loop [" + this.getRealWhilePath(whileObject) + "] does not exist");
            }
            if (nCount == -1) {
                if (StringTools.isEmpty(sCount)) {
                    throw new Exception(this.getExecutorName() + " @ The variable value corresponding to the number of loop times [" + count + "] of loop [" + this.getRealWhilePath(whileObject) + "] does not exist");
                }
                try {
                    nCount = Integer.parseInt(sCount);
                }
                catch (Exception e) {
                    throw new IllegalArgumentException(this.getExecutorName() + " @ The loop times in loop [" + this.getRealWhilePath(whileObject) + "] must be number, the current value=" + sCount, e);
                }
            }
        }
        super.unPackWhile(nCount, name, varname, whileObject);
    }

    protected SuperXmlNode getXmlNode(List<String> list) throws Exception {
        SuperXmlNode tempNode = this.xmlNode;
        for (int i = 1; i < list.size(); ++i) {
            Object obj;
            int index = -1;
            String tempName = list.get(i);
            int start = tempName.indexOf("[");
            int end = tempName.indexOf("]");
            if (start != -1 && end != -1) {
                obj = OgnlTools.getValue(tempName.substring(start + 1, end), this.getRootContext());
                index = Integer.parseInt(obj.toString());
                tempName = tempName.substring(0, start);
            }
            if ((obj = tempNode.getChildren().get(tempName)) == null) {
                return null;
            }
            if (obj instanceof SuperXmlNode) {
                if (index > 0) {
                    return null;
                }
                tempNode = (SuperXmlNode)obj;
                continue;
            }
            if (!(obj instanceof List)) continue;
            List tempList = (List)obj;
            if (index == -1 || index >= tempList.size()) {
                return null;
            }
            tempNode = (SuperXmlNode)tempList.get(index);
        }
        return tempNode;
    }

    protected int getLoopSize(List<String> list) throws Exception {
        SuperXmlNode tempNode = this.xmlNode;
        int size = list.size() - 1;
        if (!list.get(0).equals(this.xmlNode.getName())) {
            return -1;
        }
        for (int i = 1; i <= size; ++i) {
            Object obj;
            int index = -1;
            String tempName = list.get(i);
            int start = tempName.indexOf("[");
            int end = tempName.indexOf("]");
            if (start != -1 && end != -1) {
                obj = OgnlTools.getValue(tempName.substring(start + 1, end), this.getRootContext());
                index = Integer.parseInt(obj.toString());
                tempName = tempName.substring(0, start);
            }
            if ((obj = tempNode.getChildren().get(tempName)) instanceof SuperXmlNode) {
                if (index > 0) {
                    return -1;
                }
                tempNode = (SuperXmlNode)obj;
                continue;
            }
            if (obj instanceof List) {
                List tempList = (List)obj;
                if (i == size) {
                    return tempList.size();
                }
                if (index == -1 || index >= tempList.size()) {
                    return -1;
                }
                tempNode = (SuperXmlNode)tempList.get(index);
                continue;
            }
            return -1;
        }
        return 1;
    }

    protected String convertSign(String str) {
        if (this.signList == null || StringTools.isEmpty(str)) {
            return str;
        }
        for (String temp : this.signList) {
            if (!str.contains(temp)) continue;
            str = str.replace(temp, SOAP_DEFAULT_SIGN);
        }
        return str;
    }

    protected List<String> convertPathToList(String path) {
        String[] loopNode;
        ArrayList<String> loop = new ArrayList<String>();
        path = StringUtils.replace((String)path, (String)"/", (String)".");
        for (String s : loopNode = StringUtils.split((String)path, (String)".")) {
            if (StringTools.isEmpty(s)) continue;
            loop.add(s);
        }
        return loop;
    }

    protected List<String> convertLoopCountExprToList(String path) {
        String[] loopNode;
        ArrayList<String> loop = new ArrayList<String>();
        path = StringUtils.replace((String)path, (String)"/", (String)".");
        for (String s : loopNode = StringUtils.split((String)path, (String)".")) {
            if (StringTools.isEmpty(s)) continue;
            loop.add(s);
        }
        return loop;
    }

    protected void xmlNode2Map(SuperXmlNode xml, Object root, boolean useVar) throws Exception {
        String name = xml.getName();
        this.nodeList.add(name);
        String value = xml.getValue();
        if (value != null) {
            value = value.trim();
        }
        Map<String, Object> children = xml.getChildren();
        Map<String, Namespace> namespaces = xml.getNamespaces();
        Map<String, Attribute> attributes = xml.getAttrs();
        String cdata = xml.getCdata();
        int childSize = children.size();
        int attributeSize = attributes.size();
        int namespaceSize = namespaces.size();
        if (!useVar) {
            boolean checked;
            boolean bl = checked = childSize == 0 && (namespaceSize > 0 || attributeSize > 0);
            if (checked) {
                throw new Exception("Value variable must be true when leaf node [" + name + "] includes attribute or namespace");
            }
            if (!StringTools.isEmpty(cdata) && !StringTools.isEmpty(value)) {
                throw new Exception("Value variable must be true when leaf node [" + name + "] value and CDATA exist at the same time");
            }
            if (childSize == 0) {
                this.childNodeIsEmpty(root, name, value, cdata);
                return;
            }
        }
        HashMap<String, Object> nodeMap = new HashMap<String, Object>(16);
        if (!StringTools.isEmpty(cdata)) {
            nodeMap.put(this.cdataVariable, cdata);
        }
        if (value != null && (value.length() > 0 || childSize == 0)) {
            value = StringTools.getString(this.invokeMethods(this.getGlobalParseMethod(), value, 1));
            nodeMap.put(this.valueVariable, value);
        }
        if (namespaceSize != 0) {
            for (Namespace namespace : namespaces.values()) {
                String prefix = StringTools.isEmpty(namespace.getPrefix()) ? DEF_NAME_ESPACE : namespace.getPrefix();
                prefix = this.convertSign(prefix);
                nodeMap.put(prefix, namespace.getUri());
            }
        }
        if (attributeSize != 0) {
            for (Attribute attr : attributes.values()) {
                String tempName = this.convertSign(attr.getName());
                value = StringTools.getString(this.invokeMethods(this.getGlobalParseMethod(), attr.getValue(), 1));
                nodeMap.put(tempName, value);
            }
        }
        this.xmlNode2Map(root, useVar, name, children, nodeMap);
    }

    private void xmlNode2Map(Object root, boolean useVar, String name, Map<String, Object> children, Map<String, Object> nodeMap) throws Exception {
        String tempName = this.convertSign(name);
        if (root instanceof List) {
            ((List)root).add(nodeMap);
        } else if (root instanceof Map) {
            ((Map)root).put(tempName, nodeMap);
        }
        for (String key : children.keySet()) {
            LinkedList childrenList;
            Object obj = children.get(key);
            if (obj instanceof SuperXmlNode) {
                if (this.validateLoop(this.nodeList, key)) {
                    childrenList = new LinkedList();
                    nodeMap.put(key, childrenList);
                    this.xmlNode2Map((SuperXmlNode)obj, childrenList, useVar);
                    continue;
                }
                this.xmlNode2Map((SuperXmlNode)obj, nodeMap, useVar);
                continue;
            }
            if (obj instanceof List) {
                childrenList = new LinkedList();
                nodeMap.put(key, childrenList);
                for (SuperXmlNode tempNode : (List)obj) {
                    this.xmlNode2Map(tempNode, childrenList, useVar);
                }
                continue;
            }
            throw new Exception("Type not supported:" + obj);
        }
        this.nodeList.removeLast();
    }

    private void childNodeIsEmpty(Object root, String name, String value, String cdata) throws Exception {
        String text = "";
        if (StringTools.isEmpty(value)) {
            if (!StringTools.isEmpty(cdata)) {
                text = cdata;
            }
        } else {
            text = StringTools.getString(this.invokeMethods(this.getGlobalParseMethod(), value, 1));
        }
        if (root instanceof List) {
            ((List)root).add(text);
        } else if (root instanceof Map) {
            String tempName = this.convertSign(name);
            ((Map)root).put(tempName, text);
        }
        this.nodeList.removeLast();
    }

    protected boolean validateLoop(LinkedList<String> nodeList, String key) {
        if (this.loopNodes == null) {
            return false;
        }
        boolean res = false;
        nodeList.add(key);
        for (List<String> list : this.loopNodes) {
            if (list.size() != nodeList.size() || !list.equals(nodeList)) continue;
            res = true;
            break;
        }
        nodeList.removeLast();
        return res;
    }

    @Override
    public int getSearchIndex() {
        return -1;
    }
}

