/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.bsp.component.impl.basic;

import cn.com.yusys.yusp.bsp.component.AbstractComponent;
import cn.com.yusys.yusp.bsp.component.exception.ComponentException;
import cn.com.yusys.yusp.bsp.resources.ResourcePortal;
import cn.com.yusys.yusp.bsp.resources.core.ResourceHolder;
import cn.com.yusys.yusp.bsp.resources.creator.impl.CacheMapping;
import cn.com.yusys.yusp.bsp.resources.creator.impl.CacheMappings;
import cn.com.yusys.yusp.bsp.resources.creator.impl.CacheMetas;
import cn.com.yusys.yusp.bsp.schema.mapping.Item;
import cn.com.yusys.yusp.bsp.schema.mapping.Items;
import cn.com.yusys.yusp.bsp.schema.mapping.Mapping;
import cn.com.yusys.yusp.bsp.schema.mapping.Property;
import cn.com.yusys.yusp.bsp.toolkit.common.Assert;
import cn.com.yusys.yusp.bsp.toolkit.common.StringTools;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.oro.text.GlobCompiler;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.Perl5Matcher;

public class DataMapper
extends AbstractComponent {
    private static final String COMPONENT_NAME = "DataMapper";
    private String tableName;
    private String sourceVars;
    private String mapVarName;
    private String targetVars;
    private String mapFile;
    private volatile ResourceHolder holder;
    private final Object mutex = new Object();
    private static final String V_COMMA = ",";
    private static final char V_INTERROGATION = '?';
    private static final char V_ASTERISK = '*';

    @Override
    protected void executeComponent(Map<String, Object> context) throws Exception {
        String tmpMapFile = null;
        if (StringTools.isEmpty(this.mapFile)) {
            tmpMapFile = this.getMappingPath(context);
        }
        this.executeComponent(context, tmpMapFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeComponent(Map<String, Object> context, String mapFile) throws Exception {
        String[] stringArray;
        ResourceHolder localHolder = this.holder;
        if (localHolder == null) {
            Object object = this.mutex;
            synchronized (object) {
                localHolder = this.holder;
                if (localHolder == null) {
                    this.holder = ResourcePortal.getInstance().getResourceHolder();
                }
            }
        }
        if (!StringTools.isEmpty(mapFile)) {
            this.mapFile = mapFile;
        }
        this.logger.info("{} @ Load data mapping configuration file: [{}]", (Object)this.getComponentName(), (Object)this.mapFile);
        CacheMappings mappings = (CacheMappings)this.holder.getResource("mpd", this.mapFile);
        CacheMapping mapping = (CacheMapping)mappings.getMap().get(this.getTableName());
        if (mapping == null) {
            throw new ComponentException("Mapping table does not exist:" + this.getTableName());
        }
        Assert.notNull(this.getSourceVars(), "Condition variable set is empty");
        Assert.notNull(this.getTargetVars(), "The result variable set is empty");
        String[] querys = this.getSourceVars().split(V_COMMA);
        HashMap<String, String> queryMap = new HashMap<String, String>(16);
        CacheMetas metas = (CacheMetas)mapping.getMetas();
        List<String> keyList = metas.getMetasList();
        Map ctx = context;
        if (!StringTools.isEmpty(this.getMapVarName())) {
            Object object = this.getInExpressObjectValue(this.getMapVarName(), context);
            if (object instanceof Map) {
                ctx = (Map)object;
            } else {
                throw new ComponentException("[Map variable] The value type is not MAP");
            }
        }
        for (String query : querys) {
            if (!keyList.contains(query)) {
                throw new ComponentException(query + "Condition Variable:" + query + "Does not match the mapping table:" + keyList);
            }
            String qValue = StringTools.getString(ctx.get(query));
            if (qValue == null) {
                throw new ComponentException(query + "Condition variable value is empty");
            }
            queryMap.put(query, qValue);
            this.logger.debug("{} @ Condition:{}=[{}]", new Object[]{this.getComponentName(), query, qValue});
        }
        for (String result : stringArray = this.getTargetVars().split(V_COMMA)) {
            if (keyList.contains(result)) continue;
            throw new ComponentException(result + "Outcome variable:" + result + "Does not match the mapping table:" + keyList);
        }
        List<String> resultList = Arrays.asList(stringArray);
        Item targetItem = this.matchItem(mapping, queryMap);
        if (targetItem == null) {
            throw new ComponentException("No record meeting the condition was found:" + queryMap);
        }
        this.processResult(targetItem, resultList, ctx);
    }

    public Item matchItem(Mapping mapping, Map<String, String> queryMap) throws MalformedPatternException {
        Item[] itemArr;
        GlobCompiler compiler = new GlobCompiler();
        Perl5Matcher matcher = new Perl5Matcher();
        Item targetItem = null;
        Items items = mapping.getItems();
        for (Item item : itemArr = items.getItem()) {
            Property[] propertyArr = item.getProperty();
            int k = 0;
            boolean flag = false;
            for (Property property : propertyArr) {
                String proName = property.getName();
                String proValue = property.getValue();
                String qValue = queryMap.get(proName);
                if (qValue != null) {
                    if (proValue.equals(qValue)) {
                        ++k;
                    } else {
                        Pattern pattern;
                        if (proValue.indexOf(63) <= -1 && proValue.indexOf(42) <= -1 || !matcher.matches(qValue, pattern = compiler.compile(proValue))) break;
                        ++k;
                    }
                }
                if (k != queryMap.size()) continue;
                flag = true;
                break;
            }
            if (!flag) continue;
            targetItem = item;
            break;
        }
        return targetItem;
    }

    private void processResult(Item item, List<String> resultList, Map<String, Object> context) {
        Enumeration<? extends Property> enPropertys = item.enumerateProperty();
        while (enPropertys.hasMoreElements()) {
            Property property = enPropertys.nextElement();
            String proName = property.getName();
            String proValue = property.getValue();
            if (!resultList.contains(proName)) continue;
            context.put(proName, proValue);
            this.logger.debug("{} @ Result:{}=[{}]", new Object[]{this.getComponentName(), proName, proValue});
        }
    }

    public String getMappingPath(Map<String, Object> context) {
        return this.getModulePath(context) + "/mapping." + "mpd";
    }

    @Override
    public String getComponentName() {
        return COMPONENT_NAME;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getSourceVars() {
        return this.sourceVars;
    }

    public void setSourceVars(String sourceVars) {
        this.sourceVars = sourceVars;
    }

    public String getMapVarName() {
        return this.mapVarName;
    }

    public void setMapVarName(String mapVarName) {
        this.mapVarName = mapVarName;
    }

    public String getTargetVars() {
        return this.targetVars;
    }

    public void setTargetVars(String targetVars) {
        this.targetVars = targetVars;
    }
}

