/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.bsp.communication.impl.ssl;

import cn.com.yusys.yusp.bsp.toolkit.common.StringTools;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class SecureSocketsLayerFactory {
    private String sslContextAlgorithm;
    private String keyStoreAlgorithm;
    private String trustManagerAlgorithm;

    public void iniAlgorithm(String sslContextAlgorithm, String keyStoreAlgorithm, String trustManagerAlgorithm) {
        this.sslContextAlgorithm = sslContextAlgorithm;
        this.trustManagerAlgorithm = trustManagerAlgorithm;
        this.keyStoreAlgorithm = keyStoreAlgorithm;
    }

    public SSLServerSocketFactory buildServerFactory(String keyStoreFile, String keyStorePwd, String keyPwd) throws Exception {
        KeyStore serverKeyStore = this.getKeyStore(keyStoreFile, keyStorePwd);
        KeyManagerFactory kmf = this.getKeyManagerFactory(keyPwd, serverKeyStore);
        SSLContext sslContext = SSLContext.getInstance(this.sslContextAlgorithm);
        sslContext.init(kmf.getKeyManagers(), null, null);
        return sslContext.getServerSocketFactory();
    }

    public synchronized SSLServerSocketFactory buildServerFactory(String keyStoreFile, String keyStorePwd, String keyPwd, String trustKeyStoreFile, String trustKeyStorePwd) throws Exception {
        KeyStore serverKeyStore = this.getKeyStore(keyStoreFile, keyStorePwd);
        KeyManagerFactory kmf = this.getKeyManagerFactory(keyPwd, serverKeyStore);
        SSLContext sslContext = SSLContext.getInstance(this.sslContextAlgorithm);
        KeyStore serverTrustKeyStore = serverKeyStore;
        if (!StringTools.isEmpty(trustKeyStoreFile) && !StringTools.isEmpty(trustKeyStorePwd)) {
            serverTrustKeyStore = this.getKeyStore(trustKeyStoreFile, trustKeyStorePwd);
        }
        TrustManagerFactory tmf = this.getTrustManagerFactory(serverTrustKeyStore);
        sslContext.init(kmf.getKeyManagers(), tmf.getTrustManagers(), null);
        return sslContext.getServerSocketFactory();
    }

    public SSLSocketFactory buildClientFactory(String keyStoreFile, String keyStorePwd, String keyPwd, String trustKeyStoreFile, String trustKeyStorePwd) throws Exception {
        KeyStore clientKeyStore = this.getKeyStore(keyStoreFile, keyStorePwd);
        KeyManagerFactory kmf = this.getKeyManagerFactory(keyPwd, clientKeyStore);
        KeyStore clientTrustKeyStore = this.getKeyStore(trustKeyStoreFile, trustKeyStorePwd);
        TrustManagerFactory tmf = this.getTrustManagerFactory(clientTrustKeyStore);
        SSLContext ctx = SSLContext.getInstance(this.sslContextAlgorithm);
        ctx.init(kmf.getKeyManagers(), tmf.getTrustManagers(), null);
        return ctx.getSocketFactory();
    }

    public synchronized SSLSocketFactory buildClientFactory(String trustKeyStoreFile, String trustKeyStorePwd) throws Exception {
        KeyStore clientTrustKeyStore = this.getKeyStore(trustKeyStoreFile, trustKeyStorePwd);
        SSLContext sc = SSLContext.getInstance(this.sslContextAlgorithm);
        TrustManagerFactory tmf = this.getTrustManagerFactory(clientTrustKeyStore);
        sc.init(null, tmf.getTrustManagers(), null);
        return sc.getSocketFactory();
    }

    protected KeyStore getKeyStore(String keyStoreFile, String keyStorePwd) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        KeyStore keyStore = KeyStore.getInstance(this.keyStoreAlgorithm);
        try (FileInputStream ksInputStream = new FileInputStream(keyStoreFile);){
            keyStore.load(ksInputStream, keyStorePwd.toCharArray());
        }
        return keyStore;
    }

    protected KeyManagerFactory getKeyManagerFactory(String keyPwd, KeyStore keyStore) throws NoSuchAlgorithmException, KeyStoreException, UnrecoverableKeyException {
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(this.trustManagerAlgorithm);
        kmf.init(keyStore, keyPwd.toCharArray());
        return kmf;
    }

    protected TrustManagerFactory getTrustManagerFactory(KeyStore trustKeyStore) throws NoSuchAlgorithmException, KeyStoreException {
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(this.trustManagerAlgorithm);
        tmf.init(trustKeyStore);
        return tmf;
    }

    public synchronized SSLSocketFactory buildClientFactory() throws Exception {
        SSLContext sc = SSLContext.getInstance(this.sslContextAlgorithm);
        SecureSocketsLayerHandler simpleVerifier = new SecureSocketsLayerHandler();
        sc.init(null, new TrustManager[]{simpleVerifier}, null);
        return sc.getSocketFactory();
    }

    private static class SecureSocketsLayerHandler
    implements X509TrustManager,
    HostnameVerifier {
        private SecureSocketsLayerHandler() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] arg0, String arg1) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] arg0, String arg1) {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }

        @Override
        public boolean verify(String arg0, SSLSession arg1) {
            return true;
        }
    }
}

