/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.bsp.toolkit.common;

import cn.com.yusys.yusp.bsp.app.config.ModulePath;
import cn.com.yusys.yusp.bsp.toolkit.common.FileTools;
import cn.com.yusys.yusp.bsp.toolkit.logback.LogbackUtil;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public class FileChecker {
    private final Logger logger = LoggerFactory.getLogger(FileChecker.class);
    public static String ENV_CHECKE_INTERNAL = "bsp.checkeInternal";
    public static long DEFAULT_CHECK_INTERNAL = 10000L;
    public static final Map<String, FileChecker> APP_2_OBJECT;
    private final Map<String, Boolean> checkChangedMap = new ConcurrentHashMap<String, Boolean>();
    private final Map<String, Boolean> existFileMap = new ConcurrentHashMap<String, Boolean>();
    private final Map<String, String> absDirMap = new ConcurrentHashMap<String, String>();
    private final Map<String, String> vDirMap = new ConcurrentHashMap<String, String>();
    public static final Set<String> V_FILE_TYPE_SET;
    private final FileCheckThread fileCheckThread;
    private ExecutorService singleThreadPool;
    private boolean running = true;
    private final String appName;
    private final Object lockChangedFlag = new Object();
    private final Object lockFlag = new Object();
    private final Object lockPath = new Object();
    private static final char DOT = '.';
    private static final char SLASH = '/';
    private static final String SEPARATOR = "/";
    private static final String RESOURCE_PATH = "**/";

    private FileChecker(String appName) {
        this.appName = appName;
        this.fileCheckThread = new FileCheckThread();
        this.singleThreadPool = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(1024), new ThreadFactoryBuilder().setNameFormat("FILE-CHECK-THREAD:" + appName).setDaemon(true).setPriority(1).build(), new ThreadPoolExecutor.AbortPolicy());
        this.singleThreadPool.execute(this.fileCheckThread);
    }

    public static FileChecker getDefaultInstance() {
        String defaultApp = "DefaultChecker";
        return FileChecker.getInstance(defaultApp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FileChecker getInstance(String appName) {
        FileChecker fileChecker = APP_2_OBJECT.get(appName);
        if (fileChecker == null) {
            Map<String, FileChecker> map = APP_2_OBJECT;
            synchronized (map) {
                fileChecker = APP_2_OBJECT.get(appName);
                if (fileChecker == null) {
                    fileChecker = new FileChecker(appName);
                    APP_2_OBJECT.put(appName, fileChecker);
                }
            }
        }
        return fileChecker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isChanged(String filename) {
        Boolean changedFlag = this.checkChangedMap.get(filename);
        if (changedFlag == null || changedFlag.booleanValue()) {
            Object object = this.lockChangedFlag;
            synchronized (object) {
                changedFlag = this.checkChangedMap.get(filename);
                if (changedFlag == null) {
                    if (this.fileCheckThread.registryChangedFile(filename)) {
                        this.checkChangedMap.put(filename, false);
                    }
                    return true;
                }
                if (changedFlag.booleanValue()) {
                    this.checkChangedMap.put(filename, false);
                }
            }
        }
        return changedFlag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isExisted(String filePath) {
        Boolean flag = this.existFileMap.get(filePath);
        if (flag == null) {
            Object object = this.lockFlag;
            synchronized (object) {
                flag = this.existFileMap.get(filePath);
                if (flag == null) {
                    this.fileCheckThread.registryExistFile(filePath);
                    flag = this.existFileMap.get(filePath);
                }
            }
        }
        if (flag == null) {
            flag = false;
        }
        return flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPathInVirtualDir(String folderPath, String fileName) throws IOException {
        String vPathKey = folderPath + '/' + fileName;
        String path = this.vDirMap.get(vPathKey);
        if (path != null) {
            return path;
        }
        Object object = this.lockPath;
        synchronized (object) {
            path = this.vDirMap.get(vPathKey);
            if (path == null) {
                int index;
                if (!fileName.endsWith(".mfd")) {
                    fileName = fileName + ".mfd";
                }
                if ((index = fileName.indexOf(58)) != -1) {
                    fileName = fileName.substring(index + 1);
                }
                if ((path = FileChecker.nestFindRelativePath(folderPath, fileName)) != null && this.isExisted(path)) {
                    this.absDirMap.put(path, vPathKey);
                    this.vDirMap.put(vPathKey, path);
                }
            }
            return path;
        }
    }

    private void updateVirtualDir(String fileName) {
        int index = fileName.lastIndexOf(46);
        String type = fileName.substring(index + 1);
        if (V_FILE_TYPE_SET.contains(type)) {
            String vPath = this.absDirMap.get(fileName);
            if (vPath != null) {
                this.vDirMap.remove(vPath);
            }
            this.absDirMap.remove(fileName);
        }
    }

    private static String nestFindFile(File dir, String fileName) {
        String path = null;
        File file = new File(dir, fileName);
        if (!file.exists()) {
            File[] files = dir.listFiles(File::isDirectory);
            if (files != null) {
                for (File f : files) {
                    String tmp = FileChecker.nestFindFile(f, fileName);
                    if (tmp == null) continue;
                    return tmp;
                }
            }
        } else {
            path = file.getPath();
        }
        return path;
    }

    private static String nestFindResource(String folderPath, String fileName) throws IOException {
        String locationPattern = folderPath + RESOURCE_PATH + fileName;
        try {
            Resource[] resources;
            PathMatchingResourcePatternResolver pmrpr = new PathMatchingResourcePatternResolver();
            for (Resource resource : resources = pmrpr.getResources(locationPattern)) {
                String url;
                if (!resource.exists() || (url = resource.getURL().toString()) == null) continue;
                String relativePath = (folderPath = folderPath.replaceAll("\\\\", SEPARATOR)).substring("classpath*:".length());
                int i = url.indexOf(relativePath);
                if (i > 0) {
                    url = url.substring(i);
                }
                return "classpath*:" + url;
            }
            return null;
        }
        catch (FileNotFoundException e) {
            return null;
        }
    }

    public static String nestFindRelativePath(String folderPath, String fileName) throws IOException {
        if (folderPath == null || fileName == null || fileName.length() <= 0) {
            return null;
        }
        if (!folderPath.endsWith(SEPARATOR)) {
            folderPath = folderPath + SEPARATOR;
        }
        String path = ModulePath.isFileModel() ? FileChecker.nestFindFile(new File(folderPath), fileName) : FileChecker.nestFindResource(folderPath, fileName);
        return path;
    }

    public boolean isRunning() {
        return this.running;
    }

    public void setRunning(boolean running) {
        this.running = running;
    }

    public void exit() {
        this.setRunning(false);
        if (this.singleThreadPool != null) {
            this.singleThreadPool.shutdown();
            this.singleThreadPool = null;
        }
        APP_2_OBJECT.remove(this.appName);
    }

    static {
        String internal = System.getProperty(ENV_CHECKE_INTERNAL, "10000");
        try {
            DEFAULT_CHECK_INTERNAL = Integer.parseInt(internal);
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        APP_2_OBJECT = new HashMap<String, FileChecker>();
        V_FILE_TYPE_SET = new HashSet<String>();
        V_FILE_TYPE_SET.add("mfd");
        V_FILE_TYPE_SET.add("dsf");
    }

    public class FileCheckThread
    implements Runnable {
        Set<String> checkFileSet = new CopyOnWriteArraySet<String>();
        Set<String> existFileSet = new CopyOnWriteArraySet<String>();
        Map<String, Long> lastModifiedMap = new ConcurrentHashMap<String, Long>();

        @Override
        public void run() {
            LogbackUtil.removeSingleInfo("serialno");
            while (FileChecker.this.isRunning()) {
                try {
                    Thread.sleep(DEFAULT_CHECK_INTERNAL);
                    ArrayList<String> deletedFileList = new ArrayList<String>();
                    if (this.checkFileSet.size() > 0) {
                        for (String fileName : this.checkFileSet) {
                            if (FileTools.fetchFileExists(fileName)) {
                                Long lastModifiedTime;
                                long currentModifiedTime = 0L;
                                File checkFile = FileTools.fetchFile(fileName);
                                if (checkFile != null) {
                                    currentModifiedTime = checkFile.lastModified();
                                }
                                if ((lastModifiedTime = this.lastModifiedMap.get(fileName)) != null && currentModifiedTime == lastModifiedTime) continue;
                                this.lastModifiedMap.put(fileName, currentModifiedTime);
                                FileChecker.this.checkChangedMap.put(fileName, true);
                                if (!FileChecker.this.logger.isInfoEnabled()) continue;
                                FileChecker.this.logger.info("Resource file modified:" + fileName);
                                continue;
                            }
                            if (FileChecker.this.logger.isInfoEnabled()) {
                                FileChecker.this.logger.info("Resource file deleted:" + fileName);
                            }
                            this.removeFromCheckMap(fileName);
                            deletedFileList.add(fileName);
                        }
                    }
                    if (this.existFileSet.size() <= 0) continue;
                    for (String fileName : this.existFileSet) {
                        boolean logFlag;
                        Boolean flag = (Boolean)FileChecker.this.existFileMap.get(fileName);
                        Boolean existFlag = FileTools.fetchFileExists(fileName);
                        if (existFlag.equals(flag)) continue;
                        boolean bl = logFlag = !deletedFileList.contains(fileName);
                        if (existFlag.booleanValue()) {
                            FileChecker.this.existFileMap.put(fileName, true);
                            if (!FileChecker.this.logger.isInfoEnabled() || !logFlag) continue;
                            FileChecker.this.logger.info("File added:" + fileName);
                            continue;
                        }
                        FileChecker.this.existFileMap.put(fileName, false);
                        FileChecker.this.updateVirtualDir(fileName);
                        if (!FileChecker.this.logger.isInfoEnabled() || !logFlag) continue;
                        FileChecker.this.logger.info("File deleted:" + fileName);
                    }
                }
                catch (InterruptedException e1) {
                    Thread.currentThread().interrupt();
                }
                catch (Throwable e) {
                    FileChecker.this.logger.error("File change check tool class @ FileCheckThread run error", e);
                }
            }
        }

        public boolean registryChangedFile(String filename) {
            if (ModulePath.isFileModel(ModulePath.getModel())) {
                File file = FileTools.fetchFile(filename);
                if (file == null || !file.exists()) {
                    return false;
                }
                long last = file.lastModified();
                this.checkFileSet.add(filename);
                this.lastModifiedMap.put(filename, last);
                return true;
            }
            return true;
        }

        public void registryExistFile(String filePath) {
            FileChecker.this.existFileMap.put(filePath, FileTools.fetchFileExists(filePath));
            this.existFileSet.add(filePath);
        }

        private void removeFromCheckMap(String filename) {
            this.lastModifiedMap.remove(filename);
            this.checkFileSet.remove(filename);
            FileChecker.this.checkChangedMap.remove(filename);
        }
    }
}

