/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.bsp.toolkit.xml;

import cn.com.yusys.yusp.bsp.toolkit.xml.Attribute;
import cn.com.yusys.yusp.bsp.toolkit.xml.Namespace;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class XMLNode {
    private String prefix = "";
    private String value = "";
    private String name = "";
    private String cdata = null;
    private List<Attribute> attrs;
    private List<Namespace> namespaces;
    private Map<String, Object> children;

    public XMLNode(String name) {
        this.name = name;
        this.attrs = new ArrayList<Attribute>();
        this.namespaces = new ArrayList<Namespace>();
        this.children = new LinkedHashMap<String, Object>();
    }

    public String getCDATA() {
        return this.cdata;
    }

    public void setCDATA(String cdata) {
        this.cdata = cdata;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(byte[] value, String encoding) throws Exception {
        this.value = new String(value, encoding);
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public void addAttrs(String name, String value) {
        Attribute attr = new Attribute(name, value);
        this.attrs.add(attr);
    }

    public void addAttrs(String prefix, String name, String value) {
        Attribute attr = new Attribute(prefix, name, value);
        this.attrs.add(attr);
    }

    public void addAttrs(Attribute attr) {
        this.attrs.add(attr);
    }

    public void addNamespace(String prefix, String uri) {
        Namespace namespace = new Namespace(prefix, uri);
        this.namespaces.add(namespace);
    }

    public void addChild(XMLNode child) {
        String name = child.getName();
        Object obj = this.children.get(name);
        if (obj == null) {
            this.children.put(name, child);
        } else if (obj instanceof List) {
            ((List)obj).add(child);
        } else if (obj instanceof XMLNode) {
            XMLNode node = (XMLNode)obj;
            LinkedList<XMLNode> list = new LinkedList<XMLNode>();
            list.add(node);
            list.add(child);
            this.children.put(name, list);
        }
    }

    public List<Attribute> getAttrs() {
        return this.attrs;
    }

    public void setAttrs(List<Attribute> attrs) {
        this.attrs = attrs;
    }

    public List<Namespace> getNamespaces() {
        return this.namespaces;
    }

    public void setNamespaces(List<Namespace> namespaces) {
        this.namespaces = namespaces;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Map<String, Object> getChildren() {
        return this.children;
    }

    public void setChildren(Map<String, Object> children) {
        this.children = children;
    }
}

