/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.bsp.toolkit.xml;

import cn.com.yusys.yusp.bsp.toolkit.xml.SuperXmlNode;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.Namespace;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class SuperXmlTools {
    private String encoding;
    private boolean packSimple = true;
    private boolean endFlag = false;
    private boolean haveValue = false;
    private final byte[] DEF_NAME_ESPACE = "xmlns".getBytes();
    private final byte[] startCData = "<![CDATA[".getBytes();
    private final byte[] endCData = "]]>".getBytes();
    private ByteArrayOutputStream output;
    private static final XMLInputFactory INPUT_FACTORY = XMLInputFactory.newInstance();
    private static final String ATTRI_NAME = "name";
    private static final String BT_DATA = "data";
    private static final String BT_FIELD = "field";
    private static final String BT_SERVICE = "service";
    private static final byte[] DIGITS;
    private static final byte[] LT_ESCAPE;
    private static final byte[] GT_ESCAPE;
    private static final byte[] AND_ESCAPE;
    private static final byte[] QUOT_ESCAPE;

    public void writeStartDocument(boolean packXml) throws Exception {
        this.output = new ByteArrayOutputStream();
        if (packXml) {
            String xml = "<?xml version=\"1.0\" encoding=\"" + this.encoding + "\" ?>";
            this.output.write(xml.getBytes(this.encoding));
        }
    }

    public void writeStartElement(String prefix, String name) throws Exception {
        if (this.endFlag) {
            this.output.write(DIGITS[1]);
        }
        this.output.write(DIGITS[0]);
        if (!this.isEmpty(prefix)) {
            this.output.write(prefix.getBytes(this.encoding));
            this.output.write(DIGITS[4]);
        }
        this.output.write(name.getBytes(this.encoding));
        this.endFlag = true;
    }

    public void writeAttribute(String prefix, String name, String value) throws Exception {
        this.writeAttribute(prefix, name, value.getBytes(this.encoding));
    }

    public void writeAttribute(String prefix, String name, byte[] value) throws Exception {
        if (!this.endFlag) {
            throw new Exception("Property configuration location is incorrect, must precede 'value'");
        }
        this.output.write(DIGITS[5]);
        if (!this.isEmpty(prefix)) {
            this.output.write(prefix.getBytes(this.encoding));
            this.output.write(DIGITS[4]);
        }
        this.output.write(name.getBytes(this.encoding));
        this.output.write(DIGITS[2]);
        this.output.write(DIGITS[3]);
        this.output.write(this.escapeCharacter(value));
        this.output.write(DIGITS[3]);
    }

    public void writeNamespace(String name, String value) throws Exception {
        this.writeNamespace(name, value.getBytes(this.encoding));
    }

    public void writeNamespace(String name, byte[] value) throws Exception {
        if (!this.endFlag) {
            throw new Exception("Namaspace configuration location is incorrect, must precede 'value'");
        }
        this.output.write(DIGITS[5]);
        this.output.write(this.DEF_NAME_ESPACE);
        this.output.write(DIGITS[4]);
        this.output.write(name.getBytes(this.encoding));
        this.output.write(DIGITS[2]);
        this.output.write(DIGITS[3]);
        this.output.write(value);
        this.output.write(DIGITS[3]);
    }

    public void writeDefaultNamespace(byte[] value) throws Exception {
        if (!this.endFlag) {
            throw new Exception("Default namespace configuration location is incorrect, must precede 'value'");
        }
        this.output.write(DIGITS[5]);
        this.output.write(this.DEF_NAME_ESPACE);
        this.output.write(DIGITS[2]);
        this.output.write(DIGITS[3]);
        this.output.write(value);
        this.output.write(DIGITS[3]);
    }

    public void writeCharacterData(byte[] data) throws Exception {
        if (this.endFlag) {
            this.output.write(DIGITS[1]);
        }
        this.output.write(this.startCData);
        this.output.write(data);
        this.output.write(this.endCData);
        this.haveValue = true;
        this.endFlag = false;
    }

    public void writeXml(byte[] data) throws Exception {
        if (this.endFlag) {
            this.output.write(DIGITS[1]);
        }
        this.output.write(data);
        this.haveValue = true;
        this.endFlag = false;
    }

    public void writeCharacters(byte[] value) throws Exception {
        if (this.endFlag) {
            this.output.write(DIGITS[1]);
        }
        this.output.write(this.escapeCharacter(value));
        this.haveValue = true;
        this.endFlag = false;
    }

    public void writeEndElement(String prefix, String name, boolean haveChildren) throws Exception {
        if (this.haveValue || haveChildren) {
            this.output.write(DIGITS[0]);
            this.output.write(DIGITS[6]);
            if (!this.isEmpty(prefix)) {
                this.output.write(prefix.getBytes(this.encoding));
                this.output.write(DIGITS[4]);
            }
            this.output.write(name.getBytes(this.encoding));
            this.output.write(DIGITS[1]);
        } else if (this.packSimple) {
            this.output.write(DIGITS[6]);
            this.output.write(DIGITS[1]);
        } else {
            this.output.write(DIGITS[1]);
            this.output.write(DIGITS[0]);
            this.output.write(DIGITS[6]);
            if (!this.isEmpty(prefix)) {
                this.output.write(prefix.getBytes(this.encoding));
                this.output.write(DIGITS[4]);
            }
            this.output.write(name.getBytes(this.encoding));
            this.output.write(DIGITS[1]);
        }
        this.haveValue = false;
        this.endFlag = false;
    }

    public byte[] writeEndDocument() throws Exception {
        byte[] data = this.output.toByteArray();
        this.output.close();
        this.output = null;
        return data;
    }

    public byte[] escapeCharacter(byte[] data) throws Exception {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        int index = 0;
        for (int i = 0; i < data.length; ++i) {
            if (data[i] == DIGITS[0]) {
                os.write(data, index, i - index);
                os.write(LT_ESCAPE);
                index = i + 1;
                continue;
            }
            if (data[i] == DIGITS[1]) {
                os.write(data, index, i - index);
                os.write(GT_ESCAPE);
                index = i + 1;
                continue;
            }
            if (data[i] == DIGITS[3]) {
                os.write(data, index, i - index);
                os.write(QUOT_ESCAPE);
                index = i + 1;
                continue;
            }
            if (data[i] != DIGITS[7]) continue;
            os.write(data, index, i - index);
            os.write(AND_ESCAPE);
            index = i + 1;
        }
        if (index != 0) {
            os.write(data, index, data.length - index);
            data = os.toByteArray();
        }
        os.close();
        return data;
    }

    public byte[] getXmlNodeByte(SuperXmlNode xmlNode) throws Exception {
        this.writeStartDocument(false);
        this.writeXmlNode(xmlNode);
        return this.writeEndDocument();
    }

    public void writeXmlNode(SuperXmlNode xmlNode) throws Exception {
        this.writeStartElement(xmlNode.getPrefix(), xmlNode.getName());
        for (String key : xmlNode.getNamespaces().keySet()) {
            if (this.isEmpty(key)) {
                this.writeDefaultNamespace(xmlNode.getNamespaceValue("", this.encoding));
                continue;
            }
            this.writeNamespace(key, xmlNode.getNamespaceValue(key, this.encoding));
        }
        for (String key : xmlNode.getAttrs().keySet()) {
            this.writeAttribute(xmlNode.getAttrs().get(key).getPrefix(), key, xmlNode.getAttributeValue(key, this.encoding));
        }
        if (!this.isEmpty(xmlNode.getCdata())) {
            this.writeCharacterData(xmlNode.getCharacterData(this.encoding));
        }
        if (!this.isEmpty(xmlNode.getValue())) {
            this.writeCharacters(xmlNode.getValue(this.encoding));
        }
        boolean haveChildren = false;
        for (String key : xmlNode.getChildren().keySet()) {
            haveChildren = true;
            Object obj = xmlNode.getChildren().get(key);
            if (obj instanceof SuperXmlNode) {
                this.writeXmlNode((SuperXmlNode)obj);
                continue;
            }
            if (!(obj instanceof List)) continue;
            List tempList = (List)obj;
            for (SuperXmlNode node : tempList) {
                this.writeXmlNode(node);
            }
        }
        this.writeEndElement(xmlNode.getPrefix(), xmlNode.getName(), haveChildren);
    }

    public void writeWsdlNode(SuperXmlNode xmlNode) throws Exception {
        this.writeStartElement(xmlNode.getPrefix(), xmlNode.getName());
        for (String key : xmlNode.getNamespaces().keySet()) {
            if (this.isEmpty(key)) {
                this.writeDefaultNamespace(xmlNode.getNamespaceValue("", this.encoding));
                continue;
            }
            this.writeNamespace(key, xmlNode.getNamespaceValue(key, this.encoding));
        }
        for (String key : xmlNode.getAttrs().keySet()) {
            this.writeAttribute(xmlNode.getAttrs().get(key).getPrefix(), key, xmlNode.getAttributeValue(key, this.encoding));
        }
        if (!this.isEmpty(xmlNode.getCdata())) {
            this.writeCharacterData(xmlNode.getCharacterData(this.encoding));
        }
        if (!this.isEmpty(xmlNode.getValue())) {
            this.writeCharacters(xmlNode.getValue(this.encoding));
        }
        boolean haveChildren = false;
        for (String key : xmlNode.getChildren().keySet()) {
            haveChildren = true;
            Object obj = xmlNode.getChildren().get(key);
            if (obj instanceof SuperXmlNode) {
                this.writeXmlNode((SuperXmlNode)obj);
                continue;
            }
            if (!(obj instanceof List)) continue;
            List tempList = (List)obj;
            if (key.startsWith("element")) {
                SuperXmlNode node = (SuperXmlNode)tempList.get(0);
                node.addAttrs("minOccurs", "0");
                node.addAttrs("maxOccurs", "unbounded");
                this.writeXmlNode(node);
                continue;
            }
            for (SuperXmlNode node : tempList) {
                this.writeXmlNode(node);
            }
        }
        this.writeEndElement(xmlNode.getPrefix(), xmlNode.getName(), haveChildren);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SuperXmlNode readerShenMaXmlByStreamReader(byte[] data) throws Exception {
        LinkedList<String> nodeList = new LinkedList<String>();
        SuperXmlNode xml = null;
        SuperXmlNode node = null;
        try (XMLStreamReader reader = null;){
            reader = INPUT_FACTORY.createXMLStreamReader(new ByteArrayInputStream(data), this.encoding);
            while (reader.hasNext()) {
                int type = reader.next();
                if (!reader.isWhiteSpace()) {
                    switch (type) {
                        case 1: {
                            int i;
                            int attributeCount;
                            String nodeName = reader.getName().getLocalPart();
                            if (BT_SERVICE.equals(nodeName)) {
                                xml = new SuperXmlNode(nodeName);
                                nodeList.add(nodeName);
                                break;
                            }
                            if (BT_DATA.equals(nodeName)) {
                                attributeCount = reader.getAttributeCount();
                                for (i = 0; i < attributeCount; ++i) {
                                    if (!ATTRI_NAME.equals(reader.getAttributeLocalName(i))) continue;
                                    node = new SuperXmlNode(reader.getAttributeValue(i));
                                }
                                if (node == null) break;
                                this.getCurrentNode(xml, nodeList).addChild(node);
                                nodeList.add(node.getName());
                                break;
                            }
                            if (!BT_FIELD.equals(nodeName) || xml == null || node == null) break;
                            attributeCount = reader.getAttributeCount();
                            for (i = 0; i < attributeCount; ++i) {
                                if (ATTRI_NAME.equals(reader.getAttributeLocalName(i))) continue;
                                node.addAttrs(reader.getAttributePrefix(i), reader.getAttributeLocalName(i), reader.getAttributeValue(i));
                            }
                            int namespaceCount = reader.getNamespaceCount();
                            for (int i2 = 0; i2 < namespaceCount; ++i2) {
                                node.addNamespace(reader.getNamespacePrefix(i2), reader.getNamespaceURI(i2));
                            }
                            break;
                        }
                        case 2: {
                            if (!BT_DATA.equals(reader.getName().getLocalPart())) break;
                            nodeList.removeLast();
                            break;
                        }
                        case 4: {
                            if (node == null) break;
                            node.setValue(reader.getText());
                            break;
                        }
                        case 7: {
                            break;
                        }
                        case 8: {
                            break;
                        }
                        case 12: {
                            if (node == null) break;
                            node.setCdata(reader.getText());
                            break;
                        }
                    }
                }
            }
        }
        return xml;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SuperXmlNode readerXmlByXmlStreamReader(byte[] data) throws Exception {
        LinkedList<String> nodeList = new LinkedList<String>();
        SuperXmlNode xml = null;
        SuperXmlNode node = null;
        try (XMLStreamReader reader = null;){
            reader = INPUT_FACTORY.createXMLStreamReader(new ByteArrayInputStream(data), this.encoding);
            block11: while (reader.hasNext()) {
                int type = reader.next();
                if (reader.isWhiteSpace()) continue;
                switch (type) {
                    case 1: {
                        String nodeName = reader.getName().getLocalPart();
                        node = new SuperXmlNode(nodeName);
                        String nodePrefix = reader.getName().getPrefix();
                        node.setPrefix(nodePrefix);
                        int namespaceCount = reader.getNamespaceCount();
                        for (int i = 0; i < namespaceCount; ++i) {
                            node.addNamespace(reader.getNamespacePrefix(i), reader.getNamespaceURI(i));
                        }
                        int attributeCount = reader.getAttributeCount();
                        for (int i = 0; i < attributeCount; ++i) {
                            node.addAttrs(reader.getAttributePrefix(i), reader.getAttributeLocalName(i), reader.getAttributeValue(i));
                        }
                        if (xml == null) {
                            xml = node;
                            nodeList.add(nodeName);
                            continue block11;
                        }
                        this.getCurrentNode(xml, nodeList).addChild(node);
                        nodeList.add(nodeName);
                        continue block11;
                    }
                    case 2: {
                        nodeList.removeLast();
                        continue block11;
                    }
                    case 4: {
                        if (node == null) continue block11;
                        node.setValue(reader.getText());
                        continue block11;
                    }
                    case 7: {
                        continue block11;
                    }
                    case 8: {
                        continue block11;
                    }
                    case 12: {
                        if (node == null) continue block11;
                        node.setCdata(reader.getText());
                        continue block11;
                    }
                }
            }
        }
        return xml;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SuperXmlNode readerXml(byte[] data) throws Exception {
        LinkedList<String> nodeList = new LinkedList<String>();
        SuperXmlNode xml = null;
        SuperXmlNode node = null;
        try (XMLEventReader reader = null;){
            reader = INPUT_FACTORY.createXMLEventReader(new ByteArrayInputStream(data), this.encoding);
            while (reader.hasNext()) {
                XMLEvent event = reader.nextEvent();
                if (event.isStartDocument()) continue;
                if (event.isStartElement()) {
                    StartElement startElement = event.asStartElement();
                    String nodeName = startElement.getName().getLocalPart();
                    node = new SuperXmlNode(nodeName);
                    String nodePrefix = startElement.getName().getPrefix();
                    node.setPrefix(nodePrefix);
                    Iterator<Namespace> nameSpaces = startElement.getNamespaces();
                    Namespace nameSpace = null;
                    while (nameSpaces.hasNext()) {
                        nameSpace = nameSpaces.next();
                        node.addNamespace(nameSpace.getPrefix(), nameSpace.getNamespaceURI());
                    }
                    Iterator<Attribute> attrs = startElement.getAttributes();
                    Attribute attr = null;
                    while (attrs.hasNext()) {
                        attr = attrs.next();
                        node.addAttrs(attr.getName().getPrefix(), attr.getName().getLocalPart(), attr.getValue());
                    }
                    if (xml == null) {
                        xml = node;
                        nodeList.add(nodeName);
                        continue;
                    }
                    this.getCurrentNode(xml, nodeList).addChild(node);
                    nodeList.add(nodeName);
                    continue;
                }
                if (event.isCharacters()) {
                    String str;
                    Characters character = event.asCharacters();
                    if (character.isWhiteSpace()) continue;
                    if (character.isCData()) {
                        str = event.asCharacters().getData();
                        if (node == null) continue;
                        node.setCdata(str);
                        continue;
                    }
                    str = event.asCharacters().getData();
                    if (node == null) continue;
                    node.setValue(str);
                    continue;
                }
                if (event.isEndElement()) {
                    nodeList.removeLast();
                    continue;
                }
                if (!event.isEndDocument()) continue;
                break;
            }
        }
        return xml;
    }

    private SuperXmlNode getCurrentNode(SuperXmlNode xml, List<String> nodeList) {
        SuperXmlNode root = xml;
        if (nodeList == null) {
            return root;
        }
        for (int i = 1; i < nodeList.size(); ++i) {
            String nodeName = nodeList.get(i);
            Object obj = root.getChildren().get(nodeName);
            if (obj instanceof SuperXmlNode) {
                root = (SuperXmlNode)obj;
                continue;
            }
            if (!(obj instanceof List)) continue;
            root = (SuperXmlNode)((LinkedList)obj).getLast();
        }
        return root;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public SuperXmlTools(String encoding) {
        this.encoding = encoding;
    }

    public boolean isPackSimple() {
        return this.packSimple;
    }

    public void setPackSimple(boolean packSimple) {
        this.packSimple = packSimple;
    }

    private boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    static {
        INPUT_FACTORY.setProperty("javax.xml.stream.supportDTD", false);
        INPUT_FACTORY.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
        INPUT_FACTORY.setProperty("javax.xml.stream.isCoalescing", true);
        DIGITS = new byte[]{60, 62, 61, 34, 58, 32, 47, 38};
        LT_ESCAPE = "&lt;".getBytes();
        GT_ESCAPE = "&gt;".getBytes();
        AND_ESCAPE = "&amp;".getBytes();
        QUOT_ESCAPE = "&quot;".getBytes();
    }
}

