/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.bsp.toolkit.el.ognl;

import cn.com.yusys.yusp.bsp.toolkit.el.ognl.OgnlTools;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import ognl.ASTChain;
import ognl.ASTConst;
import ognl.ASTProperty;
import ognl.Node;
import ognl.Ognl;
import ognl.OgnlContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OgnlEnhanceUtils {
    private static final Logger logger = LoggerFactory.getLogger(OgnlEnhanceUtils.class);
    private static final Map<String, Boolean> EXPR_RESULT_MAP = new ConcurrentHashMap<String, Boolean>();

    public static Object getValue(String expr, Node ac, Map<String, Object> contextRoot) throws Exception {
        boolean isSimpleExpr;
        int childrenCount = ac.jjtGetNumChildren();
        Boolean bSimple = EXPR_RESULT_MAP.get(expr);
        if (bSimple != null) {
            isSimpleExpr = bSimple;
        } else {
            isSimpleExpr = !(ac instanceof ASTProperty) && !(ac instanceof ASTChain) ? false : OgnlEnhanceUtils.isSimpleExpr(ac, childrenCount);
            EXPR_RESULT_MAP.put(expr, isSimpleExpr);
        }
        if (!isSimpleExpr) {
            OgnlContext ognlContext = OgnlTools.getOgnlContext(contextRoot);
            return Ognl.getValue((Object)ac, (Map)ognlContext, contextRoot);
        }
        if (ac instanceof ASTProperty) {
            return contextRoot.get(expr);
        }
        return OgnlEnhanceUtils.getValue(ac, contextRoot, isSimpleExpr, childrenCount);
    }

    private static Object getValue(Node ac, Map<String, Object> contextRoot, boolean isSimpleExpr, int childrenCount) throws Exception {
        Map context = contextRoot;
        int lastIndex = OgnlEnhanceUtils.getLastNonArrayIndex(ac);
        boolean lastIsArray = lastIndex != childrenCount - 1;
        for (int i = 0; i <= lastIndex; ++i) {
            boolean isVar = i == lastIndex;
            Node n = ac.jjtGetChild(i);
            Node nn = isVar && !lastIsArray ? null : ac.jjtGetChild(i + 1);
            String cName = n.toString();
            ASTProperty np = (ASTProperty)nn;
            Object obj = context.get(cName);
            if (obj == null) {
                return null;
            }
            if (nn == null || !np.isIndexedAccess()) {
                if (isVar) {
                    return obj;
                }
                if (!(obj instanceof Map)) {
                    isSimpleExpr = false;
                    break;
                }
                context = (Map)obj;
                continue;
            }
            ASTProperty na = np;
            Object objArr = obj;
            int ai = 1;
            int base2Num = 2;
            while (i <= childrenCount - base2Num) {
                Node nt;
                ++i;
                boolean isList = OgnlEnhanceUtils.isList(cName, obj, objArr, ai);
                int index = OgnlEnhanceUtils.getIndex((Map<String, Object>)contextRoot, na, ai);
                if (isList) {
                    List list = (List)objArr;
                    if (OgnlEnhanceUtils.isArrayIndexOutOfBounds(cName, index, list.size())) {
                        return null;
                    }
                    objArr = list.get(index);
                } else {
                    int al = Array.getLength(objArr);
                    if (OgnlEnhanceUtils.isArrayIndexOutOfBounds(cName, index, al)) {
                        return null;
                    }
                    objArr = Array.get(objArr, index);
                }
                if (i > childrenCount - 2 || (nt = ac.jjtGetChild(i + 1)) == null || !((ASTProperty)nt).isIndexedAccess()) break;
                ++ai;
                na = (ASTProperty)nt;
            }
            if (isVar) {
                return objArr;
            }
            if (!(objArr instanceof Map)) {
                isSimpleExpr = false;
                break;
            }
            context = (Map)objArr;
        }
        if (isSimpleExpr) {
            return null;
        }
        OgnlContext ognlContext = OgnlTools.getOgnlContext(contextRoot);
        return Ognl.getValue((Object)ac, (Map)ognlContext, contextRoot);
    }

    private static boolean isArrayIndexOutOfBounds(String cName, int index, int size) {
        if (size <= index) {
            if (logger.isWarnEnabled()) {
                logger.warn("The index of the i-th dimension of array [" + cName + "] is out of bounds, the maximum is: [" + (size - 1) + "], the actual index:" + index);
            }
            return true;
        }
        return false;
    }

    private static int getIndex(Map<String, Object> contextRoot, ASTProperty na, int ai) throws Exception {
        int index;
        try {
            String idxExpr = na.jjtGetChild(0).toString();
            Object value = OgnlTools.getValue(idxExpr, contextRoot);
            index = value instanceof Number ? ((Number)value).intValue() : Integer.parseInt(value.toString());
        }
        catch (NumberFormatException e) {
            throw new Exception("The specified array index  " + ai + " is not an integer value:" + na.jjtGetChild(0).toString());
        }
        return index;
    }

    private static boolean isList(String cName, Object obj, Object objArr, int ai) throws Exception {
        boolean isList;
        if (objArr instanceof List) {
            isList = true;
        } else if (objArr instanceof byte[] || objArr instanceof short[] || objArr instanceof char[] || objArr instanceof int[] || objArr instanceof long[] || objArr instanceof float[] || objArr instanceof double[] || objArr instanceof Object[]) {
            isList = false;
        } else {
            throw new Exception("Variable [" + cName + "]  is not a legal array type (dimension " + ai + " is not an array) : " + obj.getClass().getName());
        }
        return isList;
    }

    private static boolean isSimpleExpr(Node ac, int childrenCount) {
        boolean isSimpleExpr = true;
        if (childrenCount > 0) {
            for (int i = 0; i < childrenCount; ++i) {
                Node node = ac.jjtGetChild(i);
                if (node instanceof ASTConst) {
                    isSimpleExpr = true;
                } else {
                    if (node instanceof ASTProperty) continue;
                    isSimpleExpr = false;
                }
                break;
            }
        } else if (!(ac instanceof ASTProperty)) {
            isSimpleExpr = false;
        }
        return isSimpleExpr;
    }

    public static void setValue(String expr, Node ac, Object value, Map<String, Object> contextRoot) throws Exception {
        if (ac instanceof ASTChain) {
            OgnlEnhanceUtils.setValue(contextRoot, (ASTChain)ac, value);
        } else if (ac instanceof ASTProperty) {
            OgnlEnhanceUtils.setValue(contextRoot, expr, value);
        } else {
            throw new Exception("Unsupported ognl assignment type:" + ac.getClass().getName());
        }
    }

    private static void setValue(Map<String, Object> contextRoot, String expr, Object value) {
        contextRoot.put(expr, value);
    }

    private static void setValue(Map<String, Object> contextRoot, ASTChain ac, Object value) throws Exception {
        Map<String, Object> context = contextRoot;
        int childrenCount = ac.jjtGetNumChildren();
        int lastIndex = OgnlEnhanceUtils.getLastNonArrayIndex((Node)ac);
        boolean lastIsArray = lastIndex != childrenCount - 1;
        block0: for (int i = 0; i <= lastIndex; ++i) {
            boolean checked;
            boolean isVar = i == lastIndex;
            Node n = ac.jjtGetChild(i);
            Node nn = isVar && !lastIsArray ? null : ac.jjtGetChild(i + 1);
            String cName = n.toString();
            boolean bl = checked = !(n instanceof ASTProperty) || nn != null && !(nn instanceof ASTProperty);
            if (checked) break;
            ASTProperty np = (ASTProperty)nn;
            if (nn == null || !np.isIndexedAccess()) {
                context = OgnlEnhanceUtils.getStringObjectMap(value, context, isVar, cName);
                continue;
            }
            ASTProperty na = np;
            Object objArr = context.get(cName);
            int ai = 1;
            int base2Num = 2;
            while (i <= childrenCount - base2Num) {
                boolean nextIsArray = false;
                Node nt = null;
                if (++i <= childrenCount - base2Num) {
                    nt = ac.jjtGetChild(i + 1);
                    nextIsArray = nt != null && ((ASTProperty)nt).isIndexedAccess();
                }
                int index = OgnlEnhanceUtils.getIndex(contextRoot, np, na);
                if (objArr == null) {
                    if (index != 0) {
                        throw new Exception("The index of the " + ai + "-th dimension of array [" + cName + "] must be continuous (expected value is 0, actual value is [" + index + "]");
                    }
                    if (nextIsArray) {
                        objArr = OgnlEnhanceUtils.nextIsArray(context, cName, index);
                    } else {
                        context = OgnlEnhanceUtils.nextIsNotArray(value, context, isVar, cName);
                    }
                } else if (nextIsArray) {
                    objArr = OgnlEnhanceUtils.nextIsArray(context, cName, objArr, ai, index);
                } else {
                    context = OgnlEnhanceUtils.nextIsNotArray(value, context, isVar, cName, objArr, ai, index);
                }
                if (i > childrenCount - 2 || !nextIsArray) continue block0;
                ++ai;
                na = (ASTProperty)nt;
            }
        }
    }

    private static int getIndex(Map<String, Object> contextRoot, ASTProperty np, ASTProperty na) throws Exception {
        int index;
        try {
            String idxExpr = na.jjtGetChild(0).toString();
            Object v = OgnlTools.getValue(idxExpr, contextRoot);
            index = v instanceof Number ? ((Number)v).intValue() : Integer.parseInt(v.toString());
        }
        catch (NumberFormatException e) {
            throw new Exception("The specified array index is not an integer value:" + np.jjtGetChild(0).toString());
        }
        return index;
    }

    private static Object nextIsArray(Map<String, Object> context, String cName, int index) {
        ArrayList list = new ArrayList();
        context.put(cName, list);
        ArrayList list2 = new ArrayList();
        list.add(index, list2);
        ArrayList objArr = list2;
        return objArr;
    }

    private static Map<String, Object> nextIsNotArray(Object value, Map<String, Object> context, boolean isVar, String cName) {
        if (isVar) {
            ArrayList<Object> list = new ArrayList<Object>();
            list.add(value);
            context.put(cName, list);
        } else {
            ArrayList<HashMap<String, Object>> list = new ArrayList<HashMap<String, Object>>();
            HashMap<String, Object> next = new HashMap<String, Object>(16);
            list.add(next);
            context.put(cName, list);
            context = next;
        }
        return context;
    }

    private static Map<String, Object> getStringObjectMap(Object value, Map<String, Object> context, boolean isVar, String cName) {
        if (isVar) {
            context.put((String)cName, (Object)value);
        } else {
            HashMap obj = context.get(cName);
            if (!(obj instanceof Map)) {
                obj = new HashMap(16);
                context.put(cName, obj);
            }
            context = obj;
        }
        return context;
    }

    private static Map<String, Object> nextIsNotArray(Object value, Map<String, Object> context, boolean isVar, String cName, Object objArr, int ai, int index) throws Exception {
        if (isVar) {
            ArrayList<Object> list;
            if (objArr instanceof List) {
                list = (ArrayList<Object>)objArr;
                if (index > list.size()) {
                    throw new Exception("The index of the " + ai + "-th dimension of array [" + cName + "] must be continuous (expected value is " + list.size() + ", actual value is [" + index + "]");
                }
            } else {
                if (index > 1) {
                    throw new Exception("The index of the " + ai + "-th dimension of array [" + cName + "] must be continuous (expected value is 0 or 1, actual value is [" + index + "]");
                }
                list = new ArrayList<Object>();
                list.add(objArr);
                if (ai == 1) {
                    context.put(cName, list);
                } else {
                    ((List)objArr).add(list);
                }
            }
            list.add(index, value);
        } else if (objArr instanceof Map) {
            if (index > 1) {
                throw new Exception("The index of the " + ai + "-th dimension of array [" + cName + "] must be continuous (expected value is 0 or 1, actual value is [" + index + "]");
            }
            ArrayList<Map> list = new ArrayList<Map>();
            list.add((Map)objArr);
            if (ai == 1) {
                context.put(cName, list);
            } else {
                ((List)objArr).add(list);
            }
            if (index == 0) {
                context = (Map)objArr;
            } else if (index == 1) {
                HashMap next = new HashMap(16);
                list.add(next);
                context = next;
            }
        } else if (objArr instanceof List) {
            List list = (List)objArr;
            if (index > list.size()) {
                throw new Exception("The index of the " + ai + "-th dimension of array [" + cName + "] must be continuous (expected value is " + list.size() + ", actual value is [" + index + "]");
            }
            if (index == list.size()) {
                HashMap next = new HashMap(16);
                list.add(next);
                context = next;
            } else {
                Object obj = list.get(index);
                if (!(obj instanceof Map)) {
                    throw new Exception("The value of the " + ai + "-th dimension of array [" + cName + "] is not a legal variable group");
                }
                context = (HashMap)obj;
            }
        } else {
            throw new Exception("Conversion of variable [" + cName + " the " + ai + "-th dimension] of type [" + objArr.getClass().getName() + "] to array is not allowed");
        }
        return context;
    }

    private static Object nextIsArray(Map<String, Object> context, String cName, Object objArr, int ai, int index) throws Exception {
        List l = new ArrayList();
        ArrayList list = null;
        if (objArr instanceof List) {
            list = objArr;
            if (index > list.size()) {
                throw new Exception("The index of the " + ai + "-th dimension of array [" + cName + "] must be continuous (expected value is " + list.size() + ", actual value is [" + index + "]");
            }
            if (index <= list.size() - 1) {
                Object o = list.get(index);
                if (o instanceof List) {
                    l = (List)o;
                } else {
                    l.add(list.remove(index));
                    list.add(index, l);
                }
            } else {
                list.add(index, l);
            }
        } else {
            if (index > 1) {
                throw new Exception("The index of the " + ai + "-th dimension of array [" + cName + "] must be continuous (expected value is 0 or 1, actual value is [" + index + "]");
            }
            list = new ArrayList();
            list.add(objArr);
            if (ai != 1) {
                throw new Exception("The " + (ai - 1) + "-th dimension element of array [" + cName + "] is not an array, changing the type is not allowed");
            }
            context.put(cName, list);
            list.add(index, l);
        }
        objArr = l;
        return objArr;
    }

    private static int getLastNonArrayIndex(Node ac) {
        Node node;
        int childrenCount = ac.jjtGetNumChildren();
        int lastIndex = childrenCount - 1;
        for (int i = childrenCount - 1; i >= 0 && (node = ac.jjtGetChild(i)) instanceof ASTProperty && ((ASTProperty)node).isIndexedAccess(); --i) {
            lastIndex = i - 1;
        }
        return lastIndex;
    }
}

