/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.bsp.toolkit.el.ognl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import ognl.ClassResolver;

public class BankitClassResolver
implements ClassResolver {
    private final Map<String, Class<?>> classes = new ConcurrentHashMap();
    private final List<String> packageList = new ArrayList<String>();
    private final List<ClassLoader> classLoaderList = new ArrayList<ClassLoader>();

    public BankitClassResolver() {
        this.packageList.add("java.lang.");
        this.packageList.add("java.util.");
        this.packageList.add("cn.com.yusys.yusp.toolkit.common.");
        this.packageList.add("cn.com.yusys.yusp.toolkit.");
        this.packageList.add("cn.com.yusys.yusp.bsp.toolkit.common.");
        this.packageList.add("cn.com.yusys.yusp.bsp.toolkit.");
        this.classLoaderList.add(this.getClass().getClassLoader());
    }

    public Class<?> classForName(String className, Map context) {
        return this.findClass(className);
    }

    private Class<?> findClass(String className) {
        Class<?> result = this.classes.get(className);
        if (result == null) {
            String packfix;
            String pkName;
            Iterator<Object> iterator = this.packageList.iterator();
            while (iterator.hasNext() && (result = this.classes.get(pkName = (packfix = (String)iterator.next()) + className)) == null) {
            }
        }
        if (result == null) {
            block5: for (ClassLoader cl : this.classLoaderList) {
                try {
                    result = cl.loadClass(className);
                    this.classes.put(className, result);
                }
                catch (ClassNotFoundException ex) {
                    for (String pack : this.packageList) {
                        try {
                            String packName = pack + className;
                            result = cl.loadClass(packName);
                            this.classes.put(packName, result);
                            continue block5;
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                        }
                    }
                }
            }
        }
        return result;
    }

    public void addPackage(String packageName) {
        this.packageList.add(packageName);
    }

    public void addClassLoader(ClassLoader cl) {
        this.classLoaderList.add(cl);
    }
}

