/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.bsp.toolkit.common;

import cn.com.yusys.yusp.bsp.toolkit.common.StringTools;
import java.security.Key;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;

public class PwdTools {
    private static final byte[] RAW_KEY_DATA = new byte[]{-83, -120, 55, -3, -77, -104, 16, 76};
    private static final String ENCODING = "UTF-8";

    public static String getEncoding() {
        return ENCODING;
    }

    public static byte[] encrypt(String username, String password) throws Exception {
        if (password == null) {
            return null;
        }
        return PwdTools.encryptData(PwdTools.getKey(username), password.getBytes(ENCODING));
    }

    public static byte[] encrypt(byte[] username, byte[] password) throws Exception {
        if (password == null) {
            return null;
        }
        return PwdTools.encryptData(PwdTools.getKey(username), password);
    }

    public static String encryptStr(String username, String password) throws Exception {
        return new String(PwdTools.encrypt(username, password));
    }

    public static String encryptStr(byte[] username, byte[] password) throws Exception {
        return new String(PwdTools.encrypt(username, password));
    }

    public static byte[] decrypt(String username, String password) throws Exception {
        if (StringTools.isEmpty(password)) {
            return new byte[0];
        }
        char base1char = '*';
        char base2char = '#';
        if (password.charAt(0) == base1char) {
            byte[] tempData = PwdTools.string2Byte(password.substring(1));
            return PwdTools.decryptData(PwdTools.getKey(username), tempData);
        }
        if (password.charAt(0) == base2char) {
            byte[] tempData = PwdTools.string2Byte(password.substring(1));
            return PwdTools.decryptData(RAW_KEY_DATA, tempData);
        }
        return password.getBytes();
    }

    public static byte[] decrypt(byte[] username, byte[] password) throws Exception {
        if (password == null || password.length == 0) {
            return password;
        }
        byte base1char = 42;
        byte base2char = 35;
        if (password[0] == base1char) {
            byte[] tempData = PwdTools.string2Byte(new String(password).substring(1));
            return PwdTools.decryptData(PwdTools.getKey(username), tempData);
        }
        if (password[0] == base2char) {
            byte[] tempData = PwdTools.string2Byte(new String(password).substring(1));
            return PwdTools.decryptData(RAW_KEY_DATA, tempData);
        }
        return password;
    }

    public static String decryptStr(String username, String password) throws Exception {
        byte[] decryedData = PwdTools.decrypt(username, password);
        if (decryedData == null || decryedData.length == 0) {
            return "";
        }
        return new String(decryedData, ENCODING);
    }

    public static String decryptStr(byte[] username, byte[] password) throws Exception {
        byte[] decryedData = PwdTools.decrypt(username, password);
        if (decryedData == null || decryedData.length == 0) {
            return "";
        }
        return new String(decryedData, ENCODING);
    }

    private static byte[] getKey(byte[] username) {
        if (username == null || username.length == 0) {
            return RAW_KEY_DATA;
        }
        byte[] bsUserNameKey = new byte[8];
        System.arraycopy(RAW_KEY_DATA, 0, bsUserNameKey, 0, 8);
        for (int i = 0; i < username.length; ++i) {
            bsUserNameKey[i % 8] = (byte)((bsUserNameKey[i % 8] | username[i]) ^ bsUserNameKey[i % 8] & username[i]);
        }
        return bsUserNameKey;
    }

    private static byte[] getKey(String username) throws Exception {
        if (username == null || username.length() == 0) {
            return RAW_KEY_DATA;
        }
        return PwdTools.getKey(username.getBytes(ENCODING));
    }

    private static byte[] encryptData(byte[] key, byte[] data) throws Exception {
        SecureRandom sr = new SecureRandom();
        DESKeySpec dks = new DESKeySpec(key);
        SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("DES");
        SecretKey skey = keyFactory.generateSecret(dks);
        int base8Num = 8;
        Cipher cipher = data.length % base8Num == 0 ? Cipher.getInstance("DES/ECB/NoPadding") : Cipher.getInstance("DES");
        cipher.init(1, (Key)skey, sr);
        byte[] encryedData = cipher.doFinal(data);
        String hexString = PwdTools.byte2String(encryedData);
        hexString = "*" + hexString;
        return hexString.getBytes();
    }

    private static byte[] decryptData(byte[] key, byte[] data) throws Exception {
        SecureRandom sr = new SecureRandom();
        DESKeySpec dks = new DESKeySpec(key);
        SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("DES");
        SecretKey skey = keyFactory.generateSecret(dks);
        Cipher cipher = Cipher.getInstance("DES");
        cipher.init(2, (Key)skey, sr);
        try {
            return cipher.doFinal(data);
        }
        catch (Exception e) {
            cipher = Cipher.getInstance("DES/ECB/NoPadding");
            cipher.init(2, (Key)skey, sr);
            return cipher.doFinal(data);
        }
    }

    private static byte[] string2Byte(String srcData) throws Exception {
        int base2Num = 2;
        if (srcData == null) {
            return null;
        }
        if (srcData.length() % base2Num != 0) {
            throw new Exception("The length of the source data is odd:" + srcData.length());
        }
        int len = srcData.length() / base2Num;
        byte[] newData = new byte[len];
        for (int i = 0; i < len; ++i) {
            newData[i] = (byte)(Character.digit(srcData.charAt(i * 2), 16) << 4 ^ Character.digit(srcData.charAt(i * 2 + 1), 16));
        }
        return newData;
    }

    private static String byte2String(byte[] data) {
        if (data == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        for (byte datum : data) {
            String tmpStr = Integer.toHexString(datum & 0xFF);
            tmpStr = PwdTools.leftPad2DoubleChar(tmpStr);
            builder.append(tmpStr);
        }
        return builder.toString().toUpperCase();
    }

    private static String leftPad2DoubleChar(String data) {
        int base2Num;
        int len = data.length();
        if (len >= (base2Num = 2)) {
            return data;
        }
        if (data.length() == 1) {
            return "0" + data;
        }
        return "00";
    }
}

